/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.xml.jaxb.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.drools.core.QueryResultsImpl;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.runtime.rule.impl.FlatQueryResults;
import org.drools.core.xml.jaxb.util.JaxbListWrapper;
import org.drools.core.xml.jaxb.util.JaxbStringObjectPair;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbUnknownAdapter
extends XmlAdapter<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(JaxbUnknownAdapter.class);
    private static final Object PRESENT = new Object();

    public Object marshal(Object o) throws Exception {
        return this.recursiveMarshal(o, new IdentityHashMap<Object, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object recursiveMarshal(Object o, Map<Object, Object> seenObjectsMap) {
        if (seenObjectsMap.put(o, PRESENT) != null) {
            throw new UnsupportedOperationException("Serialization of recursive data structures is not supported!");
        }
        try {
            if (o instanceof List) {
                List list = (List)o;
                Object[] serializedArr = this.convertCollectionToSerializedArray(list, seenObjectsMap);
                JaxbListWrapper jaxbListWrapper = new JaxbListWrapper(serializedArr, JaxbListWrapper.JaxbWrapperType.LIST);
                return jaxbListWrapper;
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                Object[] serializedArr = this.convertCollectionToSerializedArray(set, seenObjectsMap);
                JaxbListWrapper jaxbListWrapper = new JaxbListWrapper(serializedArr, JaxbListWrapper.JaxbWrapperType.SET);
                return jaxbListWrapper;
            }
            if (o instanceof Map) {
                Map map = (Map)o;
                List<JaxbStringObjectPair> pairList = new ArrayList(map.size());
                if (map == null || map.isEmpty()) {
                    pairList = Collections.EMPTY_LIST;
                }
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    if (key != null && !(key instanceof String)) {
                        throw new UnsupportedOperationException("Only String keys for Map structures are supported [key was a " + key.getClass().getName() + "]");
                    }
                    Object value = this.convertObjectToSerializableVariant(entry.getValue(), seenObjectsMap);
                    pairList.add(new JaxbStringObjectPair((String)key, value));
                }
                JaxbListWrapper jaxbListWrapper = new JaxbListWrapper(pairList.toArray(new JaxbStringObjectPair[pairList.size()]), JaxbListWrapper.JaxbWrapperType.MAP);
                return jaxbListWrapper;
            }
            Object object = o;
            return object;
        }
        finally {
            seenObjectsMap.remove(o);
        }
    }

    private Object[] convertCollectionToSerializedArray(Collection collection, Map<Object, Object> seenObjectsMap) {
        ArrayList serializedList = new ArrayList(collection.size());
        for (Object elem : collection) {
            elem = this.convertObjectToSerializableVariant(elem, seenObjectsMap);
            serializedList.add(elem);
        }
        return serializedList.toArray(new Object[serializedList.size()]);
    }

    private Object convertObjectToSerializableVariant(Object obj, Map<Object, Object> seenObjectsMap) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof QueryResultsImpl) {
            obj = new FlatQueryResults((QueryResultsImpl)obj);
        } else if (obj instanceof FactHandle) {
            obj = ((InternalFactHandle)obj).toExternalForm();
        } else if (!(obj instanceof JaxbListWrapper) && (obj instanceof Collection || obj instanceof Map)) {
            obj = this.recursiveMarshal(obj, seenObjectsMap);
        }
        return obj;
    }

    public Object unmarshal(Object o) throws Exception {
        if (o instanceof JaxbListWrapper) {
            JaxbListWrapper wrapper = (JaxbListWrapper)o;
            Object[] elements = wrapper.getElements();
            int size = 0;
            if (elements != null) {
                size = elements.length;
            }
            if (wrapper.getType() == null) {
                ArrayList list = new ArrayList(size);
                return this.convertSerializedElementsToCollection(elements, list);
            }
            switch (wrapper.getType()) {
                case LIST: {
                    ArrayList list = new ArrayList(size);
                    return this.convertSerializedElementsToCollection(elements, list);
                }
                case SET: {
                    HashSet set = new HashSet(size);
                    return this.convertSerializedElementsToCollection(elements, set);
                }
                case MAP: {
                    HashMap<String, Object> map = new HashMap<String, Object>(size);
                    if (size > 0) {
                        for (Object keyValueObj : elements) {
                            JaxbStringObjectPair keyValue = (JaxbStringObjectPair)keyValueObj;
                            String key = keyValue.getKey();
                            Object value = this.convertSerializedObjectToObject(keyValue.getValue());
                            map.put(key.toString(), value);
                        }
                    }
                    return map;
                }
            }
            throw new IllegalArgumentException("Unknown JAXB collection wrapper type: " + wrapper.getType().toString());
        }
        if (o instanceof JaxbStringObjectPair[]) {
            JaxbStringObjectPair[] value = (JaxbStringObjectPair[])o;
            HashMap<String, Object> r = new HashMap<String, Object>();
            for (JaxbStringObjectPair p : value) {
                if (p.getValue() instanceof JaxbListWrapper) {
                    r.put(p.getKey(), new ArrayList<Object>(Arrays.asList(((JaxbListWrapper)p.getValue()).getElements())));
                    continue;
                }
                r.put(p.getKey(), p.getValue());
            }
            return r;
        }
        return o;
    }

    private Collection convertSerializedElementsToCollection(Object[] elements, Collection collection) throws Exception {
        ArrayList<Object> list;
        if (elements == null) {
            list = Collections.EMPTY_LIST;
        } else {
            list = new ArrayList<Object>(elements.length);
            for (Object elem : elements) {
                elem = this.convertSerializedObjectToObject(elem);
                list.add(elem);
            }
        }
        collection.addAll(list);
        return collection;
    }

    private Object convertSerializedObjectToObject(Object element) throws Exception {
        if (element == null) {
            return element;
        }
        if (element instanceof JaxbListWrapper) {
            element = this.unmarshal(element);
        }
        return element;
    }
}

