/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Method;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.impl.refl.nodes.GetterAccessor;
import org.mvel2.optimizers.impl.refl.nodes.InvokableAccessor;
import org.mvel2.util.ParseTools;

public class MethodAccessor
extends InvokableAccessor {
    private Method method;

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (!this.coercionNeeded) {
            try {
                if (this.nextNode != null) {
                    return this.nextNode.getValue(this.method.invoke(ctx, this.executeAll(elCtx, vars, this.method)), elCtx, vars);
                }
                return this.method.invoke(ctx, this.executeAll(elCtx, vars, this.method));
            }
            catch (IllegalArgumentException e) {
                Method o;
                if (ctx != null && this.method.getDeclaringClass() != ctx.getClass() && (o = ParseTools.getBestCandidate(this.parameterTypes, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), true)) != null) {
                    return this.executeOverrideTarget(ParseTools.getWidenedTarget(o), ctx, elCtx, vars);
                }
                this.coercionNeeded = true;
                return this.getValue(ctx, elCtx, vars);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot invoke method: " + this.method.getName(), e);
            }
        }
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.method.invoke(ctx, this.executeAndCoerce(this.parameterTypes, elCtx, vars, this.method.isVarArgs())), elCtx, vars);
            }
            return this.method.invoke(ctx, this.executeAndCoerce(this.parameterTypes, elCtx, vars, this.method.isVarArgs()));
        }
        catch (IllegalArgumentException e) {
            Object[] vs = this.executeAndCoerce(this.parameterTypes, elCtx, vars, false);
            Method newMeth = ParseTools.getWidenedTarget(ParseTools.getBestCandidate(vs, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), false));
            if (newMeth != null) {
                return this.executeOverrideTarget(newMeth, ctx, elCtx, vars);
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot invoke method: " + this.method.getName(), e);
        }
    }

    private Object executeOverrideTarget(Method o, Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (!this.coercionNeeded) {
            try {
                try {
                    if (this.nextNode != null) {
                        return this.nextNode.getValue(o.invoke(ctx, this.executeAll(elCtx, vars, o)), elCtx, vars);
                    }
                    return o.invoke(ctx, this.executeAll(elCtx, vars, o));
                }
                catch (IllegalArgumentException e) {
                    if (this.coercionNeeded) {
                        throw e;
                    }
                    this.coercionNeeded = true;
                    return this.executeOverrideTarget(o, ctx, elCtx, vars);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException("unable to invoke method", e2);
            }
        }
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(o.invoke(ctx, this.executeAndCoerce(o.getParameterTypes(), elCtx, vars, o.isVarArgs())), elCtx, vars);
            }
            return o.invoke(ctx, this.executeAndCoerce(o.getParameterTypes(), elCtx, vars, o.isVarArgs()));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to invoke method (expected target: " + this.method.getDeclaringClass().getName() + "::" + this.method.getName() + "; " + "actual target: " + ctx.getClass().getName() + "::" + this.method.getName() + "; coercionNeeded=" + (this.coercionNeeded ? "yes" : "no") + ")");
        }
        catch (Exception e2) {
            throw new RuntimeException("unable to invoke method (expected target: " + this.method.getDeclaringClass().getName() + "::" + this.method.getName() + "; " + "actual target: " + ctx.getClass().getName() + "::" + this.method.getName() + "; coercionNeeded=" + (this.coercionNeeded ? "yes" : "no") + ")");
        }
    }

    private Object[] executeAll(Object ctx, VariableResolverFactory vars, Method m) {
        if (this.length == 0) {
            return GetterAccessor.EMPTY;
        }
        Object[] vals = new Object[this.length];
        for (int i = 0; i < this.length - (m.isVarArgs() ? 1 : 0); ++i) {
            vals[i] = this.parms[i].getValue(ctx, vars);
        }
        if (m.isVarArgs()) {
            if (this.parms == null) {
                vals[this.length - 1] = new Object[0];
            } else if (this.parms.length == this.length) {
                Object[] objectArray;
                Object[] lastParam = this.parms[this.length - 1].getValue(ctx, vars);
                if (lastParam == null || lastParam.getClass().isArray()) {
                    objectArray = lastParam;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = lastParam;
                }
                vals[this.length - 1] = objectArray;
            } else {
                Object[] vararg = new Object[this.parms.length - this.length + 1];
                for (int i = 0; i < vararg.length; ++i) {
                    vararg[i] = this.parms[this.length - 1 + i].getValue(ctx, vars);
                }
                vals[this.length - 1] = vararg;
            }
        }
        return vals;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.parameterTypes = this.method.getParameterTypes();
        this.length = this.parameterTypes.length;
    }

    public ExecutableStatement[] getParms() {
        return this.parms;
    }

    public void setParms(ExecutableStatement[] parms) {
        this.parms = parms;
    }

    public MethodAccessor() {
    }

    public MethodAccessor(Method method, ExecutableStatement[] parms) {
        this.setMethod(method);
        this.parms = parms;
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        try {
            return this.nextNode.setValue(this.method.invoke(ctx, this.executeAll(elCtx, variableFactory, this.method)), elCtx, variableFactory, value);
        }
        catch (IllegalArgumentException e) {
            Method o;
            if (ctx != null && this.method.getDeclaringClass() != ctx.getClass() && (o = ParseTools.getBestCandidate(this.parameterTypes, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), true)) != null) {
                return this.nextNode.setValue(this.executeOverrideTarget(o, ctx, elCtx, variableFactory), elCtx, variableFactory, value);
            }
            this.coercionNeeded = true;
            return this.setValue(ctx, elCtx, variableFactory, value);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot invoke method", e);
        }
    }

    public Class getKnownEgressType() {
        return this.method.getReturnType();
    }
}

