/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.List;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.LinkedList;

public class PhreakQueryTerminalNode {
    public void doNode(QueryTerminalNode qtnNode, InternalWorkingMemory wm, TupleSets<LeftTuple> srcLeftTuples, LinkedList<StackEntry> stack) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(qtnNode, wm, srcLeftTuples, stack);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(qtnNode, wm, srcLeftTuples, stack);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(qtnNode, wm, srcLeftTuples, stack);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(QueryTerminalNode qtnNode, InternalWorkingMemory wm, TupleSets<LeftTuple> srcLeftTuples, LinkedList<StackEntry> stack) {
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            PropagationContext pCtx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, leftTuple.getPropagationContext());
            Tuple rootEntry = leftTuple.getRootTuple();
            DroolsQuery dquery = (DroolsQuery)rootEntry.getFactHandle().getObject();
            dquery.setQuery(qtnNode.getQuery());
            if (dquery.getStackEntry() != null) {
                PhreakQueryTerminalNode.checkAndTriggerQueryReevaluation(wm, stack, rootEntry, dquery);
            }
            dquery.getQueryResultCollector().rowAdded(qtnNode.getQuery(), leftTuple, pCtx, wm);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(QueryTerminalNode qtnNode, InternalWorkingMemory wm, TupleSets<LeftTuple> srcLeftTuples, LinkedList<StackEntry> stack) {
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            PropagationContext pCtx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, leftTuple.getPropagationContext());
            LeftTuple rootEntry = leftTuple;
            while (rootEntry.getParent() != null) {
                rootEntry = rootEntry.getParent();
            }
            DroolsQuery dquery = (DroolsQuery)rootEntry.getFactHandle().getObject();
            dquery.setQuery(qtnNode.getQuery());
            if (dquery.getStackEntry() != null) {
                PhreakQueryTerminalNode.checkAndTriggerQueryReevaluation(wm, stack, rootEntry, dquery);
            }
            dquery.getQueryResultCollector().rowUpdated(qtnNode.getQuery(), leftTuple, pCtx, wm);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(QueryTerminalNode qtnNode, InternalWorkingMemory wm, TupleSets<LeftTuple> srcLeftTuples, LinkedList<StackEntry> stack) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            PropagationContext pCtx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, leftTuple.getPropagationContext());
            LeftTuple rootEntry = leftTuple;
            while (rootEntry.getParent() != null) {
                rootEntry = rootEntry.getParent();
            }
            DroolsQuery dquery = (DroolsQuery)rootEntry.getFactHandle().getObject();
            dquery.setQuery(qtnNode.getQuery());
            if (dquery.getStackEntry() != null) {
                PhreakQueryTerminalNode.checkAndTriggerQueryReevaluation(wm, stack, rootEntry, dquery);
            }
            dquery.getQueryResultCollector().rowRemoved(qtnNode.getQuery(), leftTuple, pCtx, wm);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void checkAndTriggerQueryReevaluation(InternalWorkingMemory wm, LinkedList<StackEntry> stack, Tuple rootEntry, DroolsQuery dquery) {
        StackEntry stackEntry = dquery.getStackEntry();
        if (!PhreakQueryTerminalNode.isAdded(stack, stackEntry)) {
            ((QueryElementNode.QueryElementNodeMemory)stackEntry.getNodeMem()).setNodeDirtyWithoutNotify();
            if (stackEntry.getLiaNode() == ((LeftTupleSink)rootEntry.getTupleSink()).getLeftTupleSource()) {
                stack.add(stackEntry);
            } else {
                List<PathMemory> pmems = dquery.getRuleMemories();
                if (pmems != null) {
                    int length = pmems.size();
                    for (int i = 0; i < length; ++i) {
                        PathMemory pmem = pmems.get(i);
                        pmem.doLinkRule(wm);
                    }
                }
            }
        }
    }

    public static boolean isAdded(LinkedList<StackEntry> stack, StackEntry stackEntry) {
        return stackEntry == null || stackEntry.getPrevious() != null || stackEntry.getNext() != null || stack.getFirst() == stackEntry;
    }
}

