/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.factorybeans;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.Agenda;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.api.time.SessionClock;
import org.kie.aries.blueprint.factorybeans.AbstractKieObjectsResolver;
import org.kie.aries.blueprint.factorybeans.KSessionOptions;
import org.kie.aries.blueprint.factorybeans.KieListenerAdaptor;
import org.kie.aries.blueprint.factorybeans.KieLoggerAdaptor;
import org.kie.aries.blueprint.factorybeans.KieSessionFactoryBeanHelper;
import org.kie.aries.blueprint.namespace.BlueprintContextHelper;

public class KieSessionResolver
extends AbstractKieObjectsResolver
implements KieSession,
StatelessKieSession {
    private KieSession kieSession;
    private StatelessKieSession statelessKieSession;
    private final List<KieListenerAdaptor> listeners;
    private final List<KieLoggerAdaptor> loggers;
    private final List<?> commands;
    private final KSessionOptions kSessionOptions;

    public KieSessionResolver(ReleaseId releaseId, List<KieListenerAdaptor> listeners, List<KieLoggerAdaptor> loggers, List<?> commands, KSessionOptions kSessionOptions) {
        super(releaseId);
        this.listeners = listeners;
        this.loggers = loggers;
        this.commands = commands;
        this.kSessionOptions = kSessionOptions;
    }

    @Override
    public Object init(BlueprintContextHelper context) {
        return this.getSession();
    }

    private synchronized Object getSession() {
        StatelessKieSession obj;
        boolean stateless = this.isStateless();
        if (stateless) {
            if (this.statelessKieSession != null) {
                return this.statelessKieSession;
            }
        } else if (this.kieSession != null) {
            return this.kieSession;
        }
        if (stateless) {
            obj = this.statelessKieSession = this.newStatelessSession(this.kSessionOptions.getkBaseRef(), this.releaseId, null);
        } else {
            this.kieSession = this.newStatefulSession(this.kSessionOptions.getkBaseRef(), this.releaseId, null);
            KieSessionFactoryBeanHelper.executeCommands(this.kieSession, this.commands);
            obj = this.kieSession;
        }
        KieSessionFactoryBeanHelper.addListeners((KieRuntimeEventManager)obj, this.listeners);
        KieSessionFactoryBeanHelper.attachLoggers((KieRuntimeEventManager)obj, this.loggers);
        return obj;
    }

    private boolean isStateless() {
        return "stateless".equalsIgnoreCase(this.kSessionOptions.getType());
    }

    private KieSession getKieSession() {
        return (KieSession)this.getSession();
    }

    private StatelessKieSession getStatelessKieSession() {
        return (StatelessKieSession)this.getSession();
    }

    public int getId() {
        return this.getKieSession().getId();
    }

    public long getIdentifier() {
        return this.getKieSession().getIdentifier();
    }

    public void dispose() {
        this.getKieSession().dispose();
    }

    public void destroy() {
        this.getKieSession().destroy();
    }

    public <T> T execute(Command<T> command) {
        return (T)((CommandExecutor)this.getSession()).execute(command);
    }

    public <T extends SessionClock> T getSessionClock() {
        return (T)this.getKieSession().getSessionClock();
    }

    public void setGlobal(String identifier, Object value) {
        if (this.isStateless()) {
            this.getStatelessKieSession().setGlobal(identifier, value);
        } else {
            this.getKieSession().setGlobal(identifier, value);
        }
    }

    public Object getGlobal(String identifier) {
        return this.getKieSession().getGlobal(identifier);
    }

    public Globals getGlobals() {
        if (this.isStateless()) {
            return this.getStatelessKieSession().getGlobals();
        }
        return this.getKieSession().getGlobals();
    }

    public Calendars getCalendars() {
        return this.getKieSession().getCalendars();
    }

    public Environment getEnvironment() {
        return this.getKieSession().getEnvironment();
    }

    public KieBase getKieBase() {
        if (this.isStateless()) {
            return this.getStatelessKieSession().getKieBase();
        }
        return this.getKieSession().getKieBase();
    }

    public void registerChannel(String name, Channel channel) {
        if (this.isStateless()) {
            this.getStatelessKieSession().registerChannel(name, channel);
        } else {
            this.getKieSession().registerChannel(name, channel);
        }
    }

    public void unregisterChannel(String name) {
        if (this.isStateless()) {
            this.getStatelessKieSession().unregisterChannel(name);
        } else {
            this.getKieSession().unregisterChannel(name);
        }
    }

    public Map<String, Channel> getChannels() {
        if (this.isStateless()) {
            return this.getStatelessKieSession().getChannels();
        }
        return this.getKieSession().getChannels();
    }

    public KieSessionConfiguration getSessionConfiguration() {
        return this.getKieSession().getSessionConfiguration();
    }

    public void halt() {
        this.getKieSession().halt();
    }

    public Agenda getAgenda() {
        return this.getKieSession().getAgenda();
    }

    public EntryPoint getEntryPoint(String name) {
        return this.getKieSession().getEntryPoint(name);
    }

    public Collection<? extends EntryPoint> getEntryPoints() {
        return this.getKieSession().getEntryPoints();
    }

    public QueryResults getQueryResults(String query, Object ... arguments) {
        return this.getKieSession().getQueryResults(query, arguments);
    }

    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        return this.getKieSession().openLiveQuery(query, arguments, listener);
    }

    public String getEntryPointId() {
        return this.getKieSession().getEntryPointId();
    }

    public FactHandle insert(Object object) {
        return this.getKieSession().insert(object);
    }

    public void retract(FactHandle handle) {
        this.getKieSession().retract(handle);
    }

    public void delete(FactHandle handle) {
        this.getKieSession().delete(handle);
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        this.getKieSession().delete(handle, fhState);
    }

    public void update(FactHandle handle, Object object) {
        this.getKieSession().update(handle, object);
    }

    public FactHandle getFactHandle(Object object) {
        return this.getKieSession().getFactHandle(object);
    }

    public Object getObject(FactHandle factHandle) {
        return this.getKieSession().getObject(factHandle);
    }

    public Collection<? extends Object> getObjects() {
        return this.getKieSession().getObjects();
    }

    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        return this.getKieSession().getObjects(filter);
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return this.getKieSession().getFactHandles();
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return this.getKieSession().getFactHandles(filter);
    }

    public long getFactCount() {
        return this.getKieSession().getFactCount();
    }

    public KieRuntimeLogger getLogger() {
        return this.getKieSession().getLogger();
    }

    public void addEventListener(ProcessEventListener listener) {
        this.getKieSession().addEventListener(listener);
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.getKieSession().removeEventListener(listener);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.getKieSession().getProcessEventListeners();
    }

    public ProcessInstance startProcess(String processId) {
        return this.getKieSession().startProcess(processId);
    }

    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.getKieSession().startProcess(processId, parameters);
    }

    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.getKieSession().createProcessInstance(processId, parameters);
    }

    public ProcessInstance startProcessInstance(long processInstanceId) {
        return this.getKieSession().startProcessInstance(processInstanceId);
    }

    public void signalEvent(String type, Object event) {
        this.getKieSession().signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        this.getKieSession().signalEvent(type, event, processInstanceId);
    }

    public Collection<ProcessInstance> getProcessInstances() {
        return this.getKieSession().getProcessInstances();
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        return this.getKieSession().getProcessInstance(processInstanceId);
    }

    public ProcessInstance getProcessInstance(long processInstanceId, boolean readonly) {
        return this.getKieSession().getProcessInstance(processInstanceId, readonly);
    }

    public void abortProcessInstance(long processInstanceId) {
        this.getKieSession().abortProcessInstance(processInstanceId);
    }

    public WorkItemManager getWorkItemManager() {
        return this.getKieSession().getWorkItemManager();
    }

    public void addEventListener(RuleRuntimeEventListener listener) {
        this.getKieSession().addEventListener(listener);
    }

    public void removeEventListener(RuleRuntimeEventListener listener) {
        this.getKieSession().removeEventListener(listener);
    }

    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return this.getKieSession().getRuleRuntimeEventListeners();
    }

    public void addEventListener(AgendaEventListener listener) {
        this.getKieSession().addEventListener(listener);
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.getKieSession().removeEventListener(listener);
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return this.getKieSession().getAgendaEventListeners();
    }

    public int fireAllRules() {
        return this.getKieSession().fireAllRules();
    }

    public int fireAllRules(int max) {
        return this.getKieSession().fireAllRules(max);
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        return this.getKieSession().fireAllRules(agendaFilter);
    }

    public int fireAllRules(AgendaFilter agendaFilter, int max) {
        return this.getKieSession().fireAllRules(agendaFilter, max);
    }

    public void fireUntilHalt() {
        this.getKieSession().fireUntilHalt();
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.getKieSession().fireUntilHalt(agendaFilter);
    }

    public void execute(Object object) {
        this.getStatelessKieSession().execute(object);
    }

    public void execute(Iterable objects) {
        this.getStatelessKieSession().execute(objects);
    }
}

