/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Properties;
import org.drools.core.BeliefSystemType;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.TimerJobFactoryType;
import org.drools.core.process.instance.WorkItemManagerFactory;
import org.drools.core.time.TimerService;
import org.drools.core.util.ClassUtils;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.conf.QueryListenerOption;
import org.kie.api.runtime.conf.TimedRuleExecutionFilter;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.runtime.conf.ForceEagerActivationFilter;

public class SessionConfigurationDelegate
extends SessionConfiguration {
    private final SessionConfiguration delegate = SessionConfiguration.getDefaultInstance();
    private ClockType clockType;
    private BeliefSystemType beliefSystemType;
    private Boolean keepReference;
    private ForceEagerActivationFilter forceEagerActivationFilter;
    private TimedRuleExecutionFilter timedRuleExecutionFilter;
    private QueryListenerOption queryListener;
    private TimerJobFactoryType timerJobFactoryType;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.clockType);
        out.writeObject((Object)this.beliefSystemType);
        out.writeObject(this.keepReference);
        out.writeObject(this.queryListener);
        out.writeObject((Object)this.timerJobFactoryType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clockType = (ClockType)((Object)in.readObject());
        this.beliefSystemType = (BeliefSystemType)((Object)in.readObject());
        this.keepReference = (Boolean)in.readObject();
        this.queryListener = (QueryListenerOption)in.readObject();
        try {
            this.timerJobFactoryType = (TimerJobFactoryType)((Object)in.readObject());
        }
        catch (InvalidObjectException e) {
            if (e.getMessage().contains("DEFUALT")) {
                this.timerJobFactoryType = TimerJobFactoryType.DEFAULT;
            }
            throw e;
        }
    }

    @Override
    public SessionConfigurationImpl addDefaultProperties(Properties properties) {
        SessionConfigurationImpl conf = this.cloneSessionConfiguration();
        conf.addDefaultProperties(properties);
        return conf;
    }

    private SessionConfigurationImpl cloneSessionConfiguration() {
        SessionConfigurationImpl conf = new SessionConfigurationImpl();
        conf.setClockType(this.getClockType());
        conf.setBeliefSystemType(this.getBeliefSystemType());
        conf.setKeepReference(this.isKeepReference());
        conf.setForceEagerActivationFilter(this.getForceEagerActivationFilter());
        conf.setTimedRuleExecutionFilter(this.getTimedRuleExecutionFilter());
        conf.setQueryListenerOption(this.getQueryListenerOption());
        conf.setTimerJobFactoryType(this.getTimerJobFactoryType());
        return conf;
    }

    @Override
    public void setKeepReference(boolean keepReference) {
        if (this.isKeepReference() != keepReference) {
            this.keepReference = keepReference;
        }
    }

    @Override
    public boolean isKeepReference() {
        return this.keepReference != null ? this.keepReference.booleanValue() : this.delegate.isKeepReference();
    }

    @Override
    public void setForceEagerActivationFilter(ForceEagerActivationFilter forceEagerActivationFilter) {
        if (!ClassUtils.areNullSafeEquals(this.getForceEagerActivationFilter(), forceEagerActivationFilter)) {
            this.forceEagerActivationFilter = forceEagerActivationFilter;
        }
    }

    @Override
    public ForceEagerActivationFilter getForceEagerActivationFilter() {
        return this.forceEagerActivationFilter != null ? this.forceEagerActivationFilter : this.delegate.getForceEagerActivationFilter();
    }

    @Override
    public void setTimedRuleExecutionFilter(TimedRuleExecutionFilter timedRuleExecutionFilter) {
        if (!ClassUtils.areNullSafeEquals(this.getTimedRuleExecutionFilter(), timedRuleExecutionFilter)) {
            this.timedRuleExecutionFilter = timedRuleExecutionFilter;
        }
    }

    @Override
    public TimedRuleExecutionFilter getTimedRuleExecutionFilter() {
        return this.timedRuleExecutionFilter != null ? this.timedRuleExecutionFilter : this.delegate.getTimedRuleExecutionFilter();
    }

    @Override
    public BeliefSystemType getBeliefSystemType() {
        return this.beliefSystemType != null ? this.beliefSystemType : this.delegate.getBeliefSystemType();
    }

    @Override
    public void setBeliefSystemType(BeliefSystemType beliefSystemType) {
        if (this.getBeliefSystemType() != beliefSystemType) {
            this.beliefSystemType = beliefSystemType;
        }
    }

    @Override
    public ClockType getClockType() {
        return this.clockType != null ? this.clockType : this.delegate.getClockType();
    }

    @Override
    public void setClockType(ClockType clockType) {
        if (this.getClockType() != clockType) {
            this.clockType = clockType;
        }
    }

    @Override
    public TimerJobFactoryType getTimerJobFactoryType() {
        return this.timerJobFactoryType != null ? this.timerJobFactoryType : this.delegate.getTimerJobFactoryType();
    }

    @Override
    public void setTimerJobFactoryType(TimerJobFactoryType timerJobFactoryType) {
        if (this.getTimerJobFactoryType() != timerJobFactoryType) {
            this.timerJobFactoryType = timerJobFactoryType;
        }
    }

    @Override
    public QueryListenerOption getQueryListenerOption() {
        return this.queryListener != null ? this.queryListener : this.delegate.getQueryListenerOption();
    }

    @Override
    public void setQueryListenerOption(QueryListenerOption queryListener) {
        if (this.getQueryListenerOption() != queryListener) {
            this.queryListener = queryListener;
        }
    }

    @Override
    public Map<String, WorkItemHandler> getWorkItemHandlers() {
        return this.delegate.getWorkItemHandlers();
    }

    @Override
    public Map<String, WorkItemHandler> getWorkItemHandlers(Map<String, Object> params) {
        return this.delegate.getWorkItemHandlers(params);
    }

    @Override
    public WorkItemManagerFactory getWorkItemManagerFactory() {
        return this.delegate.getWorkItemManagerFactory();
    }

    @Override
    public String getProcessInstanceManagerFactory() {
        return this.delegate.getProcessInstanceManagerFactory();
    }

    @Override
    public String getSignalManagerFactory() {
        return this.delegate.getSignalManagerFactory();
    }

    @Override
    public ExecutableRunner getRunner(KnowledgeBase kbase, Environment environment) {
        return this.delegate.getRunner(kbase, environment);
    }

    @Override
    public TimerService newTimerService() {
        return this.delegate.newTimerService();
    }
}

