/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigInteger;
import org.kie.api.runtime.rule.AccumulateFunction;

public class BigIntegerSumAccumulateFunction
implements AccumulateFunction {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Serializable createContext() {
        return new SumData();
    }

    public void init(Serializable context) {
        SumData data = (SumData)context;
        data.total = BigInteger.ZERO;
    }

    public void accumulate(Serializable context, Object value) {
        if (value != null) {
            SumData data = (SumData)context;
            data.total = data.total.add((BigInteger)value);
        }
    }

    public void reverse(Serializable context, Object value) {
        if (value != null) {
            SumData data = (SumData)context;
            data.total = data.total.subtract((BigInteger)value);
        }
    }

    public Object getResult(Serializable context) {
        SumData data = (SumData)context;
        return data.total;
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return BigInteger.class;
    }

    protected static class SumData
    implements Externalizable {
        public BigInteger total = BigInteger.ZERO;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = (BigInteger)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.total);
        }
    }
}

