/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.WrappedStatefulKnowledgeSessionForRHS;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.beliefsystem.simple.SimpleMode;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Tuple;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.kie.internal.runtime.beliefs.Mode;

public class DefaultKnowledgeHelper<T extends ModedAssertion<T>>
implements KnowledgeHelper,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Activation activation;
    private Tuple tuple;
    private WrappedStatefulKnowledgeSessionForRHS workingMemory;
    private LinkedList<LogicalDependency<T>> previousJustified;
    private LinkedList<LogicalDependency<SimpleMode>> previousBlocked;

    public DefaultKnowledgeHelper() {
    }

    public DefaultKnowledgeHelper(WorkingMemory workingMemory) {
        this.workingMemory = new WrappedStatefulKnowledgeSessionForRHS(workingMemory);
    }

    public DefaultKnowledgeHelper(Activation activation, WorkingMemory workingMemory) {
        this.workingMemory = new WrappedStatefulKnowledgeSessionForRHS(workingMemory);
        this.activation = activation;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.activation = (Activation)in.readObject();
        this.tuple = (LeftTuple)in.readObject();
        this.workingMemory = (WrappedStatefulKnowledgeSessionForRHS)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.activation);
        out.writeObject(this.tuple);
        out.writeObject(this.workingMemory);
    }

    @Override
    public void setActivation(Activation agendaItem) {
        this.activation = agendaItem;
        this.previousJustified = agendaItem.getLogicalDependencies();
        this.previousBlocked = agendaItem.getBlocked();
        agendaItem.setLogicalDependencies(null);
        agendaItem.setBlocked(null);
        this.tuple = agendaItem.getTuple();
    }

    @Override
    public void reset() {
        this.activation = null;
        this.tuple = null;
        this.previousJustified = null;
        this.previousBlocked = null;
    }

    public LinkedList<LogicalDependency<T>> getpreviousJustified() {
        return this.previousJustified;
    }

    public void blockMatch(Match act) {
        AgendaItem targetMatch = (AgendaItem)act;
        LogicalDependency dep = null;
        if (this.previousBlocked != null) {
            for (dep = this.previousBlocked.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (targetMatch != dep.getJustified()) continue;
                this.previousBlocked.remove(dep);
                break;
            }
        }
        if (dep == null) {
            SimpleMode mode = new SimpleMode();
            dep = new SimpleLogicalDependency<SimpleMode>(this.activation, targetMatch, mode);
            mode.setObject(dep);
        }
        this.activation.addBlocked(dep);
        if (targetMatch.getBlockers().size() == 1 && targetMatch.isQueued()) {
            if (targetMatch.getRuleAgendaItem() == null) {
                targetMatch.remove();
            } else {
                targetMatch.getRuleAgendaItem().getRuleExecutor().removeLeftTuple(targetMatch.getTuple());
            }
            if (targetMatch.getActivationGroupNode() != null) {
                targetMatch.getActivationGroupNode().getActivationGroup().removeActivation(targetMatch);
            }
            if (targetMatch.getActivationNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)targetMatch.getActivationNode().getParentContainer();
                ruleFlowGroup.remove(targetMatch);
            }
        }
    }

    public void unblockAllMatches(Match act) {
        AgendaItem targetMatch = (AgendaItem)act;
        boolean wasBlocked = targetMatch.getBlockers() != null && !targetMatch.getBlockers().isEmpty();
        LinkedListEntry entry = targetMatch.getBlockers().getFirst();
        while (entry != null) {
            LinkedListEntry tmp = (LinkedListEntry)entry.getNext();
            LogicalDependency dep = (LogicalDependency)entry.getObject();
            ((AgendaItem)dep.getJustifier()).removeBlocked(dep);
            entry = tmp;
        }
        if (wasBlocked) {
            RuleAgendaItem ruleAgendaItem = targetMatch.getRuleAgendaItem();
            InternalAgenda agenda = this.workingMemory.getAgenda();
            agenda.stageLeftTuple(ruleAgendaItem, targetMatch);
        }
    }

    @Override
    public FactHandle insertAsync(Object object) {
        return this.workingMemory.insertAsync(object);
    }

    @Override
    public InternalFactHandle insert(Object object) {
        return this.insert(object, false);
    }

    @Override
    public InternalFactHandle insert(Object object, boolean dynamic) {
        return (InternalFactHandle)this.workingMemory.insert(object, dynamic, this.activation.getRule(), this.activation);
    }

    @Override
    public InternalFactHandle insertLogical(Object object, Mode belief) {
        return this.insertLogical(object, (Object)belief, false);
    }

    @Override
    public InternalFactHandle insertLogical(Object object, Mode ... beliefs) {
        return this.insertLogical(object, (Object)beliefs, false);
    }

    @Override
    public InternalFactHandle insertLogical(Object object) {
        return this.insertLogical(object, false);
    }

    @Override
    public InternalFactHandle insertLogical(Object object, boolean dynamic) {
        return this.insertLogical(object, null, dynamic);
    }

    public InternalFactHandle insertLogical(Object object, Object value) {
        return this.insertLogical(object, value, false);
    }

    public InternalFactHandle insertLogical(Object object, Object value, boolean dynamic) {
        if (object == null) {
            return null;
        }
        if (!this.activation.isMatched()) {
            return null;
        }
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (!object.equals(((BeliefSet)dep.getJustified()).getFactHandle().getObject())) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep != null) {
            this.activation.addLogicalDependency(dep);
            return ((BeliefSet)dep.getJustified()).getFactHandle();
        }
        return this.workingMemory.getTruthMaintenanceSystem().insert(object, value, this.activation.getRule(), this.activation);
    }

    @Override
    public InternalFactHandle bolster(Object object) {
        return this.bolster(object, null);
    }

    @Override
    public InternalFactHandle bolster(Object object, Object value) {
        BeliefSystem beliefSystem;
        if (object == null || !this.activation.isMatched()) {
            return null;
        }
        InternalFactHandle handle = this.getFactHandleFromWM(object);
        NamedEntryPoint ep = (NamedEntryPoint)this.workingMemory.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId());
        ObjectTypeConf otc = ep.getObjectTypeConfigurationRegistry().getObjectTypeConf(ep.getEntryPoint(), object);
        if (value == null) {
            beliefSystem = this.workingMemory.getTruthMaintenanceSystem().getBeliefSystem();
        } else if (value instanceof Mode) {
            Mode m = (Mode)value;
            beliefSystem = (BeliefSystem)m.getBeliefSystem();
        } else {
            beliefSystem = this.workingMemory.getTruthMaintenanceSystem().getBeliefSystem();
        }
        BeliefSet beliefSet = null;
        if (handle == null) {
            handle = this.workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getFactHandleFactoryService().newFactHandle(object, otc, this.workingMemory, ep);
        }
        if (handle.getEqualityKey() == null) {
            handle.setEqualityKey(new EqualityKey(handle, 1));
        } else {
            beliefSet = handle.getEqualityKey().getBeliefSet();
        }
        if (beliefSet == null) {
            beliefSet = beliefSystem.newBeliefSet(handle);
            handle.getEqualityKey().setBeliefSet(beliefSet);
        }
        return beliefSystem.insert(beliefSystem.asMode(value), this.activation.getRule(), this.activation, object, beliefSet, this.activation.getPropagationContext(), otc).getFactHandle();
    }

    @Override
    public void cancelRemainingPreviousLogicalDependencies() {
        LogicalDependency<Object> dep;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                TruthMaintenanceSystemHelper.removeLogicalDependency(dep, this.activation.getPropagationContext());
            }
        }
        if (this.previousBlocked != null) {
            dep = this.previousBlocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.previousBlocked.remove(dep);
                AgendaItem justified = (AgendaItem)dep.getJustified();
                justified.getBlockers().remove((SimpleMode)dep.getMode());
                if (justified.getBlockers().isEmpty()) {
                    RuleAgendaItem ruleAgendaItem = justified.getRuleAgendaItem();
                    this.workingMemory.getAgenda().stageLeftTuple(ruleAgendaItem, justified);
                }
                dep = tmp;
            }
        }
    }

    public void cancelMatch(Match act) {
        AgendaItem match = (AgendaItem)act;
        ((RuleTerminalNode)match.getTerminalNode()).cancelMatch(match, this.workingMemory);
    }

    @Override
    public InternalFactHandle getFactHandle(Object object) {
        InternalFactHandle handle = this.getFactHandleFromWM(object);
        if (handle == null) {
            if (object instanceof CoreWrapper) {
                handle = this.getFactHandleFromWM(((CoreWrapper)object).getCore());
            }
            if (handle == null) {
                throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
            }
        }
        return handle;
    }

    @Override
    public InternalFactHandle getFactHandle(InternalFactHandle handle) {
        Object object = handle.getObject();
        if ((handle = this.getFactHandleFromWM(object)) == null) {
            throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public void update(FactHandle handle, Object newObject) {
        InternalFactHandle h = (InternalFactHandle)handle;
        h.getEntryPoint().update(h, newObject, PropertySpecificUtil.onlyTraitBitSetMask(), newObject.getClass(), this.activation);
    }

    @Override
    public void update(FactHandle handle) {
        this.update(handle, Long.MAX_VALUE);
    }

    @Override
    public void update(FactHandle handle, BitMask mask, Class<?> modifiedClass) {
        InternalFactHandle h = (InternalFactHandle)handle;
        if (h.getDataSource() != null) {
            h.getDataSource().update(h, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, this.activation);
            return;
        }
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, this.activation);
        if (h.isTraitOrTraitable()) {
            this.workingMemory.updateTraits(h, mask, modifiedClass, this.activation);
        }
    }

    @Override
    public void update(Object object) {
        this.update(object, PropertySpecificUtil.allSetButTraitBitMask(), Object.class);
    }

    @Override
    public void update(Object object, BitMask mask, Class<?> modifiedClass) {
        this.update(this.getFactHandle(object), mask, modifiedClass);
    }

    @Override
    public void retract(Object object) {
        this.delete(this.getFactHandle(object));
    }

    @Override
    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    @Override
    public void delete(Object object) {
        this.delete(this.getFactHandle(object));
    }

    @Override
    public void delete(Object object, FactHandle.State fhState) {
        this.delete(this.getFactHandle(object), fhState);
    }

    @Override
    public void delete(FactHandle handle) {
        this.delete(handle, FactHandle.State.ALL);
    }

    @Override
    public void delete(FactHandle handle, FactHandle.State fhState) {
        Object o = ((InternalFactHandle)handle).getObject();
        if (((InternalFactHandle)handle).isTraiting()) {
            this.delete(((Thing)o).getCore());
            return;
        }
        ((InternalFactHandle)handle).getEntryPoint().delete(handle, this.activation.getRule(), this.activation, fhState);
    }

    @Override
    public RuleImpl getRule() {
        return this.activation.getRule();
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public KnowledgeRuntime getKnowledgeRuntime() {
        return this.workingMemory;
    }

    @Override
    public Activation getMatch() {
        return this.activation;
    }

    @Override
    public void setFocus(String focus) {
        this.workingMemory.setFocus(focus);
    }

    @Override
    public Object get(Declaration declaration) {
        WorkingMemoryEntryPoint wmTmp = this.tuple.get(declaration).getEntryPoint();
        return wmTmp != null ? declaration.getValue(wmTmp.getInternalWorkingMemory(), this.tuple.getObject(declaration)) : null;
    }

    @Override
    public Declaration getDeclaration(String identifier) {
        return ((AgendaItem)this.activation).getTerminalNode().getSubRule().getOuterDeclarations().get(identifier);
    }

    @Override
    public void halt() {
        this.workingMemory.halt();
    }

    @Override
    public EntryPoint getEntryPoint(String id) {
        return this.workingMemory.getEntryPoint(id);
    }

    @Override
    public Channel getChannel(String id) {
        return this.workingMemory.getChannels().get(id);
    }

    @Override
    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.workingMemory.getChannels());
    }

    private InternalFactHandle getFactHandleFromWM(Object object) {
        EntryPoint ep;
        InternalFactHandle handle = null;
        Iterator<? extends EntryPoint> iterator = this.workingMemory.getEntryPoints().iterator();
        while (iterator.hasNext() && (handle = (InternalFactHandle)(ep = iterator.next()).getFactHandle(object)) == null) {
        }
        return handle;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        Map<Long, String> nodeInstances;
        String ruleflowGroupName;
        if (ProcessContext.class.equals(contextClass) && (ruleflowGroupName = this.getMatch().getRule().getRuleFlowGroup()) != null && !(nodeInstances = ((InternalRuleFlowGroup)this.workingMemory.getAgenda().getRuleFlowGroup(ruleflowGroupName)).getNodeInstances()).isEmpty()) {
            if (nodeInstances.size() > 1) {
                throw new UnsupportedOperationException("Not supporting multiple node instances for the same ruleflow group");
            }
            Map.Entry<Long, String> entry = nodeInstances.entrySet().iterator().next();
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(entry.getKey());
            org.drools.core.spi.ProcessContext context = new org.drools.core.spi.ProcessContext((KieRuntime)this.workingMemory.getKnowledgeRuntime());
            context.setProcessInstance(processInstance);
            String nodeInstance = entry.getValue();
            String[] nodeInstanceIds = nodeInstance.split(":");
            WorkflowProcessInstance container = (WorkflowProcessInstance)processInstance;
            block0: for (int i = 0; i < nodeInstanceIds.length; ++i) {
                for (NodeInstance subNodeInstance : container.getNodeInstances()) {
                    if (subNodeInstance.getId() != new Long(nodeInstanceIds[i]).longValue()) continue;
                    if (i == nodeInstanceIds.length - 1) {
                        context.setNodeInstance(subNodeInstance);
                        continue block0;
                    }
                    container = (NodeInstanceContainer)subNodeInstance;
                }
            }
            return (T)context;
        }
        return null;
    }

    @Override
    public void modify(Object newObject) {
    }

    public KieRuntime getKieRuntime() {
        return this.getKnowledgeRuntime();
    }

    public <T, K> T don(Thing<K> core, Class<T> trait, boolean logical, Mode ... modes) {
        return this.don(core.getCore(), trait, logical, modes);
    }

    @Override
    public <T, K> T don(K core, Class<T> trait) {
        return this.don(core, trait, false);
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait) {
        return this.don(core.getCore(), trait);
    }

    @Override
    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits) {
        return this.don(core, traits, false);
    }

    @Override
    public <T, K> Thing<K> shed(Thing<K> thing, Class<T> trait) {
        return this.shed((TraitableBean)thing.getCore(), trait);
    }

    @Override
    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, Mode ... modes) {
        return this.don(core, traits, true, modes);
    }

    @Override
    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, boolean logical) {
        return this.don(core, traits, logical, null);
    }

    @Override
    public <T, K> T don(K core, Class<T> trait, boolean logical) {
        return this.don(core, trait, logical, null);
    }

    @Override
    public <T, K> T don(K core, Class<T> trait, Mode ... modes) {
        return this.don(core, trait, true, modes);
    }

    @Override
    public <T, K, X extends TraitableBean> Thing<K> shed(TraitableBean<K, X> core, Class<T> trait) {
        return this.workingMemory.shed(this.activation, core, trait);
    }

    private <T, K> T don(K core, Collection<Class<? extends Thing>> traits, boolean b, Mode ... modes) {
        return this.workingMemory.don(this.activation, core, traits, b, modes);
    }

    private <T, K> T don(K core, Class<T> trait, boolean b, Mode ... modes) {
        return this.workingMemory.don(this.activation, core, trait, b, modes);
    }

    @Override
    public ClassLoader getProjectClassLoader() {
        return ((InternalKnowledgeBase)this.getKieRuntime().getKieBase()).getRootClassLoader();
    }

    @Override
    public void run(RuleUnit ruleUnit) {
        this.workingMemory.switchToRuleUnit(ruleUnit);
    }

    @Override
    public void run(Class<? extends RuleUnit> ruleUnitClass) {
        this.workingMemory.switchToRuleUnit(ruleUnitClass);
    }

    @Override
    public void guard(RuleUnit ruleUnit) {
        this.workingMemory.guardRuleUnit(ruleUnit, this.activation);
    }

    @Override
    public void guard(Class<? extends RuleUnit> ruleUnitClass) {
        this.workingMemory.guardRuleUnit(ruleUnitClass, this.activation);
    }
}

