/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerUtils;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.model.v1_1.Context;
import org.kie.dmn.model.v1_1.ContextEntry;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.FunctionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNContextEvaluator
implements DMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(DMNContextEvaluator.class);
    public static final String RESULT_ENTRY = "__RESULT__";
    private final String name;
    private final Context contextDef;
    private List<ContextEntryDef> entries = new ArrayList<ContextEntryDef>();

    public DMNContextEvaluator(String name, Context contextDef) {
        this.name = name;
        this.contextDef = contextDef;
    }

    public void addEntry(String name, DMNType type, DMNExpressionEvaluator evaluator, ContextEntry ce) {
        this.entries.add(new ContextEntryDef(name, type, evaluator, ce));
    }

    public List<ContextEntryDef> getEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        DMNResultImpl result = (DMNResultImpl)dmnr;
        HashMap<String, Object> results = new HashMap<String, Object>();
        DMNContext previousContext = result.getContext();
        DMNContext dmnContext = previousContext.clone();
        result.setContext(dmnContext);
        try {
            for (ContextEntryDef ed : this.entries) {
                Object value;
                String entryExprId;
                String entryVarId;
                block14: {
                    EvaluatorResultImpl evaluatorResultImpl;
                    EvaluatorResult er;
                    block12: {
                        try {
                            entryVarId = this.getEntryVarId(ed);
                            entryExprId = this.getEntryExprId(ed);
                            DMNRuntimeEventManagerUtils.fireBeforeEvaluateContextEntry(eventManager, this.name, ed.getName(), entryVarId, entryExprId, result);
                            er = ed.getEvaluator().evaluate(eventManager, result);
                            if (er.getResultType() != EvaluatorResult.ResultType.SUCCESS) break block12;
                            value = er.getResult();
                            if (!ed.getType().isCollection() && value instanceof Collection && ((Collection)value).size() == 1) {
                                value = ((Collection)value).toArray()[0];
                            }
                            if (((DMNRuntimeImpl)eventManager.getRuntime()).performRuntimeTypeCheck(result.getModel()) && !(ed.getContextEntry().getExpression() instanceof FunctionDefinition) && ed.getType() != null && !ed.getType().isAssignableValue(value)) {
                                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.contextDef, result, null, null, Msg.ERROR_EVAL_NODE_RESULT_WRONG_TYPE, ed.getName(), ed.getType(), value);
                                EvaluatorResultImpl evaluatorResultImpl2 = new EvaluatorResultImpl(results, EvaluatorResult.ResultType.FAILURE);
                                return evaluatorResultImpl2;
                            }
                            results.put(ed.getName(), value);
                        }
                        catch (Exception e) {
                            logger.error("Error invoking expression for node '" + this.name + "'.", (Throwable)e);
                            String entryVarId2 = this.getEntryVarId(ed);
                            String entryExprId2 = this.getEntryExprId(ed);
                            DMNRuntimeEventManagerUtils.fireAfterEvaluateContextEntry(eventManager, this.name, ed.getName(), entryVarId2, entryExprId2, null, result);
                            evaluatorResultImpl = new EvaluatorResultImpl(results, EvaluatorResult.ResultType.FAILURE);
                            return evaluatorResultImpl;
                        }
                        break block14;
                    }
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.contextDef, result, null, null, Msg.ERR_EVAL_CTX_ENTRY_ON_CTX, ed.getName(), this.name);
                    DMNRuntimeEventManagerUtils.fireAfterEvaluateContextEntry(eventManager, this.name, ed.getName(), entryVarId, entryExprId, er.getResult(), result);
                    evaluatorResultImpl = new EvaluatorResultImpl(results, EvaluatorResult.ResultType.FAILURE);
                    return evaluatorResultImpl;
                }
                dmnContext.set(ed.getName(), value);
                DMNRuntimeEventManagerUtils.fireAfterEvaluateContextEntry(eventManager, this.name, ed.getName(), entryVarId, entryExprId, value, result);
            }
        }
        finally {
            result.setContext(previousContext);
        }
        if (results.containsKey(RESULT_ENTRY)) {
            return new EvaluatorResultImpl(results.get(RESULT_ENTRY), EvaluatorResult.ResultType.SUCCESS);
        }
        return new EvaluatorResultImpl(results, EvaluatorResult.ResultType.SUCCESS);
    }

    private String getEntryExprId(ContextEntryDef ed) {
        return ed.getContextEntry().getExpression() != null ? ed.getContextEntry().getExpression().getId() : null;
    }

    private String getEntryVarId(ContextEntryDef ed) {
        return ed.getContextEntry().getVariable() != null ? ed.getContextEntry().getVariable().getId() : null;
    }

    public static class ContextEntryDef {
        private String name;
        private DMNType type;
        private DMNExpressionEvaluator evaluator;
        private ContextEntry ce;

        public ContextEntryDef(String name, DMNType type, DMNExpressionEvaluator evaluator, ContextEntry ce) {
            this.name = name;
            this.type = type;
            this.evaluator = evaluator;
            this.ce = ce;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public DMNType getType() {
            return this.type;
        }

        public void setType(DMNType type) {
            this.type = type;
        }

        public DMNExpressionEvaluator getEvaluator() {
            return this.evaluator;
        }

        public void setEvaluator(DMNExpressionEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public ContextEntry getContextEntry() {
            return this.ce;
        }

        public void setContextEntry(ContextEntry ce) {
            this.ce = ce;
        }
    }
}

