/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.persistence;

import javax.persistence.EntityManager;
import org.drools.persistence.api.PersistenceContext;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.jbpm.persistence.JpaProcessPersistenceContext;
import org.jbpm.persistence.api.ProcessPersistenceContext;
import org.jbpm.persistence.api.ProcessPersistenceContextManager;
import org.kie.api.runtime.Environment;
import org.kie.spring.persistence.AbstractKieSpringJpaManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class KieSpringJpaManager
extends AbstractKieSpringJpaManager
implements ProcessPersistenceContextManager {
    private boolean pessimisticLocking = false;

    public KieSpringJpaManager(Environment env) {
        super(env);
        Boolean usePessLocking = (Boolean)env.get("org.kie.api.persistence.pessimistic");
        if (usePessLocking != null && usePessLocking.booleanValue()) {
            this.pessimisticLocking = true;
        }
    }

    public PersistenceContext getApplicationScopedPersistenceContext() {
        return new JpaPersistenceContext(this.getApplicationScopedEntityManager(), this.isJTA, this.pessimisticLocking, (TransactionManager)this.env.get("org.kie.transaction.TransactionManager"));
    }

    public PersistenceContext getCommandScopedPersistenceContext() {
        return new JpaPersistenceContext((EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager"), this.isJTA, this.pessimisticLocking, (TransactionManager)this.env.get("org.kie.transaction.TransactionManager"));
    }

    public void beginCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = this.getCommandScopedEntityManager();
        if (this.isJTA) {
            this.getCommandScopedPersistenceContext().joinTransaction();
            this.appScopedEntityManager.joinTransaction();
        }
    }

    public ProcessPersistenceContext getProcessPersistenceContext() {
        return new JpaProcessPersistenceContext((EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager"), this.isJTA, this.pessimisticLocking, (TransactionManager)this.env.get("org.kie.transaction.TransactionManager"));
    }

    @Override
    public void endCommandScopedEntityManager() {
        if (TransactionSynchronizationManager.hasResource((Object)"cmdEM")) {
            EntityManager cmdScopedEntityManager = (EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            if (cmdScopedEntityManager != null) {
                cmdScopedEntityManager.clear();
            }
            if (this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager") != null) {
                this.getCommandScopedPersistenceContext().close();
            }
            TransactionSynchronizationManager.unbindResource((Object)"cmdEM");
        }
        if (TransactionSynchronizationManager.hasResource((Object)"org.kie.resources")) {
            TransactionSynchronizationManager.unbindResource((Object)"org.kie.resources");
        }
    }
}

