/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.ReactiveObject;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.model.functions.FunctionN;

public class LambdaDataProvider
implements DataProvider {
    private final FunctionN providerFunction;
    private Declaration[] declarations;
    private final boolean reactive;

    public LambdaDataProvider(FunctionN providerFunction, boolean reactive, Declaration ... declarations) {
        this.declarations = declarations;
        this.providerFunction = providerFunction;
        this.reactive = reactive;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public Object createContext() {
        return null;
    }

    public Iterator getResults(Tuple tuple, InternalWorkingMemory wm, PropagationContext ctx, Object providerContext) {
        Object result = this.getResult(tuple, wm);
        if (this.isReactive()) {
            if (result instanceof ReactiveObject) {
                ((ReactiveObject)result).addLeftTuple(tuple);
            }
            if (result instanceof Iterable) {
                for (Object value : (Iterable)result) {
                    if (!(value instanceof ReactiveObject)) continue;
                    ((ReactiveObject)value).addLeftTuple(tuple);
                }
            }
        }
        if (result instanceof Object[]) {
            return Arrays.asList((Object[])result).iterator();
        }
        if (result instanceof Iterator) {
            return (Iterator)result;
        }
        if (result instanceof Iterable) {
            return ((Iterable)result).iterator();
        }
        return Collections.singletonList(result).iterator();
    }

    private Object getResult(Tuple tuple, InternalWorkingMemory wm) {
        Object result;
        if (this.declarations.length == 0) {
            result = this.providerFunction.apply(new Object[0]);
        } else if (this.declarations.length == 1) {
            result = this.getValueForDeclaration(tuple, wm, this.declarations[0]);
            if (this.providerFunction != null) {
                result = this.providerFunction.apply(new Object[]{result});
            }
        } else {
            Object[] args = new Object[this.declarations.length];
            for (int i = 0; i < this.declarations.length; ++i) {
                args[i] = this.getValueForDeclaration(tuple, wm, this.declarations[i]);
            }
            result = this.providerFunction.apply(args);
        }
        return result;
    }

    private Object getValueForDeclaration(Tuple tuple, InternalWorkingMemory wm, Declaration declaration) {
        return declaration.getExtractor().isGlobal() ? declaration.getExtractor().getValue(wm, (Object)declaration.getIdentifier()) : declaration.getValue(wm, tuple.get(declaration).getObject());
    }

    public DataProvider clone() {
        Declaration[] clonedDecls = new Declaration[this.declarations.length];
        for (int i = 0; i < this.declarations.length; ++i) {
            clonedDecls[i] = this.declarations[i].clone();
        }
        return new LambdaDataProvider(this.providerFunction, this.reactive, clonedDecls);
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].getIdentifier().equals(declaration.getIdentifier())) continue;
            this.declarations[i] = resolved;
        }
    }

    public boolean isReactive() {
        return this.reactive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaDataProvider that = (LambdaDataProvider)o;
        return this.reactive == that.reactive && Objects.equals(this.providerFunction, that.providerFunction) && Arrays.equals(this.declarations, that.declarations);
    }

    public int hashCode() {
        return Objects.hash(this.providerFunction, Arrays.hashCode(this.declarations), this.reactive);
    }
}

