/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.model.Model;
import org.drools.model.Rule;
import org.drools.model.impl.ModelImpl;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.runtime.rule.RuleUnitExecutor;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DMNDTExpressionEvaluator;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.execmodelbased.DMNUnit;
import org.kie.dmn.core.compiler.execmodelbased.DTableModel;
import org.kie.dmn.core.compiler.execmodelbased.DecisionTableEvaluator;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerUtils;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelEvaluator
implements DMNExpressionEvaluator {
    private static Logger logger = LoggerFactory.getLogger(AbstractModelEvaluator.class);
    protected final KieBase kieBase;
    private DMNFEELHelper feel;
    private DTableModel dTableModel;
    private DMNBaseNode node;

    protected AbstractModelEvaluator() {
        Model model = (Model)this.getRules().stream().reduce(new ModelImpl(), ModelImpl::addRule, (m1, m2) -> {
            throw new UnsupportedOperationException();
        });
        this.kieBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseConfiguration)KieServices.get().newKieBaseConfiguration(null, this.getClass().getClassLoader()));
    }

    protected abstract List<Rule> getRules();

    protected abstract DMNUnit getDMNUnit();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnResult) {
        block7: {
            events = new ArrayList<FEELEvent>();
            DMNRuntimeEventManagerUtils.fireBeforeEvaluateDecisionTable(eventManager, this.node.getName(), this.dTableModel.getDtName(), dmnResult);
            executor = RuleUnitExecutor.create().bind(this.kieBase);
            evalCtx = this.createEvaluationContext(events, eventManager, dmnResult);
            evalCtx.enterFrame();
            eventResults = null;
            try {
                decisionTableEvaluator = new DecisionTableEvaluator(this.feel, this.dTableModel, evalCtx, events);
                i = 0;
lbl10:
                // 2 sources

                while (i < decisionTableEvaluator.getInputs().length) {
                    column = this.dTableModel.getColumns().get(i);
                    error = column.validate(evalCtx, decisionTableEvaluator.getInputs()[i].getValue());
                    if (error != null) {
                        MsgUtil.reportMessage(AbstractModelEvaluator.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node.getSource(), (DMNResultImpl)dmnResult, null, error, Msg.FEEL_ERROR, error.getMessage());
                        var11_13 = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
                        break block7;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl34
            }
            catch (RuntimeException e) {
                try {
                    AbstractModelEvaluator.logger.error(e.toString(), (Throwable)e);
                    throw e;
                }
                catch (Throwable var12_14) {
                    evalCtx.exitFrame();
                    DMNRuntimeEventManagerUtils.fireAfterEvaluateDecisionTable(eventManager, this.node.getName(), this.dTableModel.getDtName(), dmnResult, eventResults != null ? eventResults.matchedRules : null, eventResults != null ? eventResults.fired : null);
                    throw var12_14;
                }
            }
        }
        evalCtx.exitFrame();
        DMNRuntimeEventManagerUtils.fireAfterEvaluateDecisionTable(eventManager, this.node.getName(), this.dTableModel.getDtName(), dmnResult, eventResults != null ? eventResults.matchedRules : null, eventResults != null ? eventResults.fired : null);
        return var11_13;
lbl-1000:
        // 1 sources

        {
            ++i;
            ** GOTO lbl10
lbl34:
            // 1 sources

            unit = this.getDMNUnit().setEvalCtx(evalCtx).setEvents(events).setDecisionTableEvaluator(decisionTableEvaluator).setDecisionTable(this.dTableModel.asDecisionTable());
            result = unit.execute(this.node.getName(), executor).getResult();
            eventResults = DMNDTExpressionEvaluator.processEvents(events, eventManager, (DMNResultImpl)dmnResult, this.node);
            var10_12 = new EvaluatorResultImpl(result, eventResults.hasErrors != false ? EvaluatorResult.ResultType.FAILURE : EvaluatorResult.ResultType.SUCCESS);
        }
        evalCtx.exitFrame();
        DMNRuntimeEventManagerUtils.fireAfterEvaluateDecisionTable(eventManager, this.node.getName(), this.dTableModel.getDtName(), dmnResult, eventResults != null ? eventResults.matchedRules : null, eventResults != null ? eventResults.fired : null);
        return var10_12;
    }

    private EvaluationContext createEvaluationContext(List<FEELEvent> events, DMNRuntimeEventManager eventManager, DMNResult dmnResult) {
        EvaluationContextImpl ctx = this.feel.newEvaluationContext(Collections.singletonList(events::add), Collections.emptyMap());
        ctx.setPerformRuntimeTypeCheck(((DMNRuntimeImpl)eventManager.getRuntime()).performRuntimeTypeCheck(((DMNResultImpl)dmnResult).getModel()));
        ctx.setValues(dmnResult.getContext().getAll());
        return ctx;
    }

    protected AbstractModelEvaluator initParameters(DMNFEELHelper feel, DMNCompilerContext ctx, DTableModel dTableModel, DMNBaseNode node) {
        this.feel = feel;
        this.dTableModel = dTableModel.compileAll(ctx);
        this.node = node;
        return this;
    }
}

