/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.stmt;

import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.OptionalProperty;
import org.drools.javaparser.metamodel.ReturnStmtMetaModel;

public final class ReturnStmt
extends Statement {
    @OptionalProperty
    private Expression expression;

    public ReturnStmt() {
        this(null, null);
    }

    @AllFieldsConstructor
    public ReturnStmt(Expression expression) {
        this(null, expression);
    }

    public ReturnStmt(TokenRange tokenRange, Expression expression) {
        super(tokenRange);
        this.setExpression(expression);
        this.customInitialization();
    }

    public ReturnStmt(String expression) {
        this(null, new NameExpr(expression));
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<Expression> getExpression() {
        return Optional.ofNullable(this.expression);
    }

    public ReturnStmt setExpression(Expression expression) {
        if (expression == this.expression) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.EXPRESSION, this.expression, expression);
        if (this.expression != null) {
            this.expression.setParentNode(null);
        }
        this.expression = expression;
        this.setAsParentNodeOf(expression);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.expression != null && node == this.expression) {
            this.removeExpression();
            return true;
        }
        return super.remove(node);
    }

    public ReturnStmt removeExpression() {
        return this.setExpression(null);
    }

    @Override
    public ReturnStmt clone() {
        return (ReturnStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public ReturnStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.returnStmtMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (this.expression != null && node == this.expression) {
            this.setExpression((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isReturnStmt() {
        return true;
    }

    @Override
    public ReturnStmt asReturnStmt() {
        return this;
    }

    @Override
    public void ifReturnStmt(Consumer<ReturnStmt> action) {
        action.accept(this);
    }

    @Override
    public Optional<ReturnStmt> toReturnStmt() {
        return Optional.of(this);
    }
}

