/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.validator.ProblemReporter;
import org.drools.javaparser.ast.validator.Validator;

public class Validators
implements Validator {
    private final List<Validator> validators = new ArrayList<Validator>();

    public Validators(Validator ... validators) {
        this.validators.addAll(Arrays.asList(validators));
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    public Validators remove(Validator validator) {
        if (!this.validators.remove(validator)) {
            throw new AssertionError((Object)"Trying to remove a validator that isn't there.");
        }
        return this;
    }

    public Validators replace(Validator oldValidator, Validator newValidator) {
        this.remove(oldValidator);
        this.add(newValidator);
        return this;
    }

    public Validators add(Validator newValidator) {
        this.validators.add(newValidator);
        return this;
    }

    @Override
    public void accept(Node node, ProblemReporter problemReporter) {
        this.validators.forEach(v -> v.accept(node, problemReporter));
    }
}

