/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.process;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetProcessInstanceCommand
implements ExecutableCommand<ProcessInstance>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = 5890677592835087670L;
    @XmlAttribute(required=true)
    private Long processInstanceId;
    @XmlAttribute
    private boolean readOnly = false;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public GetProcessInstanceCommand() {
    }

    public GetProcessInstanceCommand(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public ProcessInstance execute(Context context) {
        KieSession ksession = ((RegistryContext)context).lookup(KieSession.class);
        if (this.processInstanceId == null) {
            return null;
        }
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId.longValue(), this.readOnly);
        if (this.outIdentifier != null) {
            ((RegistryContext)context).lookup(ExecutionResultImpl.class).setResult(this.outIdentifier, processInstance);
        }
        return processInstance;
    }

    public String toString() {
        return "session.getProcessInstance(" + this.processInstanceId + ");";
    }
}

