/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import java.util.Optional;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNEvaluatorCompiler;
import org.kie.dmn.core.compiler.execmodelbased.AbstractModelEvaluator;
import org.kie.dmn.core.compiler.execmodelbased.DMNRuleClassFile;
import org.kie.dmn.core.compiler.execmodelbased.DTableModel;
import org.kie.dmn.core.compiler.execmodelbased.ExecModelDMNEvaluatorCompiler;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.model.api.DecisionTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecModelDMNClassLoaderCompiler
extends DMNEvaluatorCompiler {
    private DMNRuleClassFile dmnRuleClassFile;
    static final Logger logger = LoggerFactory.getLogger(ExecModelDMNEvaluatorCompiler.class);

    public ExecModelDMNClassLoaderCompiler(DMNCompilerImpl compiler, DMNRuleClassFile dmnRuleClassFile) {
        super(compiler);
        this.dmnRuleClassFile = dmnRuleClassFile;
    }

    @Override
    protected DMNExpressionEvaluator compileDecisionTable(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String dtName, DecisionTable dt) {
        String decisionName = ExecModelDMNEvaluatorCompiler.getDecisionTableName(dtName, dt);
        DTableModel dTableModel = new DTableModel(ctx.getFeelHelper(), model, dtName, decisionName, dt);
        String className = dTableModel.getGeneratedClassName(ExecModelDMNEvaluatorCompiler.GeneratorsEnum.EVALUATOR);
        Optional<String> generatedClass = this.dmnRuleClassFile.getCompiledClass(className);
        return generatedClass.map(gc -> {
            try {
                Class<?> clazz = this.getRootClassLoader().loadClass((String)gc);
                AbstractModelEvaluator evaluatorInstance = (AbstractModelEvaluator)clazz.newInstance();
                evaluatorInstance.initParameters(ctx, dTableModel, node);
                logger.debug("Read compiled evaluator from class loader: " + className);
                return evaluatorInstance;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }).orElseThrow(() -> new RuntimeException("Cannot instantiate evaluator"));
    }
}

