/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNPackage;
import org.kie.dmn.core.compiler.DMNProfile;

public class DMNPackageImpl
implements DMNPackage,
Externalizable {
    private String namespace;
    private Map<String, DMNModel> models = new HashMap<String, DMNModel>();
    private List<DMNProfile> profiles = new ArrayList<DMNProfile>();

    public DMNPackageImpl() {
        this("");
    }

    public DMNPackageImpl(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ResourceType getResourceType() {
        return ResourceType.DMN;
    }

    public DMNModel addModel(String name, DMNModel model) {
        return this.models.put(name, model);
    }

    public DMNModel getModel(String name) {
        return this.models.get(name);
    }

    public DMNModel getModelById(String id) {
        for (DMNModel model : this.models.values()) {
            if (!model.getDefinitions().getId().equals(id)) continue;
            return model;
        }
        return null;
    }

    public Map<String, DMNModel> getAllModels() {
        return Collections.unmodifiableMap(this.models);
    }

    public boolean removeResource(Resource resource) {
        return this.models.entrySet().removeIf(kv -> resource.equals(((DMNModel)kv.getValue()).getResource()));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.namespace);
        out.writeObject(this.models);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.namespace = (String)in.readObject();
        this.models = (Map)in.readObject();
    }

    public void addProfiles(List<DMNProfile> profiles) {
        this.profiles.addAll(profiles);
    }

    public List<DMNProfile> getProfiles() {
        return this.profiles;
    }
}

