/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import java.util.List;
import java.util.Optional;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.QueryParameter;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;

class QueryCall
implements DSLNode {
    private final RuleContext context;
    private final PackageModel packageModel;
    private PatternDescr pattern;
    private final String queryDef;

    QueryCall(RuleContext context, PackageModel packageModel, PatternDescr pattern, String queryDef) {
        this.context = context;
        this.packageModel = packageModel;
        this.pattern = pattern;
        this.queryDef = queryDef;
    }

    @Override
    public void buildPattern() {
        MethodCallExpr callMethod = new MethodCallExpr((Expression)new NameExpr(this.queryDef), "call");
        callMethod.addArgument("" + !this.pattern.isQuery());
        List<QueryParameter> parameters = this.packageModel.getQueryDefWithType().get(this.queryDef).getContext().getQueryParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            String queryName = this.context.getQueryName().orElseThrow(RuntimeException::new);
            ExprConstraintDescr variableExpr = (ExprConstraintDescr)this.pattern.getConstraint().getDescrs().get(i);
            String variableName = variableExpr.toString();
            int unifPos = variableName.indexOf(":=");
            if (unifPos > 0) {
                variableName = variableName.substring(0, unifPos).trim();
            }
            Optional<String> unificationId = this.context.getUnificationId(variableName);
            int queryIndex = i + 1;
            Expression parameterCall = unificationId.map(name -> this.context.getVarExpr((String)name)).orElseGet(() -> new MethodCallExpr((Expression)new NameExpr(queryName), QueryGenerator.toQueryArg(queryIndex)));
            callMethod.addArgument(parameterCall);
        }
        this.context.addExpression((Expression)callMethod);
    }
}

