/*
 * Decompiled with CFR 0.152.
 */
package org.drools.constraint.parser.ast.expr;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.LongLiteralExprMetaModel;
import java.math.BigDecimal;
import org.drools.constraint.parser.ast.visitor.DrlGenericVisitor;
import org.drools.constraint.parser.ast.visitor.DrlVoidVisitor;

public final class BigDecimalLiteralExpr
extends LiteralStringValueExpr {
    public BigDecimalLiteralExpr() {
        this(null, "0");
    }

    @AllFieldsConstructor
    public BigDecimalLiteralExpr(String value) {
        this(null, value);
    }

    public BigDecimalLiteralExpr(TokenRange tokenRange, String value) {
        super(tokenRange, value);
        this.customInitialization();
    }

    public BigDecimalLiteralExpr(BigDecimal value) {
        this(null, value.toString());
    }

    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return ((DrlGenericVisitor)v).visit(this, arg);
    }

    public <A> void accept(VoidVisitor<A> v, A arg) {
        ((DrlVoidVisitor)v).visit(this, arg);
    }

    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    public BigDecimal asBigDecimal() {
        String result = this.value.replaceAll("_", "");
        char lastChar = result.charAt(result.length() - 1);
        if (lastChar == 'B') {
            result = result.substring(0, result.length() - 1);
        }
        return new BigDecimal(result);
    }

    public BigDecimalLiteralExpr setLong(long value) {
        this.value = String.valueOf(value);
        return this;
    }

    public BigDecimalLiteralExpr clone() {
        return (BigDecimalLiteralExpr)((Object)this.accept((GenericVisitor)new CloneVisitor(), null));
    }

    public LongLiteralExprMetaModel getMetaModel() {
        return JavaParserMetaModel.longLiteralExprMetaModel;
    }
}

