/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.core.util.asm.DumpMethodVisitor;
import org.drools.model.functions.IntrospectableLambda;
import org.drools.model.functions.LambdaPrinter;
import org.mvel2.asm.ClassReader;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.MethodVisitor;

public class LambdaIntrospector
implements LambdaPrinter {
    private static final int CACHE_SIZE = 32;
    private static final Map<ClassIdentifier, Map<String, String>> methodFingerprintsMap = new LinkedHashMap(){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 32;
        }
    };

    public String getLambdaFingerprint(Object lambda) {
        SerializedLambda extracted;
        String result;
        if (lambda instanceof IntrospectableLambda) {
            lambda = ((IntrospectableLambda)lambda).getLambda();
        }
        if ((result = LambdaIntrospector.getFingerprintsForClass(lambda, extracted = LambdaIntrospector.extractLambda((Serializable)lambda)).get(extracted.getImplMethodName())) == null) {
            if (!extracted.getCapturingClass().equals(extracted.getImplClass())) {
                result = extracted.getCapturingClass().replace('/', '.') + "::" + extracted.getImplMethodName();
            } else {
                throw new UnsupportedOperationException("Unable to introspect lambda " + lambda);
            }
        }
        return result;
    }

    private static SerializedLambda extractLambda(Serializable lambda) {
        try {
            Method method = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            return (SerializedLambda)method.invoke((Object)lambda, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> getFingerprintsForClass(Object lambda, SerializedLambda extracted) {
        String className;
        ClassLoader lambdaClassLoader = lambda.getClass().getClassLoader();
        ClassIdentifier id = new ClassIdentifier(lambdaClassLoader, className = extracted.getCapturingClass());
        Map<String, String> fingerprints = methodFingerprintsMap.get(id);
        if (fingerprints == null) {
            LambdaClassVisitor visitor = new LambdaClassVisitor();
            try (InputStream classStream = lambdaClassLoader.getResourceAsStream(className.replace('.', '/') + ".class");){
                ClassReader reader = new ClassReader(classStream);
                reader.accept((ClassVisitor)visitor, 6);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            fingerprints = visitor.getMethodsMap();
            methodFingerprintsMap.put(id, fingerprints);
        }
        return fingerprints;
    }

    private static class LambdaClassVisitor
    extends ClassVisitor {
        private final Map<String, String> methodsMap = new HashMap<String, String>();

        LambdaClassVisitor() {
            super(458752);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return name.startsWith("lambda$") ? new DumpMethodVisitor(s -> this.setMethodFingerprint(name, (String)s)) : super.visitMethod(access, name, desc, signature, exceptions);
        }

        void setMethodFingerprint(String methodname, String methodFingerprint) {
            this.methodsMap.put(methodname, methodFingerprint);
        }

        Map<String, String> getMethodsMap() {
            return this.methodsMap;
        }
    }

    private static class ClassIdentifier {
        private final ClassLoader classLoader;
        private final String className;

        private ClassIdentifier(ClassLoader classLoader, String className) {
            this.classLoader = classLoader;
            this.className = className;
        }

        public boolean equals(Object o) {
            if (o instanceof ClassIdentifier) {
                ClassIdentifier that = (ClassIdentifier)o;
                return this.className.equals(that.className) && this.classLoader == that.classLoader;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.className.hashCode() + this.classLoader.hashCode();
        }
    }
}

