/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNDecisionServiceEvaluator;
import org.kie.dmn.core.ast.DMNFunctionDefinitionEvaluator;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDecisionServiceFunctionDefinitionEvaluator
implements DMNExpressionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(DMNDecisionServiceFunctionDefinitionEvaluator.class);
    private DecisionServiceNode dsNode;
    private List<DSFormalParameter> parameters;
    private boolean coerceSingletonResult;

    public DMNDecisionServiceFunctionDefinitionEvaluator(DecisionServiceNode dsNode, List<DSFormalParameter> parameters, boolean coerceSingletonResult) {
        this.dsNode = dsNode;
        this.parameters = parameters;
        this.coerceSingletonResult = coerceSingletonResult;
    }

    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        DMNResultImpl result = (DMNResultImpl)dmnr;
        DMNDSFunction function = new DMNDSFunction(this.dsNode.getName(), this.parameters, new DMNDecisionServiceEvaluator(this.dsNode, false, this.coerceSingletonResult), eventManager, result);
        return new EvaluatorResultImpl((Object)function, EvaluatorResult.ResultType.SUCCESS);
    }

    public static class DMNDSFunction
    extends BaseFEELFunction {
        private final List<DSFormalParameter> parameters;
        private final DMNExpressionEvaluator evaluator;
        private final DMNRuntimeEventManager eventManager;
        private final DMNResultImpl resultContext;
        private final boolean typeCheck;

        public DMNDSFunction(String name, List<DSFormalParameter> parameters, DMNExpressionEvaluator evaluator, DMNRuntimeEventManager eventManager, DMNResultImpl result) {
            super(name);
            this.parameters = parameters;
            this.evaluator = evaluator;
            this.eventManager = eventManager;
            this.resultContext = result;
            this.typeCheck = ((DMNRuntimeImpl)eventManager.getRuntime()).performRuntimeTypeCheck(result.getModel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(EvaluationContext ctx, Object[] params) {
            Object object;
            DMNContext previousContext = this.resultContext.getContext();
            DMNContext dmnContext = this.eventManager.getRuntime().newContext();
            try {
                if (params.length != this.parameters.size()) {
                    MsgUtil.reportMessage(LOG, DMNMessage.Severity.ERROR, null, this.resultContext, null, null, Msg.PARAMETER_COUNT_MISMATCH_DS, this.getName());
                    Object var5_5 = null;
                    return var5_5;
                }
                for (int i = 0; i < params.length; ++i) {
                    DSFormalParameter formalParameter = this.parameters.get(i);
                    if (formalParameter.getImportName() == null) {
                        dmnContext.set(formalParameter.name, this.performTypeCheckIfNeeded(params[i], i));
                        continue;
                    }
                    Map<String, Object> importNameCtx = null;
                    if (dmnContext.isDefined(formalParameter.getImportName())) {
                        importNameCtx = (Map)dmnContext.get(formalParameter.getImportName());
                    } else {
                        importNameCtx = new HashMap();
                        dmnContext.set(formalParameter.getImportName(), importNameCtx);
                    }
                    importNameCtx.put(formalParameter.getElementName(), this.performTypeCheckIfNeeded(params[i], i));
                }
                this.resultContext.setContext(dmnContext);
                EvaluatorResult result = this.evaluator.evaluate(this.eventManager, this.resultContext);
                if (result.getResultType() == EvaluatorResult.ResultType.SUCCESS) {
                    object = result.getResult();
                    return object;
                }
                object = null;
                return object;
            }
            catch (Exception e) {
                MsgUtil.reportMessage(LOG, DMNMessage.Severity.ERROR, null, this.resultContext, e, null, Msg.ERR_INVOKING_FUNCTION_ON_NODE, this.getName(), this.getName());
                object = null;
                return object;
            }
            finally {
                this.resultContext.setContext(previousContext);
            }
        }

        private Object performTypeCheckIfNeeded(Object param, int paramIndex) {
            if (this.typeCheck) {
                DSFormalParameter dsFormalParameter = this.parameters.get(paramIndex);
                if (dsFormalParameter.type.isAssignableValue(param)) {
                    return param;
                }
                MsgUtil.reportMessage(LOG, DMNMessage.Severity.WARN, null, this.resultContext, null, null, Msg.PARAMETER_TYPE_MISMATCH_DS, dsFormalParameter.name, dsFormalParameter.type, MsgUtil.clipString(param.toString(), 50));
                return null;
            }
            return param;
        }

        protected boolean isCustomFunction() {
            return true;
        }

        public List<List<String>> getParameterNames() {
            return Collections.singletonList(this.parameters.stream().map(p -> p.name).collect(Collectors.toList()));
        }

        public List<List<DMNType>> getParameterTypes() {
            return Collections.singletonList(this.parameters.stream().map(p -> p.type).collect(Collectors.toList()));
        }

        public String toString() {
            return "function " + this.getName() + "( " + this.parameters.stream().map(p -> p.name).collect(Collectors.joining(", ")) + " )";
        }
    }

    public static class DSFormalParameter
    extends DMNFunctionDefinitionEvaluator.FormalParameter {
        private final String importName;
        private final String elementName;

        public DSFormalParameter(String importName, String elementName, DMNType type) {
            super(importName != null ? importName + "." + elementName : elementName, type);
            this.importName = importName;
            this.elementName = elementName;
        }

        public String getImportName() {
            return this.importName;
        }

        public String getElementName() {
            return this.elementName;
        }
    }
}

