/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.dmn.model.api.ItemDefinition;

public class ItemDefinitionDependenciesSorter {
    private final String modelNamespace;

    public ItemDefinitionDependenciesSorter(String modelNamespace) {
        this.modelNamespace = modelNamespace;
    }

    public List<ItemDefinition> sort(List<ItemDefinition> ins) {
        ArrayList<ItemDefinition> visited = new ArrayList<ItemDefinition>(ins.size());
        ArrayList<ItemDefinition> dfv = new ArrayList<ItemDefinition>(ins.size());
        for (ItemDefinition node : ins) {
            if (visited.contains(node)) continue;
            this.dfVisit(node, ins, visited, dfv);
        }
        return dfv;
    }

    private void dfVisit(ItemDefinition node, List<ItemDefinition> allNodes, Collection<ItemDefinition> visited, List<ItemDefinition> dfv) {
        visited.add(node);
        List neighbours = allNodes.stream().filter(n -> !n.getName().equals(node.getName())).filter(n -> ItemDefinitionDependenciesSorter.recurseFind(node, new QName(this.modelNamespace, n.getName()))).collect(Collectors.toList());
        for (ItemDefinition n2 : neighbours) {
            if (visited.contains(n2)) continue;
            this.dfVisit(n2, allNodes, visited, dfv);
        }
        dfv.add(node);
    }

    private static boolean recurseFind(ItemDefinition o1, QName qname2) {
        if (o1.getTypeRef() != null && o1.getTypeRef().equals(qname2)) {
            return true;
        }
        for (ItemDefinition ic : o1.getItemComponent()) {
            if (!ItemDefinitionDependenciesSorter.recurseFind(ic, qname2)) continue;
            return true;
        }
        return false;
    }

    private static boolean directFind(ItemDefinition o1, QName qname2) {
        if (o1.getTypeRef() != null && o1.getTypeRef().equals(qname2)) {
            return true;
        }
        for (ItemDefinition ic : o1.getItemComponent()) {
            if (!(ic.getTypeRef() == null ? ItemDefinitionDependenciesSorter.directFind(ic, qname2) : ic.getTypeRef().equals(qname2))) continue;
            return true;
        }
        return false;
    }

    public static void displayDependencies(List<ItemDefinition> ins, String namespaceURI) {
        for (ItemDefinition in : ins) {
            System.out.println(in.getName());
            ArrayList<ItemDefinition> others = new ArrayList<ItemDefinition>(ins);
            others.remove(in);
            for (ItemDefinition other : others) {
                QName otherQName = new QName(namespaceURI, other.getName());
                if (ItemDefinitionDependenciesSorter.directFind(in, otherQName)) {
                    System.out.println(" direct depends on: " + other.getName());
                    continue;
                }
                if (!ItemDefinitionDependenciesSorter.recurseFind(in, otherQName)) continue;
                System.out.println(" indir. depends on: " + other.getName());
            }
        }
    }
}

