/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.pmml;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.pmml.DMNPMMLModelInfo;
import org.kie.dmn.core.pmml.PMMLInfo;
import org.kie.dmn.core.pmml.PMMLModelInfo;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.model.api.Import;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNImportPMMLInfo
extends PMMLInfo<DMNPMMLModelInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(DMNImportPMMLInfo.class);
    private final Import i;

    public DMNImportPMMLInfo(Import i, Collection<DMNPMMLModelInfo> models, PMMLInfo.PMMLHeaderInfo h) {
        super(models, h);
        this.i = i;
    }

    public static Either<Exception, DMNImportPMMLInfo> from(InputStream is, DMNModelImpl model, Import i) {
        try {
            PMMLInfo<PMMLModelInfo> prototype = PMMLInfo.from(is);
            PMMLInfo.PMMLHeaderInfo h = prototype.getHeader();
            List<DMNPMMLModelInfo> models = prototype.getModels().stream().map(proto -> DMNPMMLModelInfo.from(proto, model)).collect(Collectors.toList());
            DMNImportPMMLInfo info = new DMNImportPMMLInfo(i, models, h);
            return Either.ofRight((Object)info);
        }
        catch (Throwable e) {
            return Either.ofLeft((Object)new Exception(e));
        }
    }

    public String getImportName() {
        return this.i.getName();
    }
}

