/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.pmml;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.pmml.PMMLModelInfo;

public class DMNPMMLModelInfo
extends PMMLModelInfo {
    private final Map<String, DMNType> inputFields;

    public DMNPMMLModelInfo(String name, Map<String, DMNType> inputFields, Collection<String> targetFields, Collection<String> outputFields) {
        super(name, inputFields.keySet(), targetFields, outputFields);
        this.inputFields = Collections.unmodifiableMap(new HashMap<String, DMNType>(inputFields));
    }

    public static DMNPMMLModelInfo from(PMMLModelInfo info, DMNModelImpl model) {
        HashMap<String, DMNType> inputFields = new HashMap<String, DMNType>();
        for (String name : info.inputFieldNames) {
            inputFields.put(name, model.getTypeRegistry().unknown());
        }
        return new DMNPMMLModelInfo(info.name, inputFields, info.targetFieldNames, info.outputFieldNames);
    }

    public Map<String, DMNType> getInputFields() {
        return this.inputFields;
    }
}

