/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.pmml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.Extension;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.PMML;
import org.jpmml.model.PMMLUtil;
import org.kie.dmn.core.pmml.PMMLModelInfo;
import org.xml.sax.SAXException;

public class PMMLInfo<M extends PMMLModelInfo> {
    protected final Collection<M> models;
    protected final PMMLHeaderInfo header;

    public PMMLInfo(Collection<M> models, PMMLHeaderInfo header) {
        this.models = Collections.unmodifiableList(new ArrayList<M>(models));
        this.header = header;
    }

    public static PMMLInfo<PMMLModelInfo> from(InputStream is) throws SAXException, JAXBException {
        PMML pmml = PMMLUtil.unmarshal((InputStream)is);
        ArrayList<PMMLModelInfo> models = new ArrayList<PMMLModelInfo>();
        for (Object pm : pmml.getModels()) {
            MiningSchema miningSchema = pm.getMiningSchema();
            ArrayList<String> inputFields = new ArrayList<String>();
            miningSchema.getMiningFields().stream().filter(mf -> mf.getUsageType() == MiningField.UsageType.ACTIVE).forEach(fn -> inputFields.add(fn.getName().getValue()));
            ArrayList<String> targetFields = new ArrayList<String>();
            miningSchema.getMiningFields().stream().filter(mf -> mf.getUsageType() == MiningField.UsageType.PREDICTED).forEach(fn -> targetFields.add(fn.getName().getValue()));
            ArrayList<String> outputFields = new ArrayList<String>();
            if (pm.getOutput() != null && pm.getOutput().getOutputFields() != null) {
                pm.getOutput().getOutputFields().forEach(of -> outputFields.add(of.getName().getValue()));
            }
            models.add(new PMMLModelInfo(pm.getModelName(), inputFields, targetFields, outputFields));
        }
        HashMap<String, String> headerExtensions = new HashMap<String, String>();
        for (Extension ex : pmml.getHeader().getExtensions()) {
            headerExtensions.put(ex.getName(), ex.getValue());
        }
        PMMLInfo<PMMLModelInfo> info = new PMMLInfo<PMMLModelInfo>(models, new PMMLHeaderInfo("http://www.dmg.org/PMML-" + pmml.getBaseVersion().replace(".", "_"), headerExtensions));
        return info;
    }

    public Collection<M> getModels() {
        return this.models;
    }

    public PMMLHeaderInfo getHeader() {
        return this.header;
    }

    public static class PMMLHeaderInfo {
        protected final Map<String, String> headerExtensions;
        protected final String pmmlNSURI;

        public PMMLHeaderInfo(String pmmlNSURI, Map<String, String> headerExtensions) {
            this.pmmlNSURI = pmmlNSURI;
            this.headerExtensions = Collections.unmodifiableMap(new HashMap<String, String>(headerExtensions));
        }

        public Map<String, String> getHeaderExtensions() {
            return this.headerExtensions;
        }

        public String getPmmlNSURI() {
            return this.pmmlNSURI;
        }
    }
}

