/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import com.github.javaparser.ast.nodeTypes.NodeWithOptionalScope;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithTraversableScope;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.UnknownType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.IndexUtil;
import org.drools.model.functions.Operator;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyper;
import org.drools.modelcompiler.util.ClassUtil;
import org.drools.mvel.parser.DrlxParser;
import org.drools.mvel.parser.ParseStart;
import org.drools.mvel.parser.ast.expr.BigDecimalLiteralExpr;
import org.drools.mvel.parser.ast.expr.BigIntegerLiteralExpr;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.expr.DrlxExpression;
import org.drools.mvel.parser.ast.expr.HalfBinaryExpr;
import org.drools.mvel.parser.ast.expr.MapCreationLiteralExpression;
import org.drools.mvel.parser.ast.expr.NullSafeFieldAccessExpr;
import org.drools.mvel.parser.printer.PrintUtil;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class DrlxParseUtil {
    private static final Map<String, Method> accessorsCache = new HashMap<String, Method>();

    public static IndexUtil.ConstraintType toConstraintType(BinaryExpr.Operator operator) {
        switch (operator) {
            case EQUALS: {
                return IndexUtil.ConstraintType.EQUAL;
            }
            case NOT_EQUALS: {
                return IndexUtil.ConstraintType.NOT_EQUAL;
            }
            case GREATER: {
                return IndexUtil.ConstraintType.GREATER_THAN;
            }
            case GREATER_EQUALS: {
                return IndexUtil.ConstraintType.GREATER_OR_EQUAL;
            }
            case LESS: {
                return IndexUtil.ConstraintType.LESS_THAN;
            }
            case LESS_EQUALS: {
                return IndexUtil.ConstraintType.LESS_OR_EQUAL;
            }
        }
        return IndexUtil.ConstraintType.UNKNOWN;
    }

    public static Expression findLeftLeafOfMethodCall(Expression expression) {
        if (expression instanceof BinaryExpr) {
            BinaryExpr be = (BinaryExpr)expression;
            return DrlxParseUtil.findLeftLeafOfMethodCall(be.getLeft());
        }
        if (expression instanceof CastExpr) {
            CastExpr ce = (CastExpr)expression;
            return DrlxParseUtil.findLeftLeafOfMethodCall(ce.getExpression());
        }
        if (expression instanceof MethodCallExpr) {
            return expression;
        }
        if (expression instanceof FieldAccessExpr) {
            return expression;
        }
        throw new UnsupportedOperationException("Unknown expression: " + expression);
    }

    private static BinaryExpr.Operator toBinaryExprOperator(HalfBinaryExpr.Operator operator) {
        return BinaryExpr.Operator.valueOf((String)operator.name());
    }

    public static TypedExpression nameExprToMethodCallExpr(String name, Type type, Expression scope) {
        if (type == null) {
            return null;
        }
        Class<?> clazz = ClassUtil.toRawClass(type);
        Method accessor = DrlxParseUtil.getAccessor(clazz, name);
        if (accessor != null) {
            MethodCallExpr body = new MethodCallExpr(scope, accessor.getName());
            return new TypedExpression((Expression)body, accessor.getGenericReturnType());
        }
        for (Class<?> declaredClass : clazz.getClasses()) {
            if (!declaredClass.getCanonicalName().endsWith("." + name)) continue;
            FieldAccessExpr fieldAccessExpr = new FieldAccessExpr(scope, name);
            return new TypedExpression((Expression)fieldAccessExpr, declaredClass);
        }
        if (clazz.isArray() && name.equals("length")) {
            FieldAccessExpr expr = new FieldAccessExpr((Expression)(scope != null ? scope : new NameExpr("_this")), name);
            return new TypedExpression((Expression)expr, Integer.TYPE);
        }
        try {
            Field field = clazz.getField(name);
            if (scope == null) {
                scope = new NameExpr(Modifier.isStatic(field.getModifiers()) ? clazz.getCanonicalName() : "_this");
            }
            FieldAccessExpr expr = new FieldAccessExpr(scope, name);
            return new TypedExpression((Expression)expr, field.getType());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Type returnTypeOfMethodCallExpr(RuleContext context, TypeResolver typeResolver, MethodCallExpr methodCallExpr, Type clazz, Collection<String> usedDeclarations) {
        Class[] argsType = (Class[])methodCallExpr.getArguments().stream().map(e -> DrlxParseUtil.getExpressionType(context, typeResolver, e, usedDeclarations)).toArray(Class[]::new);
        return ClassUtil.findMethod(ClassUtil.toRawClass(clazz), methodCallExpr.getNameAsString(), argsType).getGenericReturnType();
    }

    public static Type getExpressionType(RuleContext context, TypeResolver typeResolver, Expression expr, Collection<String> usedDeclarations) {
        if (expr instanceof LiteralExpr) {
            return DrlxParseUtil.getLiteralExpressionType((LiteralExpr)expr);
        }
        if (expr instanceof ArrayAccessExpr) {
            return DrlxParseUtil.getClassFromContext(typeResolver, ((ArrayCreationExpr)((ArrayAccessExpr)expr).getName()).getElementType().asString());
        }
        if (expr instanceof ArrayCreationExpr) {
            return DrlxParseUtil.getClassFromContext(typeResolver, ((ArrayCreationExpr)expr).getElementType().asString());
        }
        if (expr instanceof MapCreationLiteralExpression) {
            return Map.class;
        }
        if (expr instanceof NameExpr) {
            return DrlxParseUtil.expressionTypeNameExpr(context, usedDeclarations, ((NameExpr)expr).getNameAsString());
        }
        if (expr instanceof DrlNameExpr) {
            return DrlxParseUtil.expressionTypeNameExpr(context, usedDeclarations, ((DrlNameExpr)expr).getNameAsString());
        }
        if (expr instanceof BinaryExpr) {
            return Boolean.TYPE;
        }
        if (expr instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)expr;
            Optional scopeExpression = methodCallExpr.getScope();
            if (scopeExpression.isPresent()) {
                Type scopeType = DrlxParseUtil.getExpressionType(context, typeResolver, (Expression)scopeExpression.get(), usedDeclarations);
                return DrlxParseUtil.returnTypeOfMethodCallExpr(context, typeResolver, methodCallExpr, scopeType, usedDeclarations);
            }
            throw new IllegalStateException("Scope expression is not present for " + ((MethodCallExpr)expr).getNameAsString() + "!");
        }
        if (expr instanceof ObjectCreationExpr) {
            ClassOrInterfaceType type = ((ObjectCreationExpr)expr).getType();
            return DrlxParseUtil.getClassFromContext(typeResolver, type.asString());
        }
        if (expr.isCastExpr()) {
            String typeName = expr.asCastExpr().getType().toString();
            try {
                return typeResolver.resolveType(expr.asCastExpr().getType().toString());
            }
            catch (ClassNotFoundException e) {
                context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unknown type in cast expression: " + typeName));
                throw new RuntimeException("Unknown type in cast expression: " + typeName);
            }
        }
        if (expr instanceof ConditionalExpr) {
            Class<?> rightClass;
            ConditionalExpr ternaryExpr = (ConditionalExpr)expr;
            Type conditionType = DrlxParseUtil.getExpressionType(context, typeResolver, ternaryExpr.getCondition(), usedDeclarations);
            if (conditionType != Boolean.class && conditionType != Boolean.TYPE) {
                context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Condtion used in ternary expression '" + expr + "' isn't boolean"));
                return Object.class;
            }
            Type leftType = DrlxParseUtil.getExpressionType(context, typeResolver, ternaryExpr.getThenExpr(), usedDeclarations);
            Type rightType = DrlxParseUtil.getExpressionType(context, typeResolver, ternaryExpr.getElseExpr(), usedDeclarations);
            Class<?> leftClass = ClassUtil.toRawClass(leftType);
            if (leftClass.isAssignableFrom(rightClass = ClassUtil.toRawClass(rightType))) {
                return leftType;
            }
            if (rightClass.isAssignableFrom(leftClass)) {
                return rightType;
            }
            return Object.class;
        }
        throw new RuntimeException("Unknown expression type: " + PrintUtil.printConstraint((Node)expr));
    }

    private static Type expressionTypeNameExpr(RuleContext context, Collection<String> usedDeclarations, String nameAsString) {
        String name = nameAsString;
        if (usedDeclarations != null) {
            usedDeclarations.add(name);
        }
        Optional<Type> type = context.getDeclarationById(name).map(DeclarationSpec::getDeclarationClass);
        return type.orElseThrow(() -> new IllegalArgumentException("Cannot get expression type by name " + name + "!"));
    }

    public static boolean canCoerceLiteralNumberExpr(Class<?> type) {
        List<Class> classes = Arrays.asList(Integer.TYPE, Long.TYPE, Double.TYPE);
        return classes.contains(type);
    }

    public static Expression coerceLiteralNumberExprToType(LiteralStringValueExpr expr, Class<?> type) {
        if (type == Integer.TYPE) {
            return new IntegerLiteralExpr(expr.getValue());
        }
        if (type == Long.TYPE) {
            return new LongLiteralExpr(expr.getValue().endsWith("l") ? expr.getValue() : expr.getValue() + "l");
        }
        if (type == Double.TYPE) {
            return new DoubleLiteralExpr(expr.getValue().endsWith("d") ? expr.getValue() : expr.getValue() + "d");
        }
        throw new RuntimeException("Unknown literal: " + expr);
    }

    public static Class<?> getLiteralExpressionType(LiteralExpr expr) {
        if (expr instanceof BooleanLiteralExpr) {
            return Boolean.TYPE;
        }
        if (expr instanceof CharLiteralExpr) {
            return Character.TYPE;
        }
        if (expr instanceof DoubleLiteralExpr) {
            return Double.TYPE;
        }
        if (expr instanceof IntegerLiteralExpr) {
            return Integer.TYPE;
        }
        if (expr instanceof LongLiteralExpr) {
            return Long.TYPE;
        }
        if (expr instanceof NullLiteralExpr) {
            return ClassUtil.NullType.class;
        }
        if (expr instanceof StringLiteralExpr) {
            return String.class;
        }
        if (expr instanceof BigDecimalLiteralExpr) {
            return BigDecimal.class;
        }
        if (expr instanceof BigIntegerLiteralExpr) {
            return BigInteger.class;
        }
        throw new RuntimeException("Unknown literal: " + expr);
    }

    public static Expression prepend(Expression scope, Expression expr) {
        Optional<Expression> rootNode = DrlxParseUtil.findRootNodeViaScope(expr);
        if (rootNode.isPresent()) {
            if (rootNode.get() instanceof NodeWithOptionalScope) {
                ((NodeWithOptionalScope)rootNode.get()).setScope(scope);
            }
            return expr;
        }
        throw new IllegalStateException("No root node was found!");
    }

    public static Optional<Node> findRootNodeViaParent(Node expr) {
        Optional parentNode = expr.getParentNode();
        if (parentNode.isPresent()) {
            return DrlxParseUtil.findRootNodeViaParent((Node)parentNode.get());
        }
        return Optional.of(expr);
    }

    public static Node replaceAllHalfBinaryChildren(Node parent) {
        parent.findAll(HalfBinaryExpr.class).forEach(n -> n.replace((Node)DrlxParseUtil.trasformHalfBinaryToBinary((Expression)n)));
        return parent;
    }

    public static Expression trasformHalfBinaryToBinary(Expression drlxExpr) {
        Optional parent = drlxExpr.getParentNode();
        if (drlxExpr instanceof HalfBinaryExpr && parent.isPresent()) {
            HalfBinaryExpr halfBinaryExpr = (HalfBinaryExpr)drlxExpr;
            Expression parentLeft = ExpressionTyper.findLeftLeafOfNameExpr((Node)parent.get());
            BinaryExpr.Operator operator = DrlxParseUtil.toBinaryExprOperator(halfBinaryExpr.getOperator());
            return new BinaryExpr(parentLeft, halfBinaryExpr.getRight(), operator);
        }
        return drlxExpr;
    }

    public static MethodCallExpr findLastMethodInChain(MethodCallExpr expr) {
        return expr.getScope().filter(MethodCallExpr.class::isInstance).map(MethodCallExpr.class::cast).map(DrlxParseUtil::findLastMethodInChain).orElse(expr);
    }

    public static RemoveRootNodeResult findRemoveRootNodeViaScope(Expression expr) {
        return DrlxParseUtil.findRootNodeViaScopeRec(expr, new LinkedList<Expression>());
    }

    public static Optional<Expression> findRootNodeViaScope(Expression expr) {
        return DrlxParseUtil.findRemoveRootNodeViaScope(expr).rootNode;
    }

    public static RemoveRootNodeResult removeRootNode(Expression expr) {
        return DrlxParseUtil.findRemoveRootNodeViaScope(expr);
    }

    private static RemoveRootNodeResult findRootNodeViaScopeRec(Expression expr, LinkedList<Expression> acc) {
        if (expr.isArrayAccessExpr()) {
            throw new RuntimeException("This doesn't work on arrayAccessExpr convert them to a method call");
        }
        if (expr instanceof EnclosedExpr) {
            return DrlxParseUtil.findRootNodeViaScopeRec(expr.asEnclosedExpr().getInner(), acc);
        }
        if (expr instanceof NodeWithTraversableScope) {
            NodeWithTraversableScope exprWithScope = (NodeWithTraversableScope)expr;
            return exprWithScope.traverseScope().map(scope -> {
                Expression sanitizedExpr = DrlxParseUtil.transformDrlNameExprToNameExpr(expr);
                acc.addLast(sanitizedExpr.clone());
                return DrlxParseUtil.findRootNodeViaScopeRec(scope, acc);
            }).orElse(new RemoveRootNodeResult(Optional.of(expr), expr));
        }
        if (expr instanceof NameExpr || expr instanceof DrlNameExpr) {
            if (acc.size() > 0 && acc.getLast() instanceof NodeWithOptionalScope) {
                ((NodeWithOptionalScope)acc.getLast()).setScope(null);
                ListIterator iterator = acc.listIterator();
                while (iterator.hasNext()) {
                    Expression e = (Expression)iterator.next();
                    NodeWithOptionalScope node = (NodeWithOptionalScope)e;
                    if (!iterator.hasNext()) continue;
                    node.setScope(acc.get(iterator.nextIndex()));
                }
                return new RemoveRootNodeResult(Optional.of(expr), acc.getFirst());
            }
            return new RemoveRootNodeResult(Optional.of(expr), expr);
        }
        return new RemoveRootNodeResult(Optional.empty(), expr);
    }

    public static String fromVar(String key) {
        return key.substring("var_".length());
    }

    public static BlockStmt parseBlock(String ruleConsequenceAsBlock) throws ParseProblemException {
        return StaticJavaParser.parseBlock((String)String.format("{%n%s%n}", ruleConsequenceAsBlock));
    }

    public static Expression generateLambdaWithoutParameters(Collection<String> usedDeclarations, Expression expr) {
        return DrlxParseUtil.generateLambdaWithoutParameters(usedDeclarations, expr, false);
    }

    public static Expression generateLambdaWithoutParameters(Expression expr) {
        Collection usedDeclarations = expr.findAll(NameExpr.class).stream().map(NameExpr::getName).map(SimpleName::getIdentifier).collect(Collectors.toList());
        return DrlxParseUtil.generateLambdaWithoutParameters(usedDeclarations, expr, true);
    }

    public static Expression generateLambdaWithoutParameters(Collection<String> usedDeclarations, Expression expr, boolean skipFirstParamAsThis) {
        DrlxParseUtil.transformDrlNameExprToNameExpr(expr);
        if (skipFirstParamAsThis && usedDeclarations.isEmpty()) {
            return expr;
        }
        LambdaExpr lambdaExpr = new LambdaExpr();
        lambdaExpr.setEnclosingParameters(true);
        if (!skipFirstParamAsThis) {
            lambdaExpr.addParameter(new Parameter((com.github.javaparser.ast.type.Type)new UnknownType(), "_this"));
        }
        usedDeclarations.stream().map(s -> new Parameter((com.github.javaparser.ast.type.Type)new UnknownType(), s)).forEach(arg_0 -> ((LambdaExpr)lambdaExpr).addParameter(arg_0));
        lambdaExpr.setBody((Statement)new ExpressionStmt(expr));
        return lambdaExpr;
    }

    public static TypedExpression toMethodCallWithClassCheck(RuleContext context, Expression expr, String bindingId, Class<?> clazz, TypeResolver typeResolver) {
        LinkedList<ParsedMethod> callStackLeftToRight = new LinkedList<ParsedMethod>();
        DrlxParseUtil.createExpressionCall(expr, callStackLeftToRight);
        Type previousClass = clazz;
        NameExpr previousScope = null;
        for (ParsedMethod e : callStackLeftToRight) {
            if (e.expression instanceof DrlNameExpr || e.expression instanceof NameExpr || e.expression instanceof FieldAccessExpr || e.expression instanceof NullSafeFieldAccessExpr) {
                if (e.fieldToResolve.equals(bindingId)) continue;
                if (previousClass == null) {
                    try {
                        previousClass = typeResolver.resolveType(e.fieldToResolve);
                        previousScope = new NameExpr(e.fieldToResolve);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (previousClass != null) continue;
                    previousClass = context.getDeclarationById(e.fieldToResolve).map(DeclarationSpec::getDeclarationClass).orElseThrow(() -> new RuntimeException("Unknown field: " + e.fieldToResolve));
                    previousScope = e.expression;
                    continue;
                }
                TypedExpression te = DrlxParseUtil.nameExprToMethodCallExpr(e.fieldToResolve, previousClass, previousScope);
                if (te == null) {
                    context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unknown field " + e.fieldToResolve + " on " + previousClass));
                    return null;
                }
                Type returnType = te.getType();
                previousScope = te.getExpression();
                previousClass = returnType;
                continue;
            }
            if (!(e.expression instanceof MethodCallExpr)) continue;
            Type returnType = DrlxParseUtil.returnTypeOfMethodCallExpr(context, typeResolver, (MethodCallExpr)e.expression, previousClass, null);
            MethodCallExpr cloned = ((MethodCallExpr)e.expression.clone()).setScope((Expression)previousScope);
            previousScope = cloned;
            previousClass = returnType;
        }
        return new TypedExpression((Expression)previousScope, previousClass);
    }

    private static Expression createExpressionCall(Expression expr, Deque<ParsedMethod> expressions) {
        if (expr instanceof NodeWithSimpleName) {
            NodeWithSimpleName fae = (NodeWithSimpleName)expr;
            expressions.push(new ParsedMethod(expr, fae.getName().asString()));
        }
        if (expr instanceof NodeWithOptionalScope) {
            NodeWithOptionalScope exprWithScope = (NodeWithOptionalScope)expr;
            exprWithScope.getScope().ifPresent(expression -> DrlxParseUtil.createExpressionCall(expression, expressions));
        } else if (expr instanceof FieldAccessExpr) {
            DrlxParseUtil.createExpressionCall(((FieldAccessExpr)expr).getScope(), expressions);
        }
        return expr;
    }

    public static com.github.javaparser.ast.type.Type classToReferenceType(Class<?> declClass) {
        com.github.javaparser.ast.type.Type parsedType = StaticJavaParser.parseType((String)declClass.getCanonicalName());
        return parsedType instanceof PrimitiveType ? ((PrimitiveType)parsedType).toBoxedType() : parsedType;
    }

    public static com.github.javaparser.ast.type.Type toType(Class<?> declClass) {
        return StaticJavaParser.parseType((String)declClass.getCanonicalName());
    }

    public static ClassOrInterfaceType toClassOrInterfaceType(Class<?> declClass) {
        return DrlxParseUtil.toClassOrInterfaceType(declClass.getCanonicalName());
    }

    public static ClassOrInterfaceType toClassOrInterfaceType(String className) {
        return StaticJavaParser.parseClassOrInterfaceType((String)className);
    }

    public static Optional<String> findBindingIdFromDotExpression(String expression) {
        int dot = expression.indexOf(46);
        if (dot < 0) {
            return Optional.empty();
        }
        return Optional.of(expression.substring(0, dot));
    }

    public static Optional<Expression> findViaScopeWithPredicate(Expression expr, Predicate<Expression> predicate) {
        Boolean result = predicate.test(expr);
        if (result.booleanValue()) {
            return Optional.of(expr);
        }
        if (expr instanceof NodeWithTraversableScope) {
            NodeWithTraversableScope exprWithScope = (NodeWithTraversableScope)expr;
            return exprWithScope.traverseScope().map(expr1 -> DrlxParseUtil.findViaScopeWithPredicate(expr1, predicate)).orElse(Optional.of(expr));
        }
        return Optional.empty();
    }

    public static DrlxExpression parseExpression(String expression) {
        return DrlxParser.parseExpression((ParseStart)DrlxParser.buildDrlxParserWithArguments(OperatorsHolder.operators), (String)expression);
    }

    public static Class<?> getClassFromType(TypeResolver typeResolver, com.github.javaparser.ast.type.Type type) {
        return DrlxParseUtil.getClassFromContext(typeResolver, type.asString());
    }

    public static Class<?> getClassFromContext(TypeResolver typeResolver, String className) {
        try {
            return typeResolver.resolveType(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPrimitiveExpression(Expression expr) {
        if (!(expr instanceof LiteralExpr)) {
            return false;
        }
        return expr instanceof NullLiteralExpr || expr instanceof IntegerLiteralExpr || expr instanceof DoubleLiteralExpr || expr instanceof BooleanLiteralExpr || expr instanceof LongLiteralExpr;
    }

    public static void forceCastForName(String nameRef, com.github.javaparser.ast.type.Type type, Expression expression) {
        List allNameExprForName = expression.findAll(NameExpr.class, n -> n.getNameAsString().equals(nameRef));
        for (NameExpr n2 : allNameExprForName) {
            Optional parentNode = n2.getParentNode();
            if (parentNode.isPresent()) {
                ((Node)parentNode.get()).replace((Node)n2, (Node)new EnclosedExpr((Expression)new CastExpr(type, (Expression)n2)));
                continue;
            }
            throw new IllegalStateException("Cannot find parent node for " + n2.getNameAsString() + "!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rescopeNamesToNewScope(Expression newScope, List<String> names, Expression e) {
        if (e instanceof NodeWithArguments) {
            NodeWithArguments arguments = (NodeWithArguments)e;
            for (Expression argument : arguments.getArguments()) {
                DrlxParseUtil.rescopeNamesToNewScope(newScope, names, argument);
            }
        }
        if (e instanceof AssignExpr) {
            AssignExpr assignExpr = (AssignExpr)e;
            DrlxParseUtil.rescopeNamesToNewScope(newScope, names, assignExpr.getTarget());
            DrlxParseUtil.rescopeNamesToNewScope(newScope, names, assignExpr.getValue());
            return;
        } else if (e instanceof BinaryExpr) {
            DrlxParseUtil.rescopeNamesToNewScope(newScope, names, ((BinaryExpr)e).getLeft());
            DrlxParseUtil.rescopeNamesToNewScope(newScope, names, ((BinaryExpr)e).getRight());
            return;
        } else if (e instanceof UnaryExpr) {
            DrlxParseUtil.rescopeNamesToNewScope(newScope, names, ((UnaryExpr)e).getExpression());
            return;
        } else if (e instanceof EnclosedExpr) {
            DrlxParseUtil.rescopeNamesToNewScope(newScope, names, ((EnclosedExpr)e).getInner());
            return;
        } else {
            NameExpr nameExpr;
            Optional<Expression> rootNode = DrlxParseUtil.findRootNodeViaScope(e);
            if (!rootNode.isPresent() || !(rootNode.get() instanceof NameExpr) || !names.contains((nameExpr = (NameExpr)rootNode.get()).getNameAsString())) return;
            FieldAccessExpr prepend = new FieldAccessExpr(newScope, nameExpr.getNameAsString());
            if (e instanceof NameExpr) {
                Optional parentNode = e.getParentNode();
                if (!parentNode.isPresent()) throw new IllegalStateException("Cannot find parent node for " + ((NameExpr)e).getNameAsString() + "!");
                ((Node)parentNode.get()).replace((Node)nameExpr, (Node)prepend);
                return;
            } else {
                e.replace((Node)nameExpr, (Node)prepend);
            }
        }
    }

    public static List<String> getPatternListenedProperties(PatternDescr pattern) {
        AnnotationDescr watchAnn = pattern != null ? pattern.getAnnotation("watch") : null;
        return watchAnn == null ? Collections.emptyList() : Stream.of(watchAnn.getValue().toString().split(",")).map(String::trim).map(StringUtils::lcFirst).collect(Collectors.toList());
    }

    public static Optional<MethodCallExpr> findPatternWithBinding(RuleContext context, String patternBinding, List<Expression> expressions) {
        return expressions.stream().flatMap(e -> {
            Optional pattern = e.findFirst(MethodCallExpr.class, expr -> {
                boolean isPatternExpr = expr.getName().asString().equals("D.pattern");
                boolean hasBindingHasArgument = expr.getArguments().contains((Node)context.getVarExpr(patternBinding));
                return isPatternExpr && hasBindingHasArgument;
            });
            return pattern.map(Stream::of).orElse(Stream.empty());
        }).findFirst();
    }

    public static Optional<MethodCallExpr> findLastPattern(List<Expression> expressions) {
        Stream patterns = expressions.stream().flatMap(e -> {
            List pattern = e.findAll(MethodCallExpr.class, expr -> expr.getName().asString().equals("D.pattern"));
            return pattern.stream();
        });
        List collect = patterns.collect(Collectors.toList());
        if (collect.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(collect.get(collect.size() - 1));
    }

    public static boolean hasScopeWithName(MethodCallExpr expression, String name) {
        return DrlxParseUtil.findRootNodeViaScope((Expression)expression).filter(s -> DrlxParseUtil.isNameExprWithName((Node)s, name)).isPresent();
    }

    public static boolean isNameExprWithName(Node expression, String name) {
        return expression instanceof NameExpr && ((NameExpr)expression).getNameAsString().equals(name);
    }

    public static List<Node> findAllChildrenRecursive(Expression e) {
        ArrayList<Node> accumulator = new ArrayList<Node>();
        DrlxParseUtil.findAllChildrenRecursiveRec(accumulator, (Node)e);
        return accumulator;
    }

    private static void findAllChildrenRecursiveRec(List<Node> accumulator, Node e) {
        for (Node child : e.getChildNodes()) {
            accumulator.add(child);
            DrlxParseUtil.findAllChildrenRecursiveRec(accumulator, child);
        }
    }

    public static String toVar(String key) {
        return "var_" + key;
    }

    public static Optional<InvalidExpressionErrorResult> validateDuplicateBindings(String ruleName, List<String> allBindings) {
        HashSet<String> duplicates = new HashSet<String>();
        for (String b : allBindings) {
            Boolean notExisting = duplicates.add(b);
            if (notExisting.booleanValue()) continue;
            return Optional.of(new InvalidExpressionErrorResult(String.format("Duplicate declaration for variable '%s' in the rule '%s'", b, ruleName)));
        }
        return Optional.empty();
    }

    public static Method getAccessor(Class<?> clazz, String name) {
        return accessorsCache.computeIfAbsent(clazz.getCanonicalName() + "." + name, k -> ClassUtils.getAccessor((Class)clazz, (String)name));
    }

    public static void clearAccessorCache() {
        accessorsCache.clear();
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static <T extends Node> T transformDrlNameExprToNameExpr(T e) {
        e.findAll(DrlNameExpr.class).forEach(n -> n.replace((Node)new NameExpr(n.getName())));
        if (e instanceof DrlNameExpr) {
            return (T)new NameExpr(((DrlNameExpr)e).getName());
        }
        return e;
    }

    public static MethodCallExpr sanitizeDrlNameExpr(MethodCallExpr me) {
        NodeList arguments = NodeList.nodeList((Node[])new Expression[0]);
        for (Expression e2 : me.getArguments()) {
            arguments.add((Node)DrlxParseUtil.sanitizeExpr(e2, (Expression)me));
        }
        me.getScope().map(e -> DrlxParseUtil.sanitizeExpr(e, (Expression)me)).ifPresent(arg_0 -> ((MethodCallExpr)me).setScope(arg_0));
        me.setArguments(arguments);
        return me;
    }

    private static Expression sanitizeExpr(Expression e, Expression parent) {
        Expression sanitized;
        if (e instanceof DrlNameExpr) {
            sanitized = new NameExpr(PrintUtil.printConstraint((Node)e));
            sanitized.setParentNode((Node)parent);
        } else {
            sanitized = e;
        }
        return sanitized;
    }

    public static String addCurlyBracesToBlock(String blockString) {
        return String.format("{%s}", blockString);
    }

    static class OperatorsHolder {
        static final Collection<String> operators = OperatorsHolder.getOperators();

        OperatorsHolder() {
        }

        private static Collection<String> getOperators() {
            ArrayList<String> operators = new ArrayList<String>();
            operators.addAll(Operator.Register.getOperators());
            operators.addAll(ModelGenerator.temporalOperators);
            return operators;
        }
    }

    static class ParsedMethod {
        final Expression expression;
        final String fieldToResolve;

        public ParsedMethod(Expression expression, String fieldToResolve) {
            this.expression = expression;
            this.fieldToResolve = fieldToResolve;
        }

        public String toString() {
            return "{expression=" + this.expression + ", fieldToResolve='" + this.fieldToResolve + '\'' + '}';
        }
    }

    public static class RemoveRootNodeResult {
        private Optional<Expression> rootNode;
        private Expression withoutRootNode;

        public RemoveRootNodeResult(Optional<Expression> rootNode, Expression withoutRootNode) {
            this.rootNode = rootNode;
            this.withoutRootNode = withoutRootNode;
        }

        public Optional<Expression> getRootNode() {
            return this.rootNode;
        }

        public Expression getWithoutRootNode() {
            return this.withoutRootNode;
        }

        public String toString() {
            return "RemoveRootNodeResult{rootNode=" + this.rootNode.map(PrintUtil::printConstraint) + ", withoutRootNode=" + PrintUtil.printConstraint((Node)this.withoutRootNode) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveRootNodeResult that = (RemoveRootNodeResult)o;
            return Objects.equals(this.rootNode.map(PrintUtil::printConstraint), that.rootNode.map(PrintUtil::printConstraint)) && Objects.equals(PrintUtil.printConstraint((Node)this.withoutRootNode), PrintUtil.printConstraint((Node)that.withoutRootNode));
        }

        public int hashCode() {
            return Objects.hash(this.rootNode, this.withoutRootNode);
        }
    }
}

