/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.ResourceTypePackageRegistry;
import org.drools.core.impl.InternalKnowledgeBase;
import org.kie.api.io.ResourceType;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNPackage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.BusinessKnowledgeModelNodeImpl;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DMNDecisionServiceEvaluator;
import org.kie.dmn.core.ast.DMNFunctionWithReturnType;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.ast.DecisionServiceNodeImpl;
import org.kie.dmn.core.ast.InputDataNodeImpl;
import org.kie.dmn.core.compiler.DMNOption;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.DMNDecisionResultImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.DMNPackageImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerUtils;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNRuntimeImpl
implements DMNRuntime {
    private static final Logger logger = LoggerFactory.getLogger(DMNRuntimeImpl.class);
    private DMNRuntimeEventManagerImpl eventManager;
    private final InternalKnowledgeBase knowledgeBase;
    private boolean overrideRuntimeTypeCheck = false;

    public DMNRuntimeImpl(InternalKnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        this.eventManager = new DMNRuntimeEventManagerImpl();
    }

    public List<DMNModel> getModels() {
        ArrayList<DMNModel> models = new ArrayList<DMNModel>();
        this.knowledgeBase.getKiePackages().forEach(kpkg -> {
            DMNPackage dmnPkg = (DMNPackage)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.DMN);
            if (dmnPkg != null) {
                dmnPkg.getAllModels().values().forEach(model -> models.add((DMNModel)model));
            }
        });
        return models;
    }

    public DMNModel getModel(String namespace, String modelName) {
        Objects.requireNonNull(namespace, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "namespace"));
        Objects.requireNonNull(modelName, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "modelName"));
        InternalKnowledgePackage kpkg = (InternalKnowledgePackage)this.knowledgeBase.getKiePackage(namespace);
        if (kpkg == null) {
            return null;
        }
        ResourceTypePackageRegistry map = kpkg.getResourceTypePackages();
        DMNPackage dmnpkg = (DMNPackage)map.get(ResourceType.DMN);
        return dmnpkg != null ? dmnpkg.getModel(modelName) : null;
    }

    public DMNModel getModelById(String namespace, String modelId) {
        Objects.requireNonNull(namespace, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "namespace"));
        Objects.requireNonNull(modelId, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "modelId"));
        InternalKnowledgePackage kpkg = (InternalKnowledgePackage)this.knowledgeBase.getKiePackage(namespace);
        if (kpkg == null) {
            return null;
        }
        ResourceTypePackageRegistry map = kpkg.getResourceTypePackages();
        DMNPackage dmnpkg = (DMNPackage)map.get(ResourceType.DMN);
        return dmnpkg != null ? dmnpkg.getModelById(modelId) : null;
    }

    public DMNResult evaluateAll(DMNModel model, DMNContext context) {
        Objects.requireNonNull(model, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "model"));
        Objects.requireNonNull(context, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "context"));
        boolean performRuntimeTypeCheck = this.performRuntimeTypeCheck(model);
        DMNResultImpl result = this.createResult(model, context);
        Set decisions = model.getDecisions().stream().filter(d -> d.getModelNamespace().equals(model.getNamespace())).collect(Collectors.toSet());
        for (DecisionNode decision : decisions) {
            this.evaluateDecision(context, result, decision, performRuntimeTypeCheck);
        }
        return result;
    }

    @Deprecated
    public DMNResult evaluateDecisionByName(DMNModel model, String decisionName, DMNContext context) {
        Objects.requireNonNull(model, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "model"));
        Objects.requireNonNull(decisionName, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "decisionName"));
        Objects.requireNonNull(context, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "context"));
        return this.evaluateByName(model, context, decisionName);
    }

    @Deprecated
    public DMNResult evaluateDecisionById(DMNModel model, String decisionId, DMNContext context) {
        Objects.requireNonNull(model, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "model"));
        Objects.requireNonNull(decisionId, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "decisionId"));
        Objects.requireNonNull(context, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "context"));
        return this.evaluateById(model, context, decisionId);
    }

    public DMNResult evaluateByName(DMNModel model, DMNContext context, String ... decisionNames) {
        Objects.requireNonNull(model, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "model"));
        Objects.requireNonNull(context, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "context"));
        Objects.requireNonNull(decisionNames, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "decisionNames"));
        DMNResultImpl result = this.createResult(model, context);
        for (String name : decisionNames) {
            this.evaluateByNameInternal(model, context, result, name);
        }
        return result;
    }

    private void evaluateByNameInternal(DMNModel model, DMNContext context, DMNResultImpl result, String name) {
        boolean performRuntimeTypeCheck = this.performRuntimeTypeCheck(model);
        Optional<DecisionNode> decision = Optional.ofNullable(model.getDecisionByName(name));
        if (decision.isPresent()) {
            this.evaluateDecision(context, result, decision.get(), performRuntimeTypeCheck);
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, null, result, null, null, Msg.DECISION_NOT_FOUND_FOR_NAME, name);
        }
    }

    public DMNResult evaluateById(DMNModel model, DMNContext context, String ... decisionIds) {
        Objects.requireNonNull(model, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "model"));
        Objects.requireNonNull(context, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "context"));
        Objects.requireNonNull(decisionIds, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "decisionIds"));
        DMNResultImpl result = this.createResult(model, context);
        for (String id : decisionIds) {
            this.evaluateByIdInternal(model, context, result, id);
        }
        return result;
    }

    private void evaluateByIdInternal(DMNModel model, DMNContext context, DMNResultImpl result, String id) {
        boolean performRuntimeTypeCheck = this.performRuntimeTypeCheck(model);
        Optional<DecisionNode> decision = Optional.ofNullable(model.getDecisionById(id));
        if (decision.isPresent()) {
            this.evaluateDecision(context, result, decision.get(), performRuntimeTypeCheck);
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, null, result, null, null, Msg.DECISION_NOT_FOUND_FOR_ID, id);
        }
    }

    public void addListener(DMNRuntimeEventListener listener) {
        this.eventManager.addListener(listener);
    }

    public void removeListener(DMNRuntimeEventListener listener) {
        this.eventManager.removeListener(listener);
    }

    public boolean hasListeners() {
        return this.eventManager.hasListeners();
    }

    public Set<DMNRuntimeEventListener> getListeners() {
        return this.eventManager.getListeners();
    }

    private DMNResultImpl createResult(DMNModel model, DMNContext context) {
        DMNResultImpl result = new DMNResultImpl(model);
        result.setContext(context.clone());
        for (DecisionNode decision : model.getDecisions().stream().filter(d -> d.getModelNamespace().equals(model.getNamespace())).collect(Collectors.toSet())) {
            result.addDecisionResult(new DMNDecisionResultImpl(decision.getId(), decision.getName()));
        }
        return result;
    }

    public DMNResult evaluateDecisionService(DMNModel model, DMNContext context, String decisionServiceName) {
        Objects.requireNonNull(model, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "model"));
        Objects.requireNonNull(context, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "context"));
        Objects.requireNonNull(decisionServiceName, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "decisionServiceName"));
        boolean typeCheck = this.performRuntimeTypeCheck(model);
        DMNResultImpl result = new DMNResultImpl(model);
        result.setContext(context.clone());
        Optional<DecisionServiceNode> lookupDS = ((DMNModelImpl)model).getDecisionServices().stream().filter(d -> d.getModelNamespace().equals(model.getNamespace())).filter(ds -> ds.getName().equals(decisionServiceName)).findFirst();
        if (lookupDS.isPresent()) {
            DecisionServiceNodeImpl decisionService = (DecisionServiceNodeImpl)lookupDS.get();
            for (DMNNode dep : decisionService.getInputParameters().values()) {
                if (!this.isNodeValueDefined(result, decisionService, dep)) {
                    DMNMessage message = MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)decisionService.getSource(), result, null, null, Msg.REQ_INPUT_NOT_FOUND_FOR_DS, DMNRuntimeImpl.getDependencyIdentifier(decisionService, dep), DMNRuntimeImpl.getIdentifier(decisionService));
                    boolean walkingIntoScope = this.walkIntoImportScope(result, decisionService, dep);
                    result.getContext().set(dep.getName(), null);
                    if (!walkingIntoScope) continue;
                    result.getContext().popScope();
                    continue;
                }
                boolean walkingIntoScope = this.walkIntoImportScope(result, decisionService, dep);
                Object originalValue = result.getContext().get(dep.getName());
                DMNType depType = ((DMNModelImpl)model).getTypeRegistry().unknown();
                if (dep instanceof InputDataNode) {
                    depType = ((InputDataNode)dep).getType();
                } else if (dep instanceof DecisionNode) {
                    depType = ((DecisionNode)dep).getResultType();
                }
                Object c = DMNRuntimeImpl.coerceUsingType(originalValue, depType, (r, t) -> MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)decisionService.getDecisionService(), result, null, null, Msg.PARAMETER_TYPE_MISMATCH_DS, DMNRuntimeImpl.getIdentifier(decisionService), t, MsgUtil.clipString(r.toString(), 50)));
                if (c != originalValue) {
                    result.getContext().set(dep.getName(), c);
                }
                if (!walkingIntoScope) continue;
                result.getContext().popScope();
            }
            EvaluatorResult evaluatorResult = new DMNDecisionServiceEvaluator(decisionService, true, false).evaluate((DMNRuntimeEventManager)this, result);
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, null, result, null, null, Msg.DECISION_SERVICE_NOT_FOUND_FOR_NAME, decisionServiceName);
        }
        return result;
    }

    private void evaluateDecisionService(DMNContext context, DMNResultImpl result, DecisionServiceNode d, boolean typeCheck) {
        DecisionServiceNodeImpl ds = (DecisionServiceNodeImpl)d;
        if (this.isNodeValueDefined(result, ds, ds)) {
            return;
        }
        try {
            EvaluatorResult er = ds.getEvaluator().evaluate((DMNRuntimeEventManager)this, result);
            if (er.getResultType() == EvaluatorResult.ResultType.SUCCESS) {
                FEELFunction resultFn = (FEELFunction)er.getResult();
                result.getContext().set(ds.getName(), (Object)resultFn);
            }
        }
        catch (Throwable t) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ds.getSource(), result, t, null, Msg.ERROR_EVAL_DS_NODE, DMNRuntimeImpl.getIdentifier(ds), t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateBKM(DMNContext context, DMNResultImpl result, BusinessKnowledgeModelNode b, boolean typeCheck) {
        BusinessKnowledgeModelNodeImpl bkm = (BusinessKnowledgeModelNodeImpl)b;
        if (this.isNodeValueDefined(result, bkm, bkm)) {
            return;
        }
        if (bkm.getEvaluator() == null) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)bkm.getSource(), result, null, null, Msg.MISSING_EXPRESSION_FOR_BKM, DMNRuntimeImpl.getIdentifier(bkm));
            return;
        }
        try {
            DMNRuntimeEventManagerUtils.fireBeforeEvaluateBKM(this.eventManager, bkm, result);
            for (DMNNode dep : bkm.getDependencies().values()) {
                if (typeCheck && !this.checkDependencyValueIsValid(dep, result)) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)dep).getSource(), result, null, null, Msg.ERROR_EVAL_NODE_DEP_WRONG_TYPE, DMNRuntimeImpl.getIdentifier(bkm), DMNRuntimeImpl.getDependencyIdentifier(bkm, dep), MsgUtil.clipString(Objects.toString(result.getContext().get(dep.getName())), 50), ((DMNBaseNode)dep).getType());
                    return;
                }
                if (this.isNodeValueDefined(result, bkm, dep)) continue;
                boolean walkingIntoScope = this.walkIntoImportScope(result, bkm, dep);
                if (dep instanceof BusinessKnowledgeModelNode) {
                    this.evaluateBKM(context, result, (BusinessKnowledgeModelNode)dep, typeCheck);
                } else if (dep instanceof DecisionServiceNode) {
                    this.evaluateDecisionService(context, result, (DecisionServiceNode)dep, typeCheck);
                } else {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)bkm.getSource(), result, null, null, Msg.REQ_DEP_NOT_FOUND_FOR_NODE, DMNRuntimeImpl.getDependencyIdentifier(bkm, dep), DMNRuntimeImpl.getIdentifier(bkm));
                    return;
                }
                if (!walkingIntoScope) continue;
                result.getContext().popScope();
            }
            EvaluatorResult er = bkm.getEvaluator().evaluate((DMNRuntimeEventManager)this, result);
            if (er.getResultType() == EvaluatorResult.ResultType.SUCCESS) {
                FEELFunction original_fn;
                Object resultFn = original_fn = (FEELFunction)er.getResult();
                if (typeCheck) {
                    DMNType resultType = b.getResultType();
                    resultFn = new DMNFunctionWithReturnType(original_fn, resultType, result, b);
                }
                result.getContext().set(bkm.getBusinessKnowledModel().getVariable().getName(), resultFn);
            }
        }
        catch (Throwable t) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)bkm.getSource(), result, t, null, Msg.ERROR_EVAL_BKM_NODE, DMNRuntimeImpl.getIdentifier(bkm), t.getMessage());
        }
        finally {
            DMNRuntimeEventManagerUtils.fireAfterEvaluateBKM(this.eventManager, bkm, result);
        }
    }

    public static Object coerceUsingType(Object value, DMNType type, BiConsumer<Object, DMNType> nullCallback) {
        Object result = value;
        if (!type.isCollection() && value instanceof Collection && ((Collection)value).size() == 1) {
            result = ((Collection)value).toArray()[0];
        }
        if (type.isAssignableValue(result)) {
            return result;
        }
        nullCallback.accept(value, type);
        return null;
    }

    private boolean isNodeValueDefined(DMNResultImpl result, DMNNode callerNode, DMNNode node) {
        Object aliasContext;
        if (node.getModelNamespace().equals(result.getContext().scopeNamespace().orElse(result.getModel().getNamespace()))) {
            return result.getContext().isDefined(node.getName());
        }
        Optional importAlias = callerNode.getModelImportAliasFor(node.getModelNamespace(), node.getModelName());
        if (importAlias.isPresent() && (aliasContext = result.getContext().get((String)importAlias.get())) != null && aliasContext instanceof Map) {
            Map map = (Map)aliasContext;
            return map.containsKey(node.getName());
        }
        return false;
    }

    private boolean walkIntoImportScope(DMNResultImpl result, DMNNode callerNode, DMNNode destinationNode) {
        if (!result.getContext().scopeNamespace().isPresent()) {
            if (destinationNode.getModelNamespace().equals(result.getModel().getNamespace())) {
                return false;
            }
            Optional importAlias = callerNode.getModelImportAliasFor(destinationNode.getModelNamespace(), destinationNode.getModelName());
            if (importAlias.isPresent()) {
                result.getContext().pushScope((String)importAlias.get(), destinationNode.getModelNamespace());
                return true;
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)callerNode).getSource(), result, null, null, Msg.IMPORT_NOT_FOUND_FOR_NODE_MISSING_ALIAS, new QName(destinationNode.getModelNamespace(), destinationNode.getModelName()), callerNode.getName());
            return false;
        }
        if (destinationNode.getModelNamespace().equals(result.getContext().scopeNamespace().get())) {
            return false;
        }
        Optional importAlias = callerNode.getModelImportAliasFor(destinationNode.getModelNamespace(), destinationNode.getModelName());
        if (importAlias.isPresent()) {
            result.getContext().pushScope((String)importAlias.get(), destinationNode.getModelNamespace());
            return true;
        }
        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)callerNode).getSource(), result, null, null, Msg.IMPORT_NOT_FOUND_FOR_NODE_MISSING_ALIAS, new QName(destinationNode.getModelNamespace(), destinationNode.getModelName()), callerNode.getName());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean evaluateDecision(DMNContext context, DMNResultImpl result, DecisionNode d, boolean typeCheck) {
        block31: {
            block30: {
                block29: {
                    decision = (DecisionNodeImpl)d;
                    v0 = decisionId = d.getModelNamespace().equals(result.getModel().getNamespace()) != false ? decision.getId() : decision.getModelNamespace() + "#" + decision.getId();
                    if (this.isNodeValueDefined(result, decision, decision)) {
                        return true;
                    }
                    status = Optional.ofNullable(result.getDecisionResultById(decisionId)).map((Function<DMNDecisionResult, DMNDecisionResult.DecisionEvaluationStatus>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getEvaluationStatus(), (Lorg/kie/dmn/api/core/DMNDecisionResult;)Lorg/kie/dmn/api/core/DMNDecisionResult$DecisionEvaluationStatus;)()).orElse(DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED);
                    if (DMNDecisionResult.DecisionEvaluationStatus.FAILED == status) return false;
                    if (DMNDecisionResult.DecisionEvaluationStatus.SKIPPED == status) return false;
                    if (DMNDecisionResult.DecisionEvaluationStatus.EVALUATING == status) {
                        return false;
                    }
                    beforeEvaluateDecisionEvent = null;
                    beforeEvaluateDecisionEvent = DMNRuntimeEventManagerUtils.fireBeforeEvaluateDecision(this.eventManager, decision, result);
                    missingInput = false;
                    dr = (DMNDecisionResultImpl)result.getDecisionResultById(decisionId);
                    if (dr == null) {
                        decisionResultName = d.getName();
                        importAliasFor = ((DMNModelImpl)result.getModel()).getImportAliasFor(d.getModelNamespace(), d.getModelName());
                        if (importAliasFor.isPresent()) {
                            decisionResultName = importAliasFor.get() + "." + d.getName();
                        }
                        dr = new DMNDecisionResultImpl(decisionId, (String)decisionResultName);
                        if (importAliasFor.isPresent()) {
                            result.addDecisionResult(dr);
                        }
                    }
                    dr.setEvaluationStatus(DMNDecisionResult.DecisionEvaluationStatus.EVALUATING);
                    for (DMNNode dep : decision.getDependencies().values()) {
                        try {
                            if (typeCheck && !this.checkDependencyValueIsValid(dep, result)) {
                                missingInput = true;
                                message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)dep).getSource(), result, null, null, Msg.ERROR_EVAL_NODE_DEP_WRONG_TYPE, DMNRuntimeImpl.getIdentifier(decision), DMNRuntimeImpl.getDependencyIdentifier(decision, dep), MsgUtil.clipString(Objects.toString(result.getContext().get(dep.getName())), 50), ((DMNBaseNode)dep).getType());
                                this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                            }
                        }
                        catch (Exception e) {
                            MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)dep).getSource(), result, e, null, Msg.ERROR_CHECKING_ALLOWED_VALUES, DMNRuntimeImpl.getDependencyIdentifier(decision, dep), e.getMessage());
                        }
                        if (this.isNodeValueDefined(result, decision, dep)) continue;
                        walkingIntoScope = this.walkIntoImportScope(result, decision, dep);
                        if (dep instanceof DecisionNode) {
                            if (!this.evaluateDecision(context, result, (DecisionNode)dep, typeCheck)) {
                                missingInput = true;
                                message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.UNABLE_TO_EVALUATE_DECISION_REQ_DEP, DMNRuntimeImpl.getIdentifier(decision), DMNRuntimeImpl.getDependencyIdentifier(decision, dep));
                                this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                            }
                        } else if (dep instanceof BusinessKnowledgeModelNode) {
                            this.evaluateBKM(context, result, (BusinessKnowledgeModelNode)dep, typeCheck);
                        } else if (dep instanceof DecisionServiceNode) {
                            this.evaluateDecisionService(context, result, (DecisionServiceNode)dep, typeCheck);
                        } else {
                            missingInput = true;
                            message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.REQ_DEP_NOT_FOUND_FOR_NODE, DMNRuntimeImpl.getDependencyIdentifier(decision, dep), DMNRuntimeImpl.getIdentifier(decision));
                            this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                        }
                        if (!walkingIntoScope) continue;
                        result.getContext().popScope();
                    }
                    if (missingInput) {
                        decisionResultName = false;
                    }
                    ** GOTO lbl-1000
                    DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result, beforeEvaluateDecisionEvent);
                    return decisionResultName;
lbl-1000:
                    // 1 sources

                    {
                        if (decision.getEvaluator() != null) break block29;
                        message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.MISSING_EXPRESSION_FOR_DECISION, DMNRuntimeImpl.getIdentifier(decision));
                        this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                        dep = false;
                    }
                    DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result, beforeEvaluateDecisionEvent);
                    return dep;
                }
                er = decision.getEvaluator().evaluate((DMNRuntimeEventManager)this, result);
                if (er.getResultType() != EvaluatorResult.ResultType.SUCCESS) ** GOTO lbl96
                value = er.getResult();
                if (!decision.getResultType().isCollection() && value instanceof Collection && ((Collection)value).size() == 1) {
                    value = ((Collection)value).toArray()[0];
                }
                try {
                    if (!typeCheck || d.getResultType().isAssignableValue(value)) break block30;
                    message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.ERROR_EVAL_NODE_RESULT_WRONG_TYPE, DMNRuntimeImpl.getIdentifier(decision), decision.getResultType(), value);
                    this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.FAILED);
                    var13_23 = false;
                }
                catch (Exception e) {
                    MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, e, null, Msg.ERROR_CHECKING_ALLOWED_VALUES, DMNRuntimeImpl.getIdentifier(decision), e.getMessage());
                    var13_24 = false;
                    DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result, beforeEvaluateDecisionEvent);
                    return var13_24;
                }
                DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result, beforeEvaluateDecisionEvent);
                return var13_23;
            }
            result.getContext().set(decision.getDecision().getVariable().getName(), value);
            dr.setResult(value);
            dr.setEvaluationStatus(DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
            break block31;
lbl96:
            // 1 sources

            dr.setEvaluationStatus(DMNDecisionResult.DecisionEvaluationStatus.FAILED);
            value = false;
            DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result, beforeEvaluateDecisionEvent);
            return value;
        }
        ** try [egrp 7[TRYBLOCK] [10 : 1054->1106)] { 
lbl102:
        // 1 sources

        return true;
        catch (Throwable t) {
            message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, t, null, Msg.ERROR_EVAL_DECISION_NODE, DMNRuntimeImpl.getIdentifier(decision), t.getMessage());
            this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.FAILED);
        }
        return true;
lbl107:
        // 1 sources

        finally {
            DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result, beforeEvaluateDecisionEvent);
        }
    }

    private boolean checkDependencyValueIsValid(DMNNode dep, DMNResultImpl result) {
        if (dep instanceof InputDataNode) {
            InputDataNodeImpl inputDataNode = (InputDataNodeImpl)dep;
            BaseDMNTypeImpl dmnType = (BaseDMNTypeImpl)inputDataNode.getType();
            return dmnType.isAssignableValue(result.getContext().get(dep.getName()));
        }
        return true;
    }

    private static String getIdentifier(DMNNode node) {
        return node.getName() != null ? node.getName() : node.getId();
    }

    private static String getDependencyIdentifier(DMNNode callerNode, DMNNode node) {
        if (node.getModelNamespace().equals(callerNode.getModelNamespace())) {
            return DMNRuntimeImpl.getIdentifier(node);
        }
        Optional importAlias = callerNode.getModelImportAliasFor(node.getModelNamespace(), node.getModelName());
        String prefix = "{" + node.getModelNamespace() + "}";
        if (importAlias.isPresent()) {
            prefix = (String)importAlias.get();
        }
        return prefix + "." + DMNRuntimeImpl.getIdentifier(node);
    }

    public boolean performRuntimeTypeCheck(DMNModel model) {
        Objects.requireNonNull(model, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "model"));
        return this.overrideRuntimeTypeCheck || ((DMNModelImpl)model).isRuntimeTypeCheck();
    }

    public final <T extends DMNOption> void setOption(T option) {
        if (option instanceof RuntimeTypeCheckOption) {
            this.overrideRuntimeTypeCheck = ((RuntimeTypeCheckOption)option).isRuntimeTypeCheck();
        }
    }

    private void reportFailure(DMNDecisionResultImpl dr, DMNMessage message, DMNDecisionResult.DecisionEvaluationStatus status) {
        dr.getMessages().add(message);
        dr.setEvaluationStatus(status);
    }

    public DMNContext newContext() {
        return DMNFactory.newContext();
    }

    public DMNRuntime getRuntime() {
        return this;
    }

    public List<DMNProfile> getProfiles() {
        ArrayList<DMNProfile> profiles = new ArrayList<DMNProfile>();
        this.knowledgeBase.getKiePackages().forEach(kpkg -> {
            DMNPackageImpl dmnPkg = (DMNPackageImpl)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.DMN);
            if (dmnPkg != null) {
                for (DMNProfile p : dmnPkg.getProfiles()) {
                    if (profiles.contains(p)) continue;
                    profiles.add(p);
                }
            }
        });
        return profiles;
    }

    public ClassLoader getRootClassLoader() {
        return this.knowledgeBase.getRootClassLoader();
    }
}

