/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.compiler.DMNTypeRegistry;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.feel.lang.Scope;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.lang.types.FEELTypeRegistry;
import org.kie.dmn.feel.lang.types.ScopeImpl;
import org.kie.dmn.feel.lang.types.TypeSymbol;
import org.kie.dmn.feel.lang.types.WrappingScopeImpl;

public abstract class DMNTypeRegistryAbstract
implements DMNTypeRegistry,
FEELTypeRegistry {
    protected Map<String, Map<String, DMNType>> types = new HashMap<String, Map<String, DMNType>>();
    protected Map<String, QName> aliases;
    protected ScopeImpl feelTypesScope = new ScopeImpl();
    protected Map<String, ScopeImpl> feelTypesScopeChildLU = new HashMap<String, ScopeImpl>();

    protected abstract String feelNS();

    public DMNTypeRegistryAbstract(Map<String, QName> aliases) {
        this.aliases = aliases;
        String feelNamespace = this.feelNS();
        HashMap<String, DMNType> feelTypes = new HashMap<String, DMNType>();
        this.types.put(feelNamespace, feelTypes);
        for (String string : BuiltInType.UNKNOWN.getNames()) {
            feelTypes.put(string, this.unknown());
            this.feelTypesScope.define((Symbol)new TypeSymbol(string, (Type)BuiltInType.UNKNOWN));
        }
        for (String string : BuiltInType.values()) {
            for (String name : string.getNames()) {
                if (string == BuiltInType.UNKNOWN) continue;
                BaseDMNTypeImpl feelPrimitiveType = string == BuiltInType.LIST ? new SimpleTypeImpl(feelNamespace, name, null, false, null, this.unknown(), (Type)string) : (string == BuiltInType.CONTEXT ? new CompositeTypeImpl(feelNamespace, name, null, false, Collections.emptyMap(), null, (Type)string) : new SimpleTypeImpl(feelNamespace, name, null, false, null, null, (Type)string));
                feelTypes.put(name, feelPrimitiveType);
                this.feelTypesScope.define((Symbol)new TypeSymbol(name, (Type)string));
            }
        }
    }

    public Scope getItemDefScope(Scope parent) {
        return new WrappingScopeImpl((Scope)this.feelTypesScope, parent);
    }

    public Type resolveFEELType(List<String> qns) {
        if (qns.size() == 1) {
            return this.feelTypesScope.resolve(qns.get(0)).getType();
        }
        if (qns.size() == 2 && this.feelTypesScopeChildLU.containsKey(qns.get(0))) {
            return this.feelTypesScopeChildLU.get(qns.get(0)).resolve(qns.get(1)).getType();
        }
        throw new IllegalStateException("Inconsistent state when resolving for qns: " + qns.toString());
    }

    protected void registerAsFEELType(DMNType dmnType) {
        Optional<String> optAliasKey = this.keyfromNS(dmnType.getNamespace());
        Type feelType = ((BaseDMNTypeImpl)dmnType).getFeelType();
        if (!optAliasKey.isPresent()) {
            this.feelTypesScope.define((Symbol)new TypeSymbol(dmnType.getName(), feelType));
        } else {
            String aliasKey = optAliasKey.get();
            this.feelTypesScopeChildLU.computeIfAbsent(aliasKey, k -> {
                ScopeImpl importScope = new ScopeImpl(k, (Scope)this.feelTypesScope);
                this.feelTypesScope.define((Symbol)new TypeSymbol(k, null));
                return importScope;
            }).define((Symbol)new TypeSymbol(dmnType.getName(), feelType));
        }
    }

    private Optional<String> keyfromNS(String ns) {
        return this.aliases == null ? Optional.empty() : this.aliases.entrySet().stream().filter(kv -> ((QName)kv.getValue()).getNamespaceURI().equals(ns)).map(kv -> (String)kv.getKey()).findFirst();
    }

    @Override
    public DMNType registerType(DMNType type) {
        if (type.getNamespace() == null && type.getName() == null) {
            throw new IllegalArgumentException("Unknown namespace or name. Unable to register type " + type);
        }
        Map<String, DMNType> typesMap = this.types.get(type.getNamespace());
        if (typesMap == null) {
            typesMap = new HashMap<String, DMNType>();
            this.types.put(type.getNamespace(), typesMap);
        }
        if (typesMap.containsKey(type.getName())) {
            return typesMap.get(type.getName());
        }
        typesMap.put(type.getName(), type);
        this.registerAsFEELType(type);
        return type;
    }

    @Override
    public DMNType resolveType(String namespace, String name) {
        Map<String, DMNType> typeMap = this.types.get(namespace);
        if (typeMap != null) {
            return typeMap.get(name);
        }
        return null;
    }
}

