/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule.constraint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.Constraint;

public class NegConstraint
implements AlphaNodeFieldConstraint {
    private Constraint.ConstraintType type = Constraint.ConstraintType.ALPHA;
    private transient AtomicBoolean inUse = new AtomicBoolean(false);
    private boolean operator;

    public NegConstraint() {
        this.operator = true;
    }

    public NegConstraint(boolean operator) {
        this.operator = operator;
    }

    @Override
    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        return !this.operator && !handle.isNegated() || this.operator && handle.isNegated();
    }

    @Override
    public AlphaNodeFieldConstraint cloneIfInUse() {
        if (this.inUse.compareAndSet(false, true)) {
            return this;
        }
        NegConstraint clone = this.clone();
        clone.inUse.set(true);
        return clone;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return new Declaration[0];
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NegConstraint clone() {
        NegConstraint negConstraint = new NegConstraint();
        negConstraint.operator = this.operator;
        return negConstraint;
    }

    @Override
    public Constraint.ConstraintType getType() {
        return this.type;
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    public boolean setInUse() {
        return this.inUse.getAndSet(true);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.operator);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.operator = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NegConstraint that = (NegConstraint)o;
        if (this.operator != that.operator) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.operator ? 1 : 0);
        return result;
    }
}

