/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.model.v1_1;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.dmn.model.v1_1.Artifact;
import org.kie.dmn.model.v1_1.BusinessContextElement;
import org.kie.dmn.model.v1_1.DRGElement;
import org.kie.dmn.model.v1_1.DecisionService;
import org.kie.dmn.model.v1_1.ElementCollection;
import org.kie.dmn.model.v1_1.Import;
import org.kie.dmn.model.v1_1.ItemDefinition;
import org.kie.dmn.model.v1_1.NamedElement;
import org.kie.dmn.model.v1_1.extensions.DecisionServices;

public class Definitions
extends NamedElement {
    public static final String DEFAULT_EXPRESSION_LANGUAGE = "http://www.omg.org/spec/FEEL/20140401";
    public static final String DEFAULT_TYPE_LANGUAGE = "http://www.omg.org/spec/FEEL/20140401";
    private List<Import> _import;
    private List<ItemDefinition> itemDefinition;
    private List<DRGElement> drgElement;
    private List<Artifact> artifact;
    private List<ElementCollection> elementCollection;
    private List<BusinessContextElement> businessContextElement;
    private List<DecisionService> decisionService;
    private String expressionLanguage;
    private String typeLanguage;
    private String namespace;
    private String exporter;
    private String exporterVersion;

    public List<Import> getImport() {
        if (this._import == null) {
            this._import = new ArrayList<Import>();
        }
        return this._import;
    }

    public List<ItemDefinition> getItemDefinition() {
        if (this.itemDefinition == null) {
            this.itemDefinition = new ArrayList<ItemDefinition>();
        }
        return this.itemDefinition;
    }

    public List<DRGElement> getDrgElement() {
        if (this.drgElement == null) {
            this.drgElement = new ArrayList<DRGElement>();
        }
        return this.drgElement;
    }

    public List<Artifact> getArtifact() {
        if (this.artifact == null) {
            this.artifact = new ArrayList<Artifact>();
        }
        return this.artifact;
    }

    public List<ElementCollection> getElementCollection() {
        if (this.elementCollection == null) {
            this.elementCollection = new ArrayList<ElementCollection>();
        }
        return this.elementCollection;
    }

    public List<BusinessContextElement> getBusinessContextElement() {
        if (this.businessContextElement == null) {
            this.businessContextElement = new ArrayList<BusinessContextElement>();
        }
        return this.businessContextElement;
    }

    public List<DecisionService> getDecisionService() {
        if (this.decisionService == null) {
            this.decisionService = new ArrayList<DecisionService>();
            if (this.getExtensionElements() != null) {
                List collectDS = this.getExtensionElements().getAny().stream().filter(DecisionServices.class::isInstance).map(DecisionServices.class::cast).flatMap(dss -> dss.getDecisionService().stream()).collect(Collectors.toList());
                this.decisionService.addAll(collectDS);
            }
        }
        return this.decisionService;
    }

    public String getExpressionLanguage() {
        if (this.expressionLanguage == null) {
            return "http://www.omg.org/spec/FEEL/20140401";
        }
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String value) {
        this.expressionLanguage = value;
    }

    public String getTypeLanguage() {
        if (this.typeLanguage == null) {
            return "http://www.omg.org/spec/FEEL/20140401";
        }
        return this.typeLanguage;
    }

    public void setTypeLanguage(String value) {
        this.typeLanguage = value;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String value) {
        this.namespace = value;
    }

    public String getExporter() {
        return this.exporter;
    }

    public void setExporter(String value) {
        this.exporter = value;
    }

    public String getExporterVersion() {
        return this.exporterVersion;
    }

    public void setExporterVersion(String value) {
        this.exporterVersion = value;
    }

    public String toString() {
        return "Definitions{_import=" + this._import + ", itemDefinition=" + this.itemDefinition + ", drgElement=" + this.drgElement + ", decisionService=" + this.decisionService + ", artifact=" + this.artifact + ", elementCollection=" + this.elementCollection + ", businessContextElement=" + this.businessContextElement + ", expressionLanguage='" + this.expressionLanguage + '\'' + ", typeLanguage='" + this.typeLanguage + '\'' + ", namespace='" + this.namespace + '\'' + ", exporter='" + this.exporter + '\'' + ", exporterVersion='" + this.exporterVersion + '\'' + '}';
    }

    public static void normalize(Definitions defs) {
        for (ItemDefinition itemDefinition : defs.getItemDefinition()) {
            Definitions.processQNameURIs(itemDefinition);
        }
    }

    private static void processQNameURIs(ItemDefinition iDef) {
        QName typeRef = iDef.getTypeRef();
        if (typeRef != null && "".equals(typeRef.getNamespaceURI())) {
            String namespace = iDef.getNamespaceURI(typeRef.getPrefix());
            iDef.setTypeRef(new QName(namespace, typeRef.getLocalPart(), typeRef.getPrefix()));
        }
        for (ItemDefinition comp : iDef.getItemComponent()) {
            Definitions.processQNameURIs(comp);
        }
    }
}

