/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.timer;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.marshalling.impl.InputMarshaller;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.OutputMarshaller;
import org.drools.marshalling.impl.TimersInputMarshaller;
import org.drools.marshalling.impl.TimersOutputMarshaller;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.Trigger;
import org.drools.time.impl.IntervalTrigger;
import org.jbpm.marshalling.impl.ProcessMarshallerImpl;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.timer.TimerInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerManager {
    private long timerId = 0L;
    private InternalKnowledgeRuntime kruntime;
    private TimerService timerService;
    private Map<Long, TimerInstance> timers = new ConcurrentHashMap<Long, TimerInstance>();
    public static final Job processJob = new ProcessJob();

    public TimerManager(InternalKnowledgeRuntime kruntime, TimerService timerService) {
        this.kruntime = kruntime;
        this.timerService = timerService;
    }

    public void registerTimer(TimerInstance timer, ProcessInstance processInstance) {
        timer.setId(++this.timerId);
        timer.setProcessInstanceId(processInstance.getId());
        timer.setActivated(new Date());
        IntervalTrigger trigger = new IntervalTrigger(this.timerService.getCurrentTime(), null, null, -1, timer.getDelay(), timer.getPeriod(), null, null);
        ProcessJobContext ctx = new ProcessJobContext(timer, (Trigger)trigger, processInstance.getId(), this.kruntime);
        JobHandle jobHandle = this.timerService.scheduleJob(processJob, (JobContext)ctx, (Trigger)trigger);
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    public void internalAddTimer(TimerInstance timer) {
        long delay;
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered == null) {
            Date activated = timer.getActivated();
            Date now = new Date();
            long timespan = now.getTime() - activated.getTime();
            delay = timer.getDelay() - timespan;
            if (delay < 0L) {
                delay = 0L;
            }
        } else {
            Date now = new Date();
            long timespan = now.getTime() - lastTriggered.getTime();
            delay = timespan - timer.getPeriod();
            if (delay < 0L) {
                delay = 0L;
            }
        }
        IntervalTrigger trigger = new IntervalTrigger(this.timerService.getCurrentTime(), null, null, -1, delay, timer.getPeriod(), null, null);
        ProcessJobContext ctx = new ProcessJobContext(timer, (Trigger)trigger, timer.getProcessInstanceId(), this.kruntime);
        JobHandle jobHandle = this.timerService.scheduleJob(processJob, (JobContext)ctx, (Trigger)trigger);
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    public void cancelTimer(long timerId) {
        TimerInstance timer = this.timers.remove(timerId);
        if (timer != null) {
            this.timerService.removeJob(timer.getJobHandle());
        }
    }

    public void dispose() {
        boolean i = false;
        Iterator<TimerInstance> it = this.timers.values().iterator();
        while (it.hasNext()) {
            TimerInstance timer = it.next();
            this.timerService.removeJob(timer.getJobHandle());
            it.remove();
        }
        this.timerService.shutdown();
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public Collection<TimerInstance> getTimers() {
        return this.timers.values();
    }

    public Map<Long, TimerInstance> getTimerMap() {
        return this.timers;
    }

    public long internalGetTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void setTimerService(TimerService timerService) {
        this.timerService = timerService;
    }

    public static class ProcessJobContext
    implements JobContext {
        private Long processInstanceId;
        private InternalKnowledgeRuntime kruntime;
        private TimerInstance timer;
        private Trigger trigger;
        private JobHandle jobHandle;

        public ProcessJobContext(TimerInstance timer, Trigger trigger, Long processInstanceId, InternalKnowledgeRuntime kruntime) {
            this.timer = timer;
            this.trigger = trigger;
            this.processInstanceId = processInstanceId;
            this.kruntime = kruntime;
        }

        public Long getProcessInstanceId() {
            return this.processInstanceId;
        }

        public InternalKnowledgeRuntime getKnowledgeRuntime() {
            return this.kruntime;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public TimerInstance getTimer() {
            return this.timer;
        }
    }

    public static class ProcessJob
    implements Job {
        public void execute(JobContext c) {
            ProcessJobContext ctx = (ProcessJobContext)c;
            Long processInstanceId = ctx.getProcessInstanceId();
            InternalKnowledgeRuntime kruntime = ctx.getKnowledgeRuntime();
            if (processInstanceId == null) {
                throw new IllegalArgumentException("Could not find process instance for timer ");
            }
            ctx.getTimer().setLastTriggered(new Date(ctx.getKnowledgeRuntime().getSessionClock().getCurrentTime()));
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getSignalManager().signalEvent(processInstanceId, "timerTriggered", ctx.getTimer());
            TimerManager tm = ((InternalProcessRuntime)ctx.getKnowledgeRuntime().getProcessRuntime()).getTimerManager();
            if (ctx.getTimer().getPeriod() == 0L) {
                tm.getTimerMap().remove(ctx.getTimer().getId());
            }
        }
    }

    public static class ProcessTimerInputMarshaller
    implements TimersInputMarshaller {
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            TimerService ts = inCtx.wm.getTimerService();
            long processInstanceId = inCtx.readLong();
            Trigger trigger = InputMarshaller.readTrigger((MarshallerReaderContext)inCtx);
            TimerInstance timerInstance = ProcessMarshallerImpl.readTimer(inCtx);
            ProcessJobContext pctx = new ProcessJobContext(timerInstance, trigger, processInstanceId, inCtx.wm.getKnowledgeRuntime());
            JobHandle jobHandle = ts.scheduleJob(processJob, (JobContext)pctx, trigger);
            timerInstance.setJobHandle(jobHandle);
            pctx.setJobHandle(jobHandle);
            TimerManager tm = ((InternalProcessRuntime)inCtx.wm.getProcessRuntime()).getTimerManager();
            tm.getTimerMap().put(timerInstance.getId(), timerInstance);
        }
    }

    public static class ProcessTimerOutputMarshaller
    implements TimersOutputMarshaller {
        public void write(JobContext ctx, MarshallerWriteContext outCtx) throws IOException {
            outCtx.writeShort(52);
            ProcessJobContext pctx = (ProcessJobContext)ctx;
            outCtx.writeLong(pctx.getProcessInstanceId().longValue());
            OutputMarshaller.writeTrigger((Trigger)pctx.getTrigger(), (MarshallerWriteContext)outCtx);
            ProcessMarshallerImpl.writeTimer(outCtx, pctx.getTimer());
        }
    }
}

