/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.ObjectWrapper;
import org.drools.eclipse.debug.VariableWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ILogicalStructureTypeDelegate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class AgendaLogicalStructureDelegate
implements ILogicalStructureTypeDelegate {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean providesLogicalStructure(IValue value) {
        if (!(value instanceof IJavaObject)) {
            return false;
        }
        IJavaObject javaValue = (IJavaObject)value;
        try {
            IJavaType type = javaValue.getJavaType();
            if (!(type instanceof IJavaClassType)) {
                return false;
            }
            IJavaClassType classType = (IJavaClassType)type;
            IJavaInterfaceType[] interfaceTypes = classType.getAllInterfaces();
            int i = 0;
            while (true) {
                if (i >= interfaceTypes.length) {
                    return false;
                }
                if ("org.drools.spi.Activation".equals(interfaceTypes[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (DebugException e) {
            DroolsEclipsePlugin.log(e);
            return false;
        }
    }

    public IValue getLogicalStructure(IValue value) throws CoreException {
        if (!(value instanceof IJavaObject)) {
            return null;
        }
        IJavaObject javaValue = (IJavaObject)value;
        if (!this.providesLogicalStructure(value)) {
            return null;
        }
        IJavaArray ruleParameters = (IJavaArray)DebugUtil.getValueByExpression("return getRule().getDeclarations();", value);
        ArrayList<VariableWrapper> variables = new ArrayList<VariableWrapper>();
        variables.add(new VariableWrapper("ruleName", (IJavaValue)DebugUtil.getValueByExpression("return getRule().getName();", value)));
        IJavaValue[] javaValues = ruleParameters.getValues();
        int j = 0;
        while (j < javaValues.length) {
            IJavaValue declaration = javaValues[j];
            IVariable[] vars = declaration.getVariables();
            int k = 0;
            while (k < vars.length) {
                IVariable declarationVar = vars[k];
                if ("identifier".equals(declarationVar.getName())) {
                    String paramName = declarationVar.getValue().getValueString();
                    IJavaValue varValue = (IJavaValue)DebugUtil.getValueByExpression("return getRule().getDeclaration(\"" + paramName + "\").getValue(((org.drools.common.InternalFactHandle) getTuple().get(getRule().getDeclaration(\"" + paramName + "\"))).getObject());", value);
                    if (varValue == null) break;
                    variables.add(new VariableWrapper(paramName, varValue));
                    break;
                }
                ++k;
            }
            ++j;
        }
        return new ObjectWrapper(javaValue, variables.toArray(new IJavaVariable[variables.size()]));
    }
}

