/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.editor.editpart;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.figure.AbstractElementFigure;
import org.drools.eclipse.flow.ruleflow.core.JoinWrapper;
import org.drools.eclipse.flow.ruleflow.skin.SkinManager;
import org.drools.eclipse.flow.ruleflow.skin.SkinProvider;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class JoinEditPart
extends ElementEditPart {
    private String SKIN = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Flow.Skin");
    private static final Color color = new Color((Device)Display.getCurrent(), 70, 130, 180);

    protected IFigure createFigure() {
        SkinProvider skinProvider = SkinManager.getInstance().getSkinProvider(this.SKIN);
        JoinFigureInterface result = skinProvider.createJoinFigure();
        Rectangle constraint = this.getElementWrapper().getConstraint();
        if (constraint.width == -1) {
            constraint.width = result.getSize().width;
        }
        if (constraint.height == -1) {
            constraint.height = result.getSize().height;
        }
        this.getElementWrapper().setConstraint(constraint);
        return result;
    }

    public void modelChanged(ModelEvent event) {
        if (event.getChange() == 5) {
            this.refreshVisuals();
        } else {
            super.modelChanged(event);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        int type = ((JoinWrapper)this.getModel()).getJoin().getType();
        ((JoinFigureInterface)this.getFigure()).setType(type);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new EllipseAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new EllipseAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new EllipseAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new EllipseAnchor(this.getFigure());
    }

    public static class JoinFigure
    extends AbstractElementFigure
    implements JoinFigureInterface {
        private Ellipse ellipse;

        protected void customizeFigure() {
            this.ellipse = new Ellipse();
            this.add((IFigure)this.ellipse, 0);
            this.ellipse.setBackgroundColor(color);
            this.ellipse.setBounds(this.getBounds());
        }

        public void setBounds(Rectangle rectangle) {
            super.setBounds(rectangle);
            this.ellipse.setBounds(rectangle);
        }

        public void setSelected(boolean b) {
            super.setSelected(b);
            this.ellipse.setLineWidth(b ? 3 : 1);
            this.repaint();
        }

        public void setType(int type) {
        }
    }

    public static interface JoinFigureInterface
    extends IFigure {
        public void setType(int var1);
    }
}

