/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.rule;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class DRLGenerator {
    private static final Pattern packageDec = Pattern.compile("\\$package\\$");
    private static final Pattern dateDec = Pattern.compile("\\$date\\$");
    private static final Pattern functionsDec = Pattern.compile("\\$functions\\$");
    private static final Pattern expanderDec = Pattern.compile("\\$expander\\$");

    public InputStream generateRule(String packageName, InputStream template) throws IOException {
        String temp = this.readTemplate(template);
        temp = this.doHeader(packageName, temp);
        return this.toStream(temp);
    }

    public InputStream generatePackage(String packageName, boolean functions, boolean expander, InputStream template) throws IOException {
        String temp = this.readTemplate(template);
        temp = this.doHeader(packageName, temp);
        temp = functions ? functionsDec.matcher(temp).replaceFirst("function myFunction( ... ) {" + System.getProperty("line.separator") + "    #function content (can have multiple functions) " + System.getProperty("line.separator") + "}" + System.getProperty("line.separator")) : functionsDec.matcher(temp).replaceFirst("");
        temp = expander ? expanderDec.matcher(temp).replaceFirst("expander customLanguage.dsl" + System.getProperty("line.separator")) : expanderDec.matcher(temp).replaceFirst("");
        return this.toStream(temp);
    }

    private ByteArrayInputStream toStream(String temp) throws UnsupportedEncodingException {
        ByteArrayInputStream stream = new ByteArrayInputStream(temp.getBytes("UTF-8"));
        return stream;
    }

    private String doHeader(String packageName, String temp) {
        temp = packageDec.matcher(temp).replaceFirst("package " + packageName + System.getProperty("line.separator"));
        temp = dateDec.matcher(temp).replaceFirst(DateFormat.getDateInstance().format(new Date()));
        return temp;
    }

    private String readTemplate(InputStream template) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(template));
        String line = null;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buf.append(String.valueOf(line) + System.getProperty("line.separator"));
        }
        String temp = buf.toString();
        return temp;
    }
}

