/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.WorkingMemoryAction;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.RightTupleKey;
import org.drools.marshalling.impl.TimersInputMarshaller;
import org.drools.marshalling.impl.TimersOutputMarshaller;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;
import org.drools.rule.Behavior;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.impl.PointInTimeTrigger;

public class SlidingTimeWindow
implements Externalizable,
Behavior {
    private long size;
    public static final BehaviorJob job = new BehaviorJob();

    public SlidingTimeWindow() {
        this(0L);
    }

    public SlidingTimeWindow(long size) {
        this.size = size;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.size);
    }

    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.TIME_WINDOW;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Object createContext() {
        return new SlidingTimeWindowContext();
    }

    public boolean assertRightTuple(Object context, RightTuple rightTuple, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        queue.queue.add(rightTuple);
        if (queue.queue.peek() == rightTuple) {
            SlidingTimeWindow.updateNextExpiration(rightTuple, workingMemory, this, queue);
        }
        return true;
    }

    public void retractRightTuple(Object context, RightTuple rightTuple, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        if (queue.expiringTuple != rightTuple) {
            if (queue.queue.peek() == rightTuple) {
                queue.queue.poll();
                SlidingTimeWindow.updateNextExpiration(queue.queue.peek(), workingMemory, this, queue);
            } else {
                queue.queue.remove(rightTuple);
            }
        }
    }

    public void expireTuples(Object context, InternalWorkingMemory workingMemory) {
        TimerService clock = workingMemory.getTimerService();
        long currentTime = clock.getCurrentTime();
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        RightTuple tuple = queue.queue.peek();
        while (tuple != null && this.isExpired(currentTime, tuple)) {
            queue.expiringTuple = tuple;
            queue.queue.remove();
            InternalFactHandle handle = tuple.getFactHandle();
            if (handle.isValid()) {
                PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 5, null, null, handle);
                tuple.getRightTupleSink().retractRightTuple(tuple, propagationContext, workingMemory);
                propagationContext.evaluateActionQueue(workingMemory);
            }
            tuple.unlinkFromRightParent();
            queue.expiringTuple = null;
            tuple = queue.queue.peek();
        }
        SlidingTimeWindow.updateNextExpiration(tuple, workingMemory, this, queue);
    }

    private boolean isExpired(long currentTime, RightTuple rightTuple) {
        return ((EventFactHandle)rightTuple.getFactHandle()).getStartTimestamp() + this.size <= currentTime;
    }

    private static void updateNextExpiration(RightTuple rightTuple, InternalWorkingMemory workingMemory, SlidingTimeWindow stw, Object context) {
        TimerService clock = workingMemory.getTimerService();
        if (rightTuple != null) {
            long nextTimestamp = ((EventFactHandle)rightTuple.getFactHandle()).getStartTimestamp() + stw.getSize();
            BehaviorJobContext jobctx = new BehaviorJobContext(workingMemory, stw, context);
            JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
            jobctx.setJobHandle(handle);
        }
    }

    public long getExpirationOffset() {
        return this.size;
    }

    public String toString() {
        return "SlidingTimeWindow( size=" + this.size + " )";
    }

    public static class BehaviorExpireWMAction
    implements WorkingMemoryAction {
        private final Behavior behavior;
        private final Object context;

        public BehaviorExpireWMAction(Behavior behavior, Object context) {
            this.behavior = behavior;
            this.context = context;
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.behavior.expireTuples(this.context, workingMemory);
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }

        public void write(MarshallerWriteContext context) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class BehaviorJob
    implements Job {
        public void execute(JobContext ctx) {
            BehaviorJobContext context = (BehaviorJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(new BehaviorExpireWMAction(context.behavior, context.behaviorContext));
        }
    }

    public static class BehaviorJobContext
    implements JobContext,
    Externalizable {
        public InternalWorkingMemory workingMemory;
        public Behavior behavior;
        public Object behaviorContext;
        public JobHandle handle;

        public BehaviorJobContext(InternalWorkingMemory workingMemory, Behavior behavior, Object behaviorContext) {
            this.workingMemory = workingMemory;
            this.behavior = behavior;
            this.behaviorContext = behaviorContext;
        }

        public JobHandle getJobHandle() {
            return this.handle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class BehaviorJobContextTimerInputMarshaller
    implements TimersInputMarshaller {
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            SlidingTimeWindow beh = (SlidingTimeWindow)inCtx.readObject();
            SlidingTimeWindowContext slCtx = new SlidingTimeWindowContext();
            if (inCtx.readBoolean()) {
                if (inCtx.readBoolean()) {
                    int sinkId = inCtx.readInt();
                    int factHandleId = inCtx.readInt();
                    RightTupleSink sink = (RightTupleSink)((Object)inCtx.sinks.get(sinkId));
                    RightTupleKey key = new RightTupleKey(factHandleId, sink);
                    slCtx.expiringTuple = inCtx.rightTuples.get(key);
                }
                if (inCtx.readBoolean()) {
                    int size = inCtx.readInt();
                    for (int i = 0; i < size; ++i) {
                        int sinkId = inCtx.readInt();
                        int factHandleId = inCtx.readInt();
                        RightTupleSink sink = (RightTupleSink)((Object)inCtx.sinks.get(sinkId));
                        RightTupleKey key = new RightTupleKey(factHandleId, sink);
                        slCtx.queue.add(inCtx.rightTuples.get(key));
                    }
                }
                if (slCtx.queue.peek() != null) {
                    SlidingTimeWindow.updateNextExpiration(slCtx.queue.peek(), inCtx.wm, beh, slCtx);
                }
            }
        }
    }

    public static class BehaviorJobContextTimerOutputMarshaller
    implements TimersOutputMarshaller {
        public void write(JobContext jobCtx, MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(50);
            BehaviorJobContext bjobCtx = (BehaviorJobContext)jobCtx;
            outputCtx.writeObject(bjobCtx.behavior);
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)bjobCtx.behaviorContext;
            if (slCtx.expiringTuple != null) {
                outputCtx.writeBoolean(true);
                if (slCtx.expiringTuple != null) {
                    outputCtx.writeBoolean(true);
                    outputCtx.writeInt(slCtx.expiringTuple.getRightTupleSink().getId());
                    outputCtx.writeInt(slCtx.expiringTuple.getFactHandle().getId());
                } else {
                    outputCtx.writeBoolean(false);
                }
                if (slCtx.getQueue() != null) {
                    outputCtx.writeBoolean(true);
                    outputCtx.writeInt(slCtx.getQueue().size());
                    for (RightTuple rightTuple : slCtx.getQueue()) {
                        outputCtx.writeInt(rightTuple.getRightTupleSink().getId());
                        outputCtx.writeInt(rightTuple.getFactHandle().getId());
                    }
                } else {
                    outputCtx.writeBoolean(false);
                }
            } else {
                outputCtx.writeBoolean(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SlidingTimeWindowContext
    implements Externalizable {
        public PriorityQueue<RightTuple> queue = new PriorityQueue<RightTuple>(16, new SlidingTimeWindowComparator());
        public RightTuple expiringTuple;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.queue = (PriorityQueue)in.readObject();
            this.expiringTuple = (RightTuple)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.queue);
            out.writeObject(this.expiringTuple);
        }

        public PriorityQueue<RightTuple> getQueue() {
            return this.queue;
        }

        public void setQueue(PriorityQueue<RightTuple> queue) {
            this.queue = queue;
        }

        public RightTuple getExpiringTuple() {
            return this.expiringTuple;
        }

        public void setExpiringTuple(RightTuple expiringTuple) {
            this.expiringTuple = expiringTuple;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SlidingTimeWindowComparator
    implements Comparator<RightTuple> {
        private SlidingTimeWindowComparator() {
        }

        @Override
        public int compare(RightTuple t1, RightTuple t2) {
            EventFactHandle e1 = (EventFactHandle)t1.getFactHandle();
            EventFactHandle e2 = (EventFactHandle)t2.getFactHandle();
            return e1.getStartTimestamp() < e2.getStartTimestamp() ? -1 : (e1.getStartTimestamp() == e2.getStartTimestamp() ? 0 : 1);
        }
    }
}

