/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Element;

public class BaselineControl
extends ElementEditor {
    protected static final String[] childNames = new String[]{"href"};

    public BaselineControl(Element root) throws MalformedElementException {
        super(root, "baseline-control");
    }

    public String getHref() throws MalformedElementException {
        String href = ElementEditor.getChildText(this.root, "href", true);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), href);
        return ElementEditor.decodeHref(href);
    }

    public void setHref(String href) {
        Assert.isNotNull(href);
        ElementEditor.setChild(this.root, "href", ElementEditor.encodeHref(href), childNames, true);
    }
}

