/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DroolsError;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRLInfo {
    private static final DroolsError[] EMPTY_DROOLS_ERROR_ARRAY = new DroolsError[0];
    private static final List<DroolsError> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private String sourcePathName;
    private PackageDescr packageDescr;
    private List<DroolsError> parserErrors;
    private Package compiledPackage;
    private DroolsError[] builderErrors;
    private transient RuleInfo[] ruleInfos;
    private transient FunctionInfo[] functionInfos;
    private DialectCompiletimeRegistry dialectRegistry;

    public DRLInfo(String sourcePathName, PackageDescr packageDescr, List<DroolsError> parserErrors, DialectCompiletimeRegistry dialectRegistry) {
        if (sourcePathName == null) {
            throw new IllegalArgumentException("Invalid sourcePathName " + sourcePathName);
        }
        this.sourcePathName = sourcePathName;
        this.packageDescr = packageDescr;
        this.parserErrors = parserErrors == null ? EMPTY_LIST : Collections.unmodifiableList(parserErrors);
        this.builderErrors = EMPTY_DROOLS_ERROR_ARRAY;
        this.dialectRegistry = dialectRegistry;
    }

    public DRLInfo(String pathName, PackageDescr packageDescr, List<DroolsError> parserErrors, Package compiledPackage, DroolsError[] builderErrors, DialectCompiletimeRegistry dialectRegistry) {
        this(pathName, packageDescr, parserErrors, dialectRegistry);
        if (compiledPackage == null) {
            throw new IllegalArgumentException("Null package");
        }
        this.compiledPackage = compiledPackage;
        this.builderErrors = builderErrors == null ? EMPTY_DROOLS_ERROR_ARRAY : builderErrors;
    }

    public String getSourcePathName() {
        return this.sourcePathName;
    }

    public PackageDescr getPackageDescr() {
        return this.packageDescr;
    }

    public List<DroolsError> getParserErrors() {
        return this.parserErrors;
    }

    public Package getPackage() {
        return this.compiledPackage;
    }

    public DroolsError[] getBuilderErrors() {
        return this.builderErrors;
    }

    public String getPackageName() {
        return this.packageDescr == null ? null : this.packageDescr.getName();
    }

    public boolean isCompiled() {
        return this.compiledPackage != null;
    }

    public RuleInfo[] getRuleInfos() {
        if (this.ruleInfos == null) {
            ArrayList<RuleInfo> ruleInfosList = new ArrayList<RuleInfo>();
            if (this.packageDescr != null) {
                for (RuleDescr ruleDescr : this.packageDescr.getRules()) {
                    RuleInfo ruleInfo = new RuleInfo(ruleDescr);
                    ruleInfosList.add(ruleInfo);
                }
            }
            this.ruleInfos = ruleInfosList.toArray(new RuleInfo[0]);
        }
        return this.ruleInfos;
    }

    public RuleInfo getRuleInfo(int drlLineNumber) {
        RuleInfo[] ruleInfos = this.getRuleInfos();
        int ruleLine = -1;
        RuleInfo result = null;
        int i = 0;
        while (i < ruleInfos.length) {
            int ruleDrlLineNumber = ruleInfos[i].getDrlLineNumber();
            if (ruleDrlLineNumber > ruleLine && ruleDrlLineNumber <= drlLineNumber + 1) {
                ruleLine = ruleDrlLineNumber;
                result = ruleInfos[i];
            }
            ++i;
        }
        return result;
    }

    public DialectCompiletimeRegistry getDialectRegistry() {
        return this.dialectRegistry;
    }

    public FunctionInfo[] getFunctionInfos() {
        if (this.functionInfos == null) {
            ArrayList<FunctionInfo> functionInfosList = new ArrayList<FunctionInfo>();
            if (this.packageDescr != null) {
                for (FunctionDescr functionDescr : this.packageDescr.getFunctions()) {
                    FunctionInfo functionInfo = new FunctionInfo(functionDescr);
                    functionInfosList.add(functionInfo);
                }
            }
            this.functionInfos = functionInfosList.toArray(new FunctionInfo[0]);
        }
        return this.functionInfos;
    }

    public FunctionInfo getFunctionInfo(int drlLineNumber) {
        FunctionInfo[] functionInfos = this.getFunctionInfos();
        int functionLine = -1;
        FunctionInfo result = null;
        int i = 0;
        while (i < functionInfos.length) {
            int functionDrlLineNumber = functionInfos[i].getDrlLineNumber();
            if (functionDrlLineNumber > functionLine && functionDrlLineNumber <= drlLineNumber + 1) {
                functionLine = functionDrlLineNumber;
                result = functionInfos[i];
            }
            ++i;
        }
        return result;
    }

    public class FunctionInfo {
        private FunctionDescr functionDescr;
        private transient String className;
        private transient int javaLineNumber = -1;

        public FunctionInfo(FunctionDescr functionDescr) {
            if (functionDescr == null) {
                throw new IllegalArgumentException("Null functionDescr");
            }
            this.functionDescr = functionDescr;
        }

        public String getSourcePathName() {
            return DRLInfo.this.getSourcePathName();
        }

        public String getClassName() {
            if (!DRLInfo.this.isCompiled()) {
                throw new IllegalArgumentException("Package has not been compiled");
            }
            if (this.className == null) {
                this.className = this.functionDescr.getClassName();
            }
            return this.className;
        }

        public int getDrlLineNumber() {
            return this.functionDescr.getLine();
        }

        public int getJavaLineNumber() {
            if (this.javaLineNumber == -1) {
                if (!DRLInfo.this.isCompiled()) {
                    throw new IllegalArgumentException("Package has not been compiled");
                }
                this.javaLineNumber = DRLInfo.this.compiledPackage.getDialectRuntimeRegistry().getLineMappings(this.className).getOffset();
            }
            return this.javaLineNumber;
        }

        public String getPackageName() {
            return DRLInfo.this.packageDescr == null ? null : DRLInfo.this.packageDescr.getName();
        }

        public String getFunctionName() {
            return this.functionDescr.getName();
        }
    }

    public class RuleInfo {
        private final RuleDescr ruleDescr;
        private transient String className;
        private transient int consequenceJavaLineNumber = -1;

        public RuleInfo(RuleDescr ruleDescr) {
            if (ruleDescr == null) {
                throw new IllegalArgumentException("Null ruleDescr");
            }
            this.ruleDescr = ruleDescr;
        }

        public String getDialectName() {
            String dialectName = null;
            dialectName = ((AttributeDescr)this.ruleDescr.getAttributes().get("dialect")).getValue();
            if (dialectName == null && DRLInfo.this.packageDescr != null) {
                for (AttributeDescr attribute : DRLInfo.this.packageDescr.getAttributes()) {
                    if (!"dialect".equals(attribute.getName())) continue;
                    dialectName = attribute.getValue();
                    break;
                }
            }
            return dialectName;
        }

        public Dialect getDialect() {
            String dialectName = this.getDialectName();
            if (dialectName == null) {
                return null;
            }
            return DRLInfo.this.dialectRegistry.getDialect(dialectName);
        }

        public String getSourcePathName() {
            return DRLInfo.this.getSourcePathName();
        }

        public String getClassName() {
            if (!DRLInfo.this.isCompiled()) {
                throw new IllegalArgumentException("Package has not been compiled");
            }
            if (this.className == null) {
                String packageName = this.getPackageName();
                this.className = String.valueOf(packageName == null ? "" : String.valueOf(packageName) + ".") + this.ruleDescr.getClassName();
            }
            return this.className;
        }

        public int getDrlLineNumber() {
            return this.ruleDescr.getLine();
        }

        public int getConsequenceDrlLineNumber() {
            return this.ruleDescr.getConsequenceLine();
        }

        public int getConsequenceJavaLineNumber() {
            if (this.consequenceJavaLineNumber == -1) {
                if (!DRLInfo.this.isCompiled()) {
                    throw new IllegalArgumentException("Package has not been compiled");
                }
                DialectRuntimeRegistry datas = DRLInfo.this.compiledPackage.getDialectRuntimeRegistry();
                LineMappings mappings = datas.getLineMappings(this.className);
                this.consequenceJavaLineNumber = mappings.getOffset();
            }
            return this.consequenceJavaLineNumber;
        }

        public String getPackageName() {
            return DRLInfo.this.packageDescr == null ? null : DRLInfo.this.packageDescr.getName();
        }

        public String getRuleName() {
            return this.ruleDescr.getName();
        }
    }
}

