/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;

public final class DescrUtil {
    private DescrUtil() {
    }

    public static BaseDescr getDescr(BaseDescr descr, int offset) {
        if (descr instanceof PackageDescr) {
            BaseDescr result;
            PackageDescr packageDescr = (PackageDescr)descr;
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                if (ruleDescr == null || (result = DescrUtil.getDescr((BaseDescr)ruleDescr, offset)) == null) continue;
                return result;
            }
            for (ImportDescr importDescr : packageDescr.getImports()) {
                if (importDescr == null || (result = DescrUtil.getDescr((BaseDescr)importDescr, offset)) == null) continue;
                return result;
            }
            for (FunctionImportDescr functionImportDescr : packageDescr.getFunctionImports()) {
                if (functionImportDescr == null || (result = DescrUtil.getDescr((BaseDescr)functionImportDescr, offset)) == null) continue;
                return result;
            }
            for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
                if (functionDescr == null || (result = DescrUtil.getDescr((BaseDescr)functionDescr, offset)) == null) continue;
                return result;
            }
            for (AttributeDescr attributeDescr : packageDescr.getAttributes()) {
                if (attributeDescr == null || (result = DescrUtil.getDescr((BaseDescr)attributeDescr, offset)) == null) continue;
                return result;
            }
            for (GlobalDescr globalDescr : packageDescr.getGlobals()) {
                if (globalDescr == null || (result = DescrUtil.getDescr((BaseDescr)globalDescr, offset)) == null) continue;
                return result;
            }
            return null;
        }
        if (offset < descr.getStartCharacter() || offset > descr.getEndCharacter()) {
            return null;
        }
        if (descr instanceof RuleDescr) {
            RuleDescr ruleDescr = (RuleDescr)descr;
            for (AttributeDescr attributeDescr : ruleDescr.getAttributes().values()) {
                BaseDescr result;
                if (attributeDescr == null || (result = DescrUtil.getDescr((BaseDescr)attributeDescr, offset)) == null) continue;
                return result;
            }
        }
        return descr;
    }
}

