/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import org.drools.eclipse.flow.common.view.datatype.editor.Editor;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.IntegerDataType;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IntegerEditor
extends Composite
implements Editor {
    private Text text;

    public IntegerEditor(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.text = new Text((Composite)this, 0);
    }

    public void setDataType(DataType dataType) {
        if (!(dataType instanceof IntegerDataType)) {
            throw new IllegalArgumentException("Illegal data type " + dataType);
        }
    }

    public Object getValue() {
        String valueString = this.text.getText();
        if ("".equals(valueString)) {
            return null;
        }
        try {
            return new Integer(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The value " + valueString + " is not a valid integer.");
        }
    }

    public void setValue(Object value) {
        if (value == null) {
            this.text.setText("");
        } else if (value instanceof Integer) {
            this.text.setText(((Integer)value).toString());
        } else {
            throw new IllegalArgumentException("Value must be an integer: " + value);
        }
    }

    public void reset() {
        this.text.setText("");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }
}

