/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.property;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.common.view.property.MapItemDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditMapDialog<S, T>
extends EditBeanDialog<Map<S, T>> {
    private Class<? extends EditBeanDialog<T>> editItemDialogClass;
    private Map<S, T> newMap;
    private ListViewer listViewer;
    private Button removeButton;
    private Button editButton;

    protected EditMapDialog(Shell parentShell, String title, Class<? extends EditBeanDialog<T>> editItemDialogClass) {
        super(parentShell, title);
        this.editItemDialogClass = editItemDialogClass;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.listViewer = new ListViewer(composite, 4);
        this.listViewer.add(this.newMap.keySet().toArray());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditMapDialog.this.removeButton.setEnabled(!event.getSelection().isEmpty());
                EditMapDialog.this.editButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        this.listViewer.getList().setLayoutData((Object)gridData);
        Button addButton = new Button(composite, 0);
        addButton.setText("Add");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        addButton.setLayoutData((Object)gridData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMapDialog.this.addItem();
            }
        });
        this.removeButton = new Button(composite, 0);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMapDialog.this.removeItem();
            }
        });
        this.editButton = new Button(composite, 0);
        this.editButton.setText("Edit");
        this.editButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMapDialog.this.editItem();
            }
        });
        return composite;
    }

    @Override
    public void setValue(Map<S, T> value) {
        super.setValue(value);
        this.newMap = value == null ? new HashMap<S, T>() : new HashMap<S, T>(value);
    }

    @Override
    protected Map<S, T> updateValue(Map<S, T> value) {
        return this.newMap;
    }

    private void addItem() {
        T object;
        EditBeanDialog<T> dialog = this.createEditItemDialog();
        dialog.setValue(this.createItem());
        int code = dialog.open();
        Object key = ((MapItemDialog)((Object)dialog)).getKey();
        T result = dialog.getValue();
        if (code != 1 && (object = this.newMap.put(key, result)) == null) {
            this.listViewer.add(key);
        }
    }

    protected abstract T createItem();

    private void editItem() {
        EditBeanDialog<T> dialog = this.createEditItemDialog();
        Iterator iterator = ((StructuredSelection)this.listViewer.getSelection()).iterator();
        if (iterator.hasNext()) {
            Object key = iterator.next();
            ((MapItemDialog)((Object)dialog)).setKey(key);
            dialog.setValue(this.newMap.get(key));
            int code = dialog.open();
            T result = dialog.getValue();
            if (code != 1) {
                this.newMap.put(key, result);
            }
        }
    }

    private void removeItem() {
        Iterator iterator = ((StructuredSelection)this.listViewer.getSelection()).iterator();
        if (iterator.hasNext()) {
            Object key = iterator.next();
            this.newMap.remove(key);
            this.listViewer.remove(key);
        }
    }

    protected EditBeanDialog<T> createEditItemDialog() {
        try {
            return this.editItemDialogClass.getConstructor(Shell.class).newInstance(this.getShell());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

