/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddNewFieldConstraintDialog
extends RuleDialog {
    private final FormToolkit toolkit;
    private RuleModeller modeller;
    private FactPattern pattern;
    private boolean isNested;

    public AddNewFieldConstraintDialog(Shell parent, FormToolkit toolkit, RuleModeller modeller, FactPattern pattern, boolean isNested) {
        super(parent, "Update constraints", "Pick the values from combos and confirm the selection.");
        this.toolkit = toolkit;
        this.modeller = modeller;
        this.pattern = pattern;
        this.isNested = isNested;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout l = new GridLayout();
        l.numColumns = 3;
        l.marginBottom = 0;
        l.marginHeight = 0;
        l.marginLeft = 0;
        l.marginRight = 0;
        l.marginTop = 0;
        l.marginWidth = 0;
        composite.setLayout((Layout)l);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.createFieldRestrictionCombo(composite, gd);
        this.createMultipleRestrictionCombo(composite, gd);
        this.createFormulaRow(composite, gd);
        if (!this.isNested) {
            this.createVariableBindingRow(composite);
        }
        this.toolkit.paintBordersFor(composite);
        return composite;
    }

    private void createMultipleRestrictionCombo(Composite composite, GridData gd) {
        this.createLabel(composite, "Multiple field constriant");
        final Combo composites = new Combo(composite, 8);
        composites.setLayoutData((Object)gd);
        composites.add("...");
        composites.add("All of (And)");
        composites.add("Any of (Or)");
        composites.setData("All of (And)", (Object)"&&");
        composites.setData("Any of (Or)", (Object)"||");
        composites.select(0);
        composites.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (composites.getSelectionIndex() == 0) {
                    return;
                }
                CompositeFieldConstraint comp = new CompositeFieldConstraint();
                comp.compositeJunctionType = (String)composites.getData(composites.getText());
                AddNewFieldConstraintDialog.this.pattern.addConstraint((FieldConstraint)comp);
                AddNewFieldConstraintDialog.this.modeller.reloadLhs();
                AddNewFieldConstraintDialog.this.modeller.setDirty(true);
                AddNewFieldConstraintDialog.this.close();
            }
        });
    }

    private void createFieldRestrictionCombo(Composite composite, GridData gd) {
        this.createLabel(composite, "Add a restriction on a field");
        SuggestionCompletionEngine engine = this.getCompletion();
        String[] fieldCompletitions = engine.getFieldCompletions(this.pattern.getFactType());
        final Combo fieldsCombo = new Combo(composite, 8);
        fieldsCombo.setLayoutData((Object)gd);
        fieldsCombo.add("...");
        int i = 0;
        while (i < fieldCompletitions.length) {
            String field = fieldCompletitions[i];
            fieldsCombo.add(field);
            fieldsCombo.setData(field, (Object)engine.getFieldType(String.valueOf(this.pattern.getFactType()) + "." + field));
            ++i;
        }
        fieldsCombo.select(0);
        fieldsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (fieldsCombo.getSelectionIndex() == 0) {
                    return;
                }
                SingleFieldConstraint constraint = new SingleFieldConstraint();
                constraint.setFieldName(fieldsCombo.getText());
                constraint.setFieldType((String)fieldsCombo.getData(fieldsCombo.getText()));
                AddNewFieldConstraintDialog.this.pattern.addConstraint((FieldConstraint)constraint);
                AddNewFieldConstraintDialog.this.modeller.setDirty(true);
                AddNewFieldConstraintDialog.this.modeller.reloadLhs();
                AddNewFieldConstraintDialog.this.close();
            }
        });
    }

    private void createFormulaRow(Composite composite, GridData gd) {
        this.createLabel(composite, "Add a new formula style expression");
        Button formulaButton = this.toolkit.createButton(composite, "New formula", 8);
        formulaButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SingleFieldConstraint con = new SingleFieldConstraint();
                con.setConstraintValueType(5);
                AddNewFieldConstraintDialog.this.pattern.addConstraint((FieldConstraint)con);
                AddNewFieldConstraintDialog.this.modeller.setDirty(true);
                AddNewFieldConstraintDialog.this.modeller.reloadLhs();
                AddNewFieldConstraintDialog.this.close();
            }
        });
        formulaButton.setLayoutData((Object)gd);
    }

    private void createVariableBindingRow(Composite composite) {
        this.createLabel(composite, "Variable name");
        final Text variableText = this.createText(composite, "");
        if (this.pattern.getBoundName() != null) {
            variableText.setText(this.pattern.getBoundName());
        }
        Button varButton = this.toolkit.createButton(composite, "Set", 8);
        varButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AddNewFieldConstraintDialog.this.pattern.setBoundName(variableText.getText());
                AddNewFieldConstraintDialog.this.modeller.reloadLhs();
                AddNewFieldConstraintDialog.this.modeller.setDirty(true);
                AddNewFieldConstraintDialog.this.close();
            }
        });
    }

    private SuggestionCompletionEngine getCompletion() {
        return this.modeller.getSuggestionCompletionEngine();
    }
}

