/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.editors.RuleEditor;
import org.drools.eclipse.rulebuilder.ui.ActionInsertFactWidget;
import org.drools.eclipse.rulebuilder.ui.ActionInsertFreeFormLineWidget;
import org.drools.eclipse.rulebuilder.ui.ActionRetractFactWidget;
import org.drools.eclipse.rulebuilder.ui.ActionSetFieldWidget;
import org.drools.eclipse.rulebuilder.ui.AddNewActionDialog;
import org.drools.eclipse.rulebuilder.ui.AddNewConditionDialog;
import org.drools.eclipse.rulebuilder.ui.CompositeFactPatternWidget;
import org.drools.eclipse.rulebuilder.ui.FactPatternWidget;
import org.drools.eclipse.rulebuilder.ui.LHSDSLSentenceWidget;
import org.drools.eclipse.rulebuilder.ui.RHSDSLSentenceWidget;
import org.drools.eclipse.rulebuilder.ui.RuleAttributeWidget;
import org.drools.eclipse.rulebuilder.ui.RuleAttributesDialog;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class RuleModeller {
    private Composite ifComposite;
    private Composite thenComposite;
    private Composite optionsComposite;
    private final ScrolledForm form;
    private final FormToolkit toolkit;
    private RuleModel model;
    private boolean dirty;
    private RuleEditor editor;

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.editor.dirtyPropertyChanged();
    }

    public RuleModeller(ScrolledForm form, FormToolkit toolkit, RuleModel model, RuleEditor editor) {
        this.form = form;
        this.toolkit = toolkit;
        this.model = model;
        this.editor = editor;
        this.setTitleAndFont(form);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.minNumColumns = 1;
        colLayout.maxNumColumns = 1;
        form.getBody().setLayout((Layout)colLayout);
        Shell shell = new Shell(Display.getCurrent());
        AddNewConditionDialog conditionPopup = new AddNewConditionDialog(shell, this);
        AddNewActionDialog actionPopup = new AddNewActionDialog(shell, this);
        RuleAttributesDialog optionsPopup = new RuleAttributesDialog(shell, this);
        Section ifSection = this.createMainSection(form, toolkit, "WHEN", (Window)conditionPopup);
        Section thenSection = this.createMainSection(form, toolkit, "THEN", (Window)actionPopup);
        Section optionsSection = this.createMainSection(form, toolkit, "(options)", (Window)optionsPopup);
        ColumnLayout layout = new ColumnLayout();
        layout.minNumColumns = 1;
        layout.maxNumColumns = 1;
        ((Composite)ifSection.getClient()).setLayout((Layout)layout);
        ((Composite)thenSection.getClient()).setLayout((Layout)layout);
        ((Composite)optionsSection.getClient()).setLayout((Layout)layout);
        ifSection.setLayout((Layout)layout);
        thenSection.setLayout((Layout)layout);
        optionsSection.setLayout((Layout)layout);
        this.ifComposite = (Composite)ifSection.getClient();
        this.thenComposite = (Composite)thenSection.getClient();
        this.optionsComposite = (Composite)optionsSection.getClient();
    }

    private void setTitleAndFont(ScrolledForm form) {
        form.setText("Guided rule editor");
        Font systemFont = form.getDisplay().getSystemFont();
        FontData[] exfds = systemFont.getFontData();
        if (exfds.length > 0) {
            FontData fd = exfds[0];
            fd.setHeight(fd.getHeight() + 2);
            fd.setStyle(1);
            Font f = new Font(systemFont.getDevice(), fd);
            form.setFont(f);
        }
    }

    public SuggestionCompletionEngine getSuggestionCompletionEngine() {
        return this.editor.getCompletionEngine();
    }

    public RuleModel getModel() {
        return this.model;
    }

    public void setModel(RuleModel model) {
        this.model = model;
    }

    private void clearComposite(Composite composite) {
        if (composite != null) {
            Control[] c = composite.getChildren();
            int i = 0;
            while (i < c.length) {
                Control c2 = c[i];
                c2.dispose();
                ++i;
            }
        }
    }

    private void reloadCommon() {
        this.toolkit.paintBordersFor(this.form.getBody());
        this.form.redraw();
        Dialog.applyDialogFont((Control)this.form.getBody());
        this.form.reflow(true);
    }

    public void reloadRhs() {
        this.clearComposite(this.thenComposite);
        this.redrawRhs();
        this.reloadCommon();
    }

    public void reloadLhs() {
        this.clearComposite(this.ifComposite);
        this.redrawLhs();
        this.reloadCommon();
    }

    public void reloadOptions() {
        this.clearComposite(this.optionsComposite);
        this.redrawOptions();
        this.reloadCommon();
    }

    public void reloadWidgets() {
        this.reloadLhs();
        this.reloadRhs();
        this.reloadOptions();
    }

    private void redrawOptions() {
        Composite comp = this.toolkit.createComposite(this.optionsComposite);
        new RuleAttributeWidget(this.toolkit, comp, this);
    }

    private void redrawRhs() {
        int i = 0;
        while (i < this.model.rhs.length) {
            IAction action = this.model.rhs[i];
            if (action instanceof ActionSetField) {
                this.addActionSetFieldWidget(action, i);
            } else if (action instanceof ActionInsertFact) {
                this.addActionInsertFactWidget(action, i);
            } else if (action instanceof ActionRetractFact) {
                this.addActionRetractFactWidget(action, i);
            } else if (action instanceof DSLSentence) {
                this.addRHSDSLSentenceWidget(i, (DSLSentence)action);
            } else if (action instanceof FreeFormLine) {
                this.addFreeFormLine((FreeFormLine)action, i, true);
            }
            ++i;
        }
    }

    private void addFreeFormLine(FreeFormLine action, int i, boolean rhs) {
        Composite comp = null;
        comp = rhs ? this.toolkit.createComposite(this.thenComposite) : this.toolkit.createComposite(this.ifComposite);
        new ActionInsertFreeFormLineWidget(this.toolkit, comp, this, action, i, rhs);
    }

    private void addActionInsertFactWidget(IAction action, int i) {
        Composite comp = this.toolkit.createComposite(this.thenComposite);
        new ActionInsertFactWidget(this.toolkit, comp, this, (ActionInsertFact)action, i);
    }

    private void redrawLhs() {
        IPattern pattern;
        int i = 0;
        while (i < this.model.lhs.length) {
            pattern = this.model.lhs[i];
            if (pattern instanceof FactPattern) {
                this.addFactPatternWidget(i, (FactPattern)pattern);
            }
            if (pattern instanceof CompositeFactPattern) {
                this.addCompositeFactPatternWidget(i, (CompositeFactPattern)pattern);
            } else if (!(pattern instanceof DSLSentence) && pattern instanceof FreeFormLine) {
                this.addFreeFormLine((FreeFormLine)pattern, i, false);
            }
            ++i;
        }
        i = 0;
        while (i < this.model.lhs.length) {
            pattern = this.model.lhs[i];
            if (pattern instanceof DSLSentence) {
                this.addLHSDSLSentenceWidget(i, (DSLSentence)pattern);
            }
            ++i;
        }
    }

    private void addActionRetractFactWidget(IAction action, int i) {
        Composite comp = this.toolkit.createComposite(this.thenComposite);
        new ActionRetractFactWidget(this.toolkit, comp, this, (ActionRetractFact)action, i);
    }

    private void addActionSetFieldWidget(IAction action, int i) {
        Composite comp = this.toolkit.createComposite(this.thenComposite);
        new ActionSetFieldWidget(this.toolkit, comp, this, this.model, (ActionSetField)action, i);
    }

    private void addRHSDSLSentenceWidget(int idx, DSLSentence pattern) {
        Composite comp = this.toolkit.createComposite(this.thenComposite);
        new RHSDSLSentenceWidget(this.toolkit, comp, pattern, this, idx);
    }

    private void addLHSDSLSentenceWidget(int idx, DSLSentence pattern) {
        Composite comp = this.toolkit.createComposite(this.ifComposite);
        new LHSDSLSentenceWidget(this.toolkit, comp, pattern, this, idx);
    }

    private void addCompositeFactPatternWidget(int idx, CompositeFactPattern pattern) {
        Composite comp = this.toolkit.createComposite(this.ifComposite);
        new CompositeFactPatternWidget(this.toolkit, comp, this, pattern, idx);
    }

    private void addFactPatternWidget(int idx, FactPattern pattern) {
        Composite comp = this.toolkit.createComposite(this.ifComposite);
        new FactPatternWidget(this.toolkit, comp, this, pattern, null, idx, true);
    }

    private Section createMainSection(ScrolledForm form, FormToolkit toolkit, String title, Window popup) {
        ColumnLayout layout = new ColumnLayout();
        layout.minNumColumns = 1;
        layout.maxNumColumns = 1;
        Section l1Sect = toolkit.createSection(form.getBody(), 322);
        l1Sect.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        l1Sect.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        l1Sect.setText(title);
        this.createAddToolItem(l1Sect, popup);
        Composite comp = toolkit.createComposite((Composite)l1Sect);
        l1Sect.setClient((Control)comp);
        return l1Sect;
    }

    private void createAddToolItem(Section sect, final Window popup) {
        ToolBar tbar = new ToolBar((Composite)sect, 0x800100);
        ToolItem titem = new ToolItem(tbar, 2);
        titem = new ToolItem(tbar, 8);
        titem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"));
        titem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                popup.open();
            }
        });
        sect.setTextClient((Control)tbar);
    }

    public void refresh() {
        this.ifComposite.layout();
        this.ifComposite.redraw();
        this.thenComposite.layout();
        this.thenComposite.redraw();
        this.optionsComposite.layout();
        this.optionsComposite.redraw();
    }
}

