/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.Entry;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.Sink;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyPreviousTuples {
    private LeftTuple leftTuple;
    private RightTuple rightTuple;
    private Map<RightTupleSink, RightTuple> rightTuples;
    private Map<LeftTupleSink, LeftTuple> leftTuples;

    public ModifyPreviousTuples(LeftTuple leftTuple, RightTuple rightTuple) {
        this.leftTuple = leftTuple;
        this.rightTuple = rightTuple;
    }

    public Map<RightTupleSink, RightTuple> getRightTuples() {
        return this.rightTuples;
    }

    public void setRightTuples(Map<RightTupleSink, RightTuple> rightTuples) {
        this.rightTuples = rightTuples;
    }

    public Map<LeftTupleSink, LeftTuple> getLeftTuples() {
        return this.leftTuples;
    }

    public void setLeftTuples(Map<LeftTupleSink, LeftTuple> leftTuples) {
        this.leftTuples = leftTuples;
    }

    public LeftTuple removeLeftTuple(LeftTupleSink sink) {
        if (this.leftTuple == null && this.leftTuples == null) {
            return null;
        }
        if (this.leftTuples == null) {
            if (this.leftTuple.getLeftTupleSink() == sink) {
                LeftTuple current = this.leftTuple;
                current.setLeftParentPrevious(null);
                this.leftTuple = current.getLeftParentNext();
                current.setLeftParentNext(null);
                return current;
            }
            this.leftTuples = new IdentityHashMap<LeftTupleSink, LeftTuple>();
            LeftTuple next = null;
            while (this.leftTuple != null) {
                next = this.leftTuple.getLeftParentNext();
                this.leftTuple.setLeftParentPrevious(null);
                this.leftTuple.setLeftParentNext(null);
                this.leftTuples.put(this.leftTuple.getLeftTupleSink(), this.leftTuple);
                this.leftTuple = next;
            }
        }
        return this.leftTuples.remove(sink);
    }

    public RightTuple removeRightTuple(RightTupleSink sink) {
        if (this.rightTuple == null && this.rightTuples == null) {
            return null;
        }
        if (this.rightTuples == null) {
            if (this.rightTuple.getRightTupleSink() == sink) {
                RightTuple current = this.rightTuple;
                current.setHandlePrevious(null);
                this.rightTuple = current.getHandleNext();
                current.setHandleNext(null);
                return current;
            }
            this.rightTuples = new IdentityHashMap<RightTupleSink, RightTuple>();
            RightTuple next = null;
            while (this.rightTuple != null) {
                next = this.rightTuple.getHandleNext();
                this.rightTuple.setHandlePrevious(null);
                this.rightTuple.setHandleNext(null);
                this.rightTuples.put(this.rightTuple.getRightTupleSink(), this.rightTuple);
                this.rightTuple = next;
            }
        }
        return this.rightTuples.remove(sink);
    }

    public void retractTuples(PropagationContext context, InternalWorkingMemory workingMemory) {
        Entry current;
        if (this.leftTuples == null) {
            for (current = this.leftTuple; current != null; current = current.getLeftParentNext()) {
                current.getLeftTupleSink().retractLeftTuple((LeftTuple)current, context, workingMemory);
            }
        } else {
            for (Map.Entry<LeftTupleSink, LeftTuple> entry : this.leftTuples.entrySet()) {
                entry.getKey().retractLeftTuple(entry.getValue(), context, workingMemory);
            }
        }
        if (this.rightTuples == null) {
            for (current = this.rightTuple; current != null; current = ((RightTuple)current).getHandleNext()) {
                ((RightTuple)current).getRightTupleSink().retractRightTuple((RightTuple)current, context, workingMemory);
            }
        } else {
            for (Map.Entry<Sink, Entry> entry : this.rightTuples.entrySet()) {
                ((RightTupleSink)entry.getKey()).retractRightTuple((RightTuple)entry.getValue(), context, workingMemory);
            }
        }
    }
}

