/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.compiler.xml.XmlDumper;
import org.drools.definition.process.Node;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.Lane;
import org.jbpm.bpmn2.core.SequenceFlow;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeHandler
extends BaseAbstractHandler
implements Handler {
    protected static final String EOL = System.getProperty("line.separator");

    public AbstractNodeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = true;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(NodeContainer.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Variable.class);
        this.validPeers.add(org.jbpm.workflow.core.Node.class);
        this.validPeers.add(SequenceFlow.class);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Association.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        org.jbpm.workflow.core.Node node = this.createNode(attrs);
        String id = attrs.getValue("id");
        node.setMetaData("UniqueId", (Object)id);
        try {
            id = id.substring(1);
            id = id.substring(id.lastIndexOf("-") + 1);
            String name = attrs.getValue("name");
            node.setName(name);
            node.setId((long)new Integer(id).intValue());
        }
        catch (NumberFormatException e) {
            long newId = 0L;
            NodeContainer nodeContainer = (NodeContainer)parser.getParent();
            for (Node n : nodeContainer.getNodes()) {
                if (n.getId() <= newId) continue;
                newId = n.getId();
            }
            node.setId(++newId);
        }
        return node;
    }

    protected abstract org.jbpm.workflow.core.Node createNode(Attributes var1);

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        org.jbpm.workflow.core.Node node = (org.jbpm.workflow.core.Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        return node;
    }

    protected void handleNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String height;
        String width;
        String y;
        String x = element.getAttribute("x");
        if (x != null && x.length() != 0) {
            try {
                node.setMetaData("x", (Object)new Integer(x));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'x' attribute", parser.getLocator());
            }
        }
        if ((y = element.getAttribute("y")) != null && y.length() != 0) {
            try {
                node.setMetaData("y", (Object)new Integer(y));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'y' attribute", parser.getLocator());
            }
        }
        if ((width = element.getAttribute("width")) != null && width.length() != 0) {
            try {
                node.setMetaData("width", (Object)new Integer(width));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'width' attribute", parser.getLocator());
            }
        }
        if ((height = element.getAttribute("height")) != null && height.length() != 0) {
            try {
                node.setMetaData("height", (Object)new Integer(height));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'height' attribute", parser.getLocator());
            }
        }
    }

    public abstract void writeNode(org.jbpm.workflow.core.Node var1, StringBuilder var2, int var3);

    protected void writeNode(String name, org.jbpm.workflow.core.Node node, StringBuilder xmlDump, int metaDataType) {
        xmlDump.append("    <" + name + " ");
        xmlDump.append("id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)node) + "\" ");
        if (node.getName() != null) {
            xmlDump.append("name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(node.getName()) + "\" ");
        }
        if (metaDataType == 1) {
            Integer x = (Integer)node.getMetaData().get("x");
            Integer y = (Integer)node.getMetaData().get("y");
            Integer width = (Integer)node.getMetaData().get("width");
            Integer height = (Integer)node.getMetaData().get("height");
            if (x != null && x != 0) {
                xmlDump.append("g:x=\"" + x + "\" ");
            }
            if (y != null && y != 0) {
                xmlDump.append("g:y=\"" + y + "\" ");
            }
            if (width != null && width != -1) {
                xmlDump.append("g:width=\"" + width + "\" ");
            }
            if (height != null && height != -1) {
                xmlDump.append("g:height=\"" + height + "\" ");
            }
        }
    }

    protected void endNode(StringBuilder xmlDump) {
        xmlDump.append("/>" + EOL);
    }

    protected void endNode(String name, StringBuilder xmlDump) {
        xmlDump.append("    </" + name + ">" + EOL);
    }

    protected void handleScript(ExtendedNodeImpl node, Element element, String type) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element xmlNode;
            String nodeName;
            if (!(nodeList.item(i) instanceof Element) || !(nodeName = (xmlNode = (Element)nodeList.item(i)).getNodeName()).equals("extensionElements")) continue;
            NodeList subNodeList = xmlNode.getChildNodes();
            for (int j = 0; j < subNodeList.getLength(); ++j) {
                org.w3c.dom.Node subXmlNode = subNodeList.item(j);
                if (!(type + "-script").equals(subXmlNode.getNodeName())) continue;
                ArrayList<DroolsAction> actions = node.getActions(type);
                if (actions == null) {
                    actions = new ArrayList<DroolsAction>();
                    node.setActions(type, actions);
                }
                DroolsAction action = AbstractNodeHandler.extractScript((Element)subXmlNode);
                actions.add(action);
            }
        }
    }

    public static DroolsAction extractScript(Element xmlNode) {
        String dialect = "mvel";
        if ("http://www.java.com/java".equals(xmlNode.getAttribute("scriptFormat"))) {
            dialect = "java";
        }
        NodeList subNodeList = xmlNode.getChildNodes();
        for (int j = 0; j < subNodeList.getLength(); ++j) {
            Element subXmlNode;
            if (!(subNodeList.item(j) instanceof Element) || !"script".equals((subXmlNode = (Element)subNodeList.item(j)).getNodeName())) continue;
            String consequence = subXmlNode.getTextContent();
            DroolsConsequenceAction action = new DroolsConsequenceAction(dialect, consequence);
            return action;
        }
        return new DroolsConsequenceAction("mvel", "");
    }

    protected void writeScripts(ExtendedNodeImpl node, StringBuilder xmlDump) {
        if (node.containsActions()) {
            xmlDump.append("      <extensionElements>" + EOL);
            this.writeScripts("onEntry", node.getActions("onEntry"), xmlDump);
            this.writeScripts("onExit", node.getActions("onExit"), xmlDump);
            xmlDump.append("      </extensionElements>" + EOL);
        }
    }

    protected void writeScripts(String type, List<DroolsAction> actions, StringBuilder xmlDump) {
        if (actions != null && actions.size() > 0) {
            for (DroolsAction action : actions) {
                AbstractNodeHandler.writeScript(action, type, xmlDump);
            }
        }
    }

    public static void writeScript(DroolsAction action, String type, StringBuilder xmlDump) {
        if (action instanceof DroolsConsequenceAction) {
            String consequence;
            String dialect;
            DroolsConsequenceAction consequenceAction = (DroolsConsequenceAction)action;
            xmlDump.append("        <tns:" + type + "-script");
            String name = consequenceAction.getName();
            if (name != null) {
                xmlDump.append(" name=\"" + name + "\"");
            }
            if ("java".equals(dialect = consequenceAction.getDialect())) {
                xmlDump.append(" scriptFormat=\"http://www.java.com/java\"");
            }
            if ((consequence = consequenceAction.getConsequence()) != null) {
                xmlDump.append(">" + EOL + "          <script>" + XmlDumper.replaceIllegalChars((String)consequence.trim()) + "</script>" + EOL);
                xmlDump.append("        </tns:" + type + "-script>" + EOL);
            } else {
                xmlDump.append("/>" + EOL);
            }
        } else {
            throw new IllegalArgumentException("Unknown action " + action);
        }
    }
}

