/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataEnumLoader {
    private final List<String> errors = new ArrayList<String>();
    private final Map<String, String[]> data;

    public DataEnumLoader(String mvelSource) {
        this.data = this.loadEnum(mvelSource);
    }

    private Map<String, String[]> loadEnum(String mvelSource) {
        Object mvelData;
        if (mvelSource == null || mvelSource.trim().equals("")) {
            return Collections.emptyMap();
        }
        mvelSource = mvelSource.startsWith("=") ? mvelSource.substring(1) : "[ " + DataEnumLoader.addCommasForNewLines(mvelSource) + " ]";
        try {
            mvelData = MVEL.eval((String)mvelSource, new HashMap());
        }
        catch (RuntimeException e) {
            this.addError("Unable to load enumeration data.");
            this.addError(e.getMessage());
            this.addError("Error type: " + e.getClass().getName());
            return Collections.emptyMap();
        }
        if (!(mvelData instanceof Map)) {
            this.addError("The expression is not a map, it is a " + mvelData.getClass().getName());
            return Collections.emptyMap();
        }
        Map map = (Map)mvelData;
        HashMap<String, String[]> newMap = new HashMap<String, String[]>();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object list = entry.getValue();
            if (!(list instanceof List) && !(list instanceof String)) {
                if (list == null) {
                    this.addError("The item with " + key + " is null.");
                } else {
                    this.addError("The item with " + key + " is not a list or a string, it is a " + list.getClass().getName());
                }
                return Collections.emptyMap();
            }
            if (list instanceof String) {
                newMap.put(key, new String[]{(String)list});
                continue;
            }
            List items = (List)list;
            String[] newItems = new String[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                Object listItem = items.get(i);
                newItems[i] = !(listItem instanceof String) ? listItem.toString() : (String)listItem;
            }
            newMap.put(key, newItems);
        }
        return newMap;
    }

    public static String addCommasForNewLines(String mvelSource) {
        StringTokenizer st = new StringTokenizer(mvelSource, "\r\n");
        StringBuilder buf = new StringBuilder();
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (st.hasMoreTokens() && line.endsWith(",")) {
                buf.append(line);
            } else {
                buf.append(line);
                if (st.hasMoreTokens()) {
                    buf.append(",");
                }
            }
            if (!st.hasMoreTokens()) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    private void addError(String string) {
        this.errors.add(string);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public Map<String, String[]> getData() {
        return this.data;
    }
}

