/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.actions.DisconnectAction;
import org.guvnor.tools.utils.ActionUtils;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;

public class DeleteAction
implements IObjectActionDelegate {
    private IStructuredSelection selectedItems;
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.selectedItems == null) {
            return;
        }
        String msg = null;
        msg = this.selectedItems.size() == 1 ? MessageFormat.format(Messages.getString("delete.singlefile.confirmation"), ((IFile)this.selectedItems.getFirstElement()).getName()) : MessageFormat.format(Messages.getString("delete.multifile.confirmation"), String.valueOf(this.selectedItems.size()));
        if (!MessageDialog.openConfirm((Shell)this.targetPart.getSite().getShell(), (String)Messages.getString("delete.confirmation.dialog.caption"), (String)msg)) {
            return;
        }
        for (Object oneItem : this.selectedItems) {
            if (!(oneItem instanceof IFile)) continue;
            this.processDelete((IFile)oneItem);
        }
        DisconnectAction dsAction = new DisconnectAction();
        dsAction.disconnect(this.selectedItems);
        PlatformUtils.updateDecoration();
        PlatformUtils.refreshRepositoryView();
    }

    private void processDelete(IFile selectedFile) {
        try {
            GuvnorMetadataProps props = GuvnorMetadataUtils.getGuvnorMetadata((IResource)selectedFile);
            assert (props != null);
            IWebDavClient client = WebDavServerCache.getWebDavClient(props.getRepository());
            if (client == null) {
                client = WebDavClientFactory.createClient(new URL(props.getRepository()));
                WebDavServerCache.cacheWebDavClient(props.getRepository(), client);
            }
            try {
                client.deleteResource(props.getFullpath());
            }
            catch (WebDavException wde) {
                if (wde.getErrorCode() != 401) {
                    throw wde;
                }
                boolean retry = PlatformUtils.getInstance().authenticateForServer(props.getRepository(), client);
                if (retry) {
                    client.deleteResource(props.getFullpath());
                }
            }
        }
        catch (Exception e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean validResourceSet = ActionUtils.checkResourceSet(selection, true);
        if (validResourceSet) {
            action.setEnabled(true);
            this.selectedItems = (IStructuredSelection)selection;
        } else {
            action.setEnabled(false);
            this.selectedItems = null;
        }
    }
}

