/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.core.DroolsLineBreakpoint;
import org.drools.eclipse.debug.core.DroolsThread;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class DroolsDebugTarget
extends JDIDebugTarget {
    private ArrayList fThreads;
    private ThreadStartHandler fThreadStartHandler = null;
    private boolean fSuspended = true;

    public DroolsDebugTarget(ILaunch launch, VirtualMachine jvm, String name, boolean supportTerminate, boolean supportDisconnect, IProcess process, boolean resume) {
        super(launch, jvm, name, supportTerminate, supportDisconnect, process, resume);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        try {
            if (breakpoint instanceof DroolsLineBreakpoint) {
                ((DroolsLineBreakpoint)breakpoint).setJavaBreakpointProperties();
                final DroolsLineBreakpoint d = (DroolsLineBreakpoint)breakpoint;
                if (d.getDialectName().equals("mvel")) {
                    Iterator<ReferenceType> handleriter = this.getVM().classesByName("org.drools.base.mvel.MVELDebugHandler").iterator();
                    if (!handleriter.hasNext()) {
                        ClassPrepareRequest req = this.getEventRequestManager().createClassPrepareRequest();
                        req.addClassFilter("org.drools.base.mvel.MVELDebugHandler");
                        req.setSuspendPolicy(2);
                        this.addJDIEventListener(new IJDIEventListener(){

                            public boolean handleEvent(Event event, JDIDebugTarget target) {
                                DroolsDebugTarget.this.addRemoteBreakpoint(d);
                                return true;
                            }

                            public void wonSuspendVote(Event event, JDIDebugTarget target) {
                            }

                            public void eventSetComplete(Event event, JDIDebugTarget target, boolean suspend, EventSet eventSet) {
                                this.wonSuspendVote(event, target);
                            }

                            public boolean handleEvent(Event event, JDIDebugTarget target, boolean suspendVote, EventSet eventSet) {
                                return this.handleEvent(event, target);
                            }
                        }, req);
                        req.enable();
                        return;
                    }
                    this.addRemoteBreakpoint(d);
                } else {
                    super.breakpointAdded(breakpoint);
                }
            } else {
                super.breakpointAdded(breakpoint);
            }
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
    }

    protected synchronized void initialize() {
        this.setThreadList(new ArrayList(5));
        super.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JDIThread createThread(ThreadReference thread) {
        DroolsThread jdiThread = null;
        try {
            jdiThread = new DroolsThread(this, thread);
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
        if (this.isDisconnected()) {
            return null;
        }
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            this.fThreads.add(jdiThread);
        }
        jdiThread.fireCreationEvent();
        return jdiThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getThreadIterator() {
        List threadList;
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            threadList = (List)this.fThreads.clone();
        }
        return threadList.iterator();
    }

    private boolean hasSuspendedThreads() {
        Iterator it = this.getThreadIterator();
        while (it.hasNext()) {
            IThread thread = (IThread)it.next();
            if (!thread.isSuspended()) continue;
            return true;
        }
        return false;
    }

    public boolean canResume() {
        return (this.isSuspended() || this.hasSuspendedThreads()) && this.isAvailable() && !this.isPerformingHotCodeReplace();
    }

    protected void resume(boolean fireNotification) throws DebugException {
        if (!this.isSuspended() && !this.hasSuspendedThreads() || !this.isAvailable()) {
            return;
        }
        try {
            this.setSuspended(false);
            this.resumeThreads();
            VirtualMachine vm = this.getVM();
            if (vm != null) {
                vm.resume();
            }
            if (fireNotification) {
                this.fireResumeEvent(32);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
            return;
        }
        catch (RuntimeException e) {
            this.setSuspended(true);
            this.fireSuspendEvent(32);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIDebugTarget_exception_resume, e.toString()), e);
        }
    }

    private void setSuspended(boolean suspended) {
        this.fSuspended = suspended;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    private void setThreadList(ArrayList threads) {
        this.fThreads = threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IThread[] getThreads() {
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            return this.fThreads.toArray(new IThread[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllThreads() {
        Iterator itr = this.getThreadIterator();
        while (itr.hasNext()) {
            DroolsThread child = (DroolsThread)((Object)itr.next());
            child.terminated();
        }
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            this.fThreads.clear();
        }
    }

    protected void initializeRequests() {
        this.setThreadStartHandler(new ThreadStartHandler());
        new ThreadDeathHandler();
        new MVELTraceHandler();
    }

    private void disposeThreadHandler() {
        ThreadStartHandler handler = this.getThreadStartHandler2();
        if (handler != null) {
            handler.deleteRequest();
        }
    }

    public boolean hasThreads() {
        return this.fThreads.size() > 0;
    }

    protected ThreadStartHandler getThreadStartHandler2() {
        return this.fThreadStartHandler;
    }

    protected void setThreadStartHandler(ThreadStartHandler threadStartHandler) {
        this.fThreadStartHandler = threadStartHandler;
    }

    public boolean isOutOfSynch() throws DebugException {
        Iterator threads = this.getThreadIterator();
        while (threads.hasNext()) {
            JDIThread thread = (JDIThread)threads.next();
            if (!thread.isOutOfSynch()) continue;
            return true;
        }
        return false;
    }

    public boolean mayBeOutOfSynch() {
        Iterator threads = this.getThreadIterator();
        while (threads.hasNext()) {
            JDIThread thread = (JDIThread)threads.next();
            if (!thread.mayBeOutOfSynch()) continue;
            return true;
        }
        return false;
    }

    public JDIThread findThread(ThreadReference tr) {
        Iterator iter = this.getThreadIterator();
        while (iter.hasNext()) {
            JDIThread thread = (JDIThread)iter.next();
            if (!thread.getUnderlyingThread().equals(tr)) continue;
            return thread;
        }
        return null;
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.isAvailable()) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint instanceof DroolsLineBreakpoint) {
                    ((DroolsLineBreakpoint)breakpoint).setJavaBreakpointProperties();
                    DroolsLineBreakpoint d = (DroolsLineBreakpoint)breakpoint;
                    if (d.getDialectName().equals("mvel")) {
                        this.removeRemoteBreakpoint((DroolsLineBreakpoint)breakpoint, delta);
                    }
                }
                ((JavaBreakpoint)breakpoint).removeFromTarget((JDIDebugTarget)this);
                this.getBreakpoints().remove(breakpoint);
                Iterator threads = this.getThreadIterator();
                while (threads.hasNext()) {
                    ((DroolsThread)((Object)threads.next())).removeCurrentBreakpoint(breakpoint);
                }
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
            }
        }
    }

    protected void suspendThreads() {
        Iterator threads = this.getThreadIterator();
        while (threads.hasNext()) {
            ((DroolsThread)((Object)threads.next())).suspendedByVM();
        }
    }

    protected void resumeThreads() throws DebugException {
        Iterator threads = this.getThreadIterator();
        while (threads.hasNext()) {
            ((DroolsThread)((Object)threads.next())).resumedByVM();
        }
    }

    public void disconnect() throws DebugException {
        if (!this.isAvailable()) {
            return;
        }
        if (!this.canDisconnect()) {
            this.notSupported(JDIDebugModelMessages.JDIDebugTarget_does_not_support_disconnect);
        }
        try {
            this.disposeThreadHandler();
            VirtualMachine vm = this.getVM();
            if (vm != null) {
                vm.dispose();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIDebugTarget_exception_disconnecting, e.toString()), e);
        }
    }

    public void terminate() throws DebugException {
        if (!this.isAvailable()) {
            return;
        }
        if (!this.supportsTerminate()) {
            this.notSupported(JDIDebugModelMessages.JDIDebugTarget_does_not_support_termination);
        }
        try {
            IProcess process;
            this.setTerminating(true);
            this.disposeThreadHandler();
            VirtualMachine vm = this.getVM();
            if (vm != null) {
                vm.exit(1);
            }
            if ((process = this.getProcess()) != null) {
                process.terminate();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.terminated();
        }
        catch (TimeoutException timeoutException) {
            IProcess process = this.getProcess();
            if (process != null && process.isTerminated()) {
                this.terminated();
            } else {
                this.disconnected();
            }
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIDebugTarget_exception_terminating, e.toString()), e);
        }
    }

    public void handleVMStart(VMStartEvent event) {
        if (this.isResumeOnStartup()) {
            try {
                this.setSuspended(true);
                this.resume();
            }
            catch (DebugException e) {
                this.logError((Exception)((Object)e));
            }
        }
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            DroolsThread thread = (DroolsThread)threads[i];
            if (thread.isSuspended()) {
                try {
                    boolean suspended = thread.getUnderlyingThread().isSuspended();
                    if (!suspended) {
                        thread.setRunning(true);
                        thread.fireResumeEvent(32);
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                }
                catch (ObjectCollectedException objectCollectedException) {
                }
                catch (RuntimeException e) {
                    this.logError(e);
                }
            }
            ++i;
        }
    }

    protected void initializeState() {
        List<ThreadReference> threads = null;
        VirtualMachine vm = this.getVM();
        if (vm != null) {
            try {
                threads = vm.allThreads();
            }
            catch (RuntimeException e) {
                this.internalError(e);
            }
            if (threads != null) {
                Iterator<ThreadReference> initialThreads = threads.iterator();
                while (initialThreads.hasNext()) {
                    this.createThread(initialThreads.next());
                }
            }
        }
        if (this.isResumeOnStartup()) {
            this.setSuspended(false);
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        try {
            VirtualMachine vm = this.getVM();
            if (vm != null) {
                vm.suspend();
            }
            this.suspendThreads();
            this.setSuspended(true);
            this.fireSuspendEvent(32);
        }
        catch (RuntimeException e) {
            this.setSuspended(false);
            this.fireResumeEvent(32);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIDebugTarget_exception_suspend, e.toString()), e);
        }
    }

    public void prepareToSuspendByBreakpoint(JavaBreakpoint breakpoint) {
        this.setSuspended(true);
        this.suspendThreads();
    }

    protected void cancelSuspendByBreakpoint(JavaBreakpoint breakpoint) throws DebugException {
        this.setSuspended(false);
        this.resumeThreads();
    }

    public DroolsLineBreakpoint getDroolsBreakpoint(String source) {
        if (source == null) {
            return null;
        }
        for (IJavaBreakpoint element : this.getBreakpoints()) {
            if (!(element instanceof DroolsLineBreakpoint) || !((DroolsLineBreakpoint)element).getDialectName().equals("mvel")) continue;
            DroolsLineBreakpoint l = (DroolsLineBreakpoint)element;
            try {
                l.getLineNumber();
                String matchSource = l.getRuleName();
                if (!source.equals(matchSource) && !l.getFileRuleMappings().containsKey(source)) continue;
                return l;
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    private void addRemoteBreakpoint(DroolsLineBreakpoint d) {
        String sourceName;
        int line;
        try {
            if (!d.isEnabled()) {
                return;
            }
        }
        catch (CoreException e2) {
            this.logError((Exception)((Object)e2));
            return;
        }
        Iterator<ReferenceType> handleriter = this.getVM().classesByName("org.drools.base.mvel.MVELDebugHandler").iterator();
        ReferenceType debugHandlerClass = handleriter.next();
        try {
            line = d.getLineNumber();
            sourceName = d.getTypeName();
        }
        catch (CoreException e1) {
            this.logError((Exception)((Object)e1));
            return;
        }
        ReferenceType refType = debugHandlerClass;
        Method m = refType.methodsByName("registerBreakpoint").iterator().next();
        ArrayList<Value> args = new ArrayList<Value>();
        IntegerValue lineVal = this.getVM().mirrorOf(line);
        StringReference nameVal = this.getVM().mirrorOf(sourceName);
        JDIObjectValue val = (JDIObjectValue)this.newValue(sourceName);
        val.getUnderlyingObject();
        args.add(nameVal);
        args.add(lineVal);
        try {
            ClassType tt = (ClassType)debugHandlerClass;
            IThread[] tharr = this.getThreads();
            ThreadReference t = null;
            int i = 0;
            while (i < tharr.length) {
                IThread th2 = tharr[i];
                ThreadReference th2real = ((DroolsThread)tharr[i]).getUnderlyingThread();
                if (th2real.suspendCount() == 1 && th2.getName().equals("main")) {
                    t = th2real;
                    DroolsThread cfr_ignored_0 = (DroolsThread)th2;
                }
                ++i;
            }
            tt.invokeMethod(t, m, args, 1);
            super.breakpointAdded((IBreakpoint)d);
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void removeRemoteBreakpoint(DroolsLineBreakpoint d, IMarkerDelta delta) {
        String sourceName;
        int line;
        Iterator<ReferenceType> handleriter = this.getVM().classesByName("org.drools.base.mvel.MVELDebugHandler").iterator();
        ReferenceType debugHandlerClass = handleriter.next();
        try {
            line = d.getLineNumber();
            sourceName = d.getTypeName();
        }
        catch (CoreException e1) {
            this.logError((Exception)((Object)e1));
            return;
        }
        ReferenceType refType = debugHandlerClass;
        Method m = refType.methodsByName("removeBreakpoint").iterator().next();
        ArrayList<Value> args = new ArrayList<Value>();
        IntegerValue lineVal = this.getVM().mirrorOf(line);
        StringReference nameVal = this.getVM().mirrorOf(sourceName);
        JDIObjectValue val = (JDIObjectValue)this.newValue(sourceName);
        val.getUnderlyingObject();
        args.add(nameVal);
        args.add(lineVal);
        try {
            ClassType tt = (ClassType)debugHandlerClass;
            IThread[] tharr = this.getThreads();
            ThreadReference t = null;
            int i = 0;
            while (i < tharr.length) {
                IThread th2 = tharr[i];
                ThreadReference th2real = ((DroolsThread)tharr[i]).getUnderlyingThread();
                if (th2real.suspendCount() == 1 && th2.getName().equals("main")) {
                    t = th2real;
                    DroolsThread cfr_ignored_0 = (DroolsThread)th2;
                }
                ++i;
            }
            tt.invokeMethod(t, m, args, 1);
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    class MVELTraceHandler
    implements IJDIEventListener {
        protected MVELTraceHandler() {
            this.createRequest();
        }

        protected void createRequest() {
            EventRequestManager manager = DroolsDebugTarget.this.getEventRequestManager();
            if (manager != null) {
                try {
                    ClassPrepareRequest req = manager.createClassPrepareRequest();
                    req.addClassFilter("org.drools.base.mvel.MVELDebugHandler");
                    req.setSuspendPolicy(2);
                    DroolsDebugTarget.this.addJDIEventListener(this, req);
                    req.enable();
                }
                catch (RuntimeException e) {
                    DroolsDebugTarget.this.logError(e);
                }
            }
        }

        public boolean handleEvent(Event event, JDIDebugTarget target) {
            Location location;
            ClassType classType = (ClassType)((ClassPrepareEvent)event).referenceType();
            classType.name();
            BreakpointRequest req = null;
            List<Method> list = classType.methodsByName("onBreak");
            if (list.size() == 0) {
                throw new IllegalStateException("MVELDebugHandler.onBreak cannot be found by JDI");
            }
            Method method = list.get(0);
            if (method != null && !method.isNative()) {
                location = method.location();
                if (location == null || location.codeIndex() == -1L) {
                    throw new IllegalStateException("MVELDebugHandler.onBreak location cannot be found by JDI");
                }
            } else {
                throw new IllegalStateException("MVELDebugHandler.onBreak cannot be found by JDI");
            }
            req = DroolsDebugTarget.this.getEventRequestManager().createBreakpointRequest(location);
            req.addThreadFilter(((ClassPrepareEvent)event).thread());
            req.setSuspendPolicy(2);
            DroolsDebugTarget.this.addJDIEventListener(new IJDIEventListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean handleEvent(Event event, JDIDebugTarget target) {
                    BreakpointEvent cfr_ignored_0 = (BreakpointEvent)event;
                    try {
                        IThread[] tharr = DroolsDebugTarget.this.getThreads();
                        int i = 0;
                        while (true) {
                            if (i >= tharr.length) {
                                return true;
                            }
                            DroolsThread th2 = (DroolsThread)tharr[i];
                            ThreadReference th2real = ((DroolsThread)tharr[i]).getUnderlyingThread();
                            if (th2real.suspendCount() == 1 && th2.getName().equals("main")) {
                                th2real.suspend();
                                th2.setRunning(false);
                                th2.fireSuspendEvent(32);
                                return true;
                            }
                            ++i;
                        }
                    }
                    catch (Exception t) {
                        DroolsDebugTarget.this.logError(t);
                    }
                    return true;
                }

                public void wonSuspendVote(Event event, JDIDebugTarget target) {
                }

                public void eventSetComplete(Event event, JDIDebugTarget target, boolean suspend, EventSet eventSet) {
                    this.wonSuspendVote(event, target);
                }

                public boolean handleEvent(Event event, JDIDebugTarget target, boolean suspendVote, EventSet eventSet) {
                    return this.handleEvent(event, target);
                }
            }, req);
            req.enable();
            DroolsDebugTarget.this.removeJDIEventListener(this, ((ClassPrepareEvent)event).request());
            return true;
        }

        public void wonSuspendVote(Event event, JDIDebugTarget target) {
        }

        public void eventSetComplete(Event event, JDIDebugTarget target, boolean suspend, EventSet eventSet) {
            this.wonSuspendVote(event, target);
        }

        public boolean handleEvent(Event event, JDIDebugTarget target, boolean suspendVote, EventSet eventSet) {
            return this.handleEvent(event, target);
        }
    }

    class ThreadDeathHandler
    implements IJDIEventListener {
        protected ThreadDeathHandler() {
            this.createRequest();
        }

        protected void createRequest() {
            EventRequestManager manager = DroolsDebugTarget.this.getEventRequestManager();
            if (manager != null) {
                try {
                    ThreadDeathRequest req = manager.createThreadDeathRequest();
                    req.setSuspendPolicy(0);
                    req.enable();
                    DroolsDebugTarget.this.addJDIEventListener(this, req);
                }
                catch (RuntimeException e) {
                    DroolsDebugTarget.this.logError(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleEvent(Event event, JDIDebugTarget target) {
            ThreadReference ref = ((ThreadDeathEvent)event).thread();
            DroolsThread thread = (DroolsThread)DroolsDebugTarget.this.findThread(ref);
            if (thread != null) {
                ArrayList arrayList = DroolsDebugTarget.this.fThreads;
                synchronized (arrayList) {
                    DroolsDebugTarget.this.fThreads.remove((Object)thread);
                }
                thread.terminated();
            }
            return true;
        }

        public void wonSuspendVote(Event event, JDIDebugTarget target) {
        }

        public void eventSetComplete(Event event, JDIDebugTarget target, boolean suspend, EventSet eventSet) {
            this.wonSuspendVote(event, target);
        }

        public boolean handleEvent(Event event, JDIDebugTarget target, boolean suspendVote, EventSet eventSet) {
            return this.handleEvent(event, target);
        }
    }

    class ThreadStartHandler
    implements IJDIEventListener {
        protected EventRequest fRequest;

        protected ThreadStartHandler() {
            this.createRequest();
        }

        protected void createRequest() {
            EventRequestManager manager = DroolsDebugTarget.this.getEventRequestManager();
            if (manager != null) {
                try {
                    ThreadStartRequest req = manager.createThreadStartRequest();
                    req.setSuspendPolicy(0);
                    req.enable();
                    DroolsDebugTarget.this.addJDIEventListener(this, req);
                    this.setRequest(req);
                }
                catch (RuntimeException e) {
                    DroolsDebugTarget.this.logError(e);
                }
            }
        }

        public boolean handleEvent(Event event, JDIDebugTarget target) {
            DroolsThread jdiThread;
            ThreadReference thread = ((ThreadStartEvent)event).thread();
            try {
                if (thread.isCollected()) {
                    return false;
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                return false;
            }
            catch (ObjectCollectedException objectCollectedException) {
                return false;
            }
            catch (TimeoutException timeoutException) {}
            if ((jdiThread = (DroolsThread)DroolsDebugTarget.this.findThread(thread)) == null) {
                jdiThread = (DroolsThread)DroolsDebugTarget.this.createThread(thread);
                if (jdiThread == null) {
                    return false;
                }
            } else {
                jdiThread.disposeStackFrames();
                jdiThread.fireChangeEvent(512);
            }
            return !jdiThread.isSuspended();
        }

        public void wonSuspendVote(Event event, JDIDebugTarget target) {
        }

        protected void deleteRequest() {
            if (this.getRequest() != null) {
                DroolsDebugTarget.this.removeJDIEventListener(this, this.getRequest());
                this.setRequest(null);
            }
        }

        protected EventRequest getRequest() {
            return this.fRequest;
        }

        protected void setRequest(EventRequest request) {
            this.fRequest = request;
        }

        public void eventSetComplete(Event event, JDIDebugTarget target, boolean suspend, EventSet eventSet) {
            this.wonSuspendVote(event, target);
        }

        public boolean handleEvent(Event event, JDIDebugTarget target, boolean suspendVote, EventSet eventSet) {
            return this.handleEvent(event, target);
        }
    }
}

