/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;

public class DroolsLineBreakpoint
extends JavaLineBreakpoint {
    private static final String DIALECT = "org.drools.eclipse.debug.core.breakpointDialect";

    public DroolsLineBreakpoint() {
    }

    public DroolsLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
        super(resource, "", -1, -1, -1, 0, true, DroolsLineBreakpoint.createAttributesMap(lineNumber), "org.drools.eclipse.droolsBreakpointMarker");
        this.setJavaBreakpointProperties();
    }

    private static Map createAttributesMap(int lineNumber) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Drools_DRL_LineNumber", new Integer(lineNumber));
        return map;
    }

    public int getDRLLineNumber() {
        return this.getMarker().getAttribute("Drools_DRL_LineNumber", -1);
    }

    public String getModelIdentifier() {
        return "org.drools.eclipse.debug";
    }

    public String getDialectName() {
        return this.getMarker().getAttribute(DIALECT, "Unknown");
    }

    public Map getFileRuleMappings() {
        String packedInfo = this.getMarker().getAttribute("org.drools.eclipse.debug.DRL_RULES", "");
        return DroolsLineBreakpoint.unpackRuleMapping(packedInfo);
    }

    public void setJavaBreakpointProperties() throws CoreException {
        IMarker marker = this.getMarker();
        int drlLineNumber = this.getDRLLineNumber();
        if (marker.exists()) {
            try {
                DRLInfo drlInfo = DroolsEclipsePlugin.getDefault().parseResource(marker.getResource(), true);
                DRLInfo.RuleInfo[] ruleInfos = drlInfo.getRuleInfos();
                StringBuffer rb = new StringBuffer();
                int i = 0;
                while (i < ruleInfos.length) {
                    int line = ruleInfos[i].getConsequenceDrlLineNumber();
                    String ruleid = String.valueOf(ruleInfos[i].getClassName()) + ":" + line;
                    rb.append(ruleid);
                    if (i < ruleInfos.length - 1) {
                        rb.append(";");
                    }
                    ++i;
                }
                marker.setAttribute("org.drools.eclipse.debug.DRL_RULES", (Object)rb.toString());
                marker.setAttribute("org.eclipse.jdt.debug.core.typeName", (Object)this.getRuleClassName(drlInfo, marker.getResource().toString(), drlLineNumber));
                int ruleLineNumber = this.getRuleLineNumber(drlInfo, marker.getResource().toString(), drlLineNumber);
                marker.setAttribute("lineNumber", ruleLineNumber);
                marker.setAttribute(DIALECT, (Object)this.getDialect(drlInfo, drlLineNumber));
            }
            catch (Throwable t) {
                throw new CoreException((IStatus)new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), 0, "Cannot determine ruleInfo " + marker.getResource() + " " + drlLineNumber, t));
            }
        }
    }

    private String getDialect(DRLInfo info, int drlLineNumber) {
        if (info != null) {
            return info.getRuleInfo(drlLineNumber).getDialectName();
        }
        return null;
    }

    private String getRuleClassName(DRLInfo drlInfo, String resource, int lineNumber) throws CoreException {
        if (drlInfo != null) {
            DRLInfo.RuleInfo ruleInfo = drlInfo.getRuleInfo(lineNumber);
            if (ruleInfo != null) {
                return ruleInfo.getClassName();
            }
            DRLInfo.FunctionInfo functionInfo = drlInfo.getFunctionInfo(lineNumber);
            if (functionInfo != null) {
                return functionInfo.getClassName();
            }
        }
        throw new CoreException((IStatus)new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), 0, "Cannot determine ruleClassName for " + resource + " " + lineNumber, null));
    }

    private int getRuleLineNumber(DRLInfo drlInfo, String resource, int lineNumber) throws CoreException {
        if (drlInfo != null) {
            DRLInfo.RuleInfo ruleInfo = drlInfo.getRuleInfo(lineNumber);
            if (ruleInfo != null && ruleInfo.getConsequenceDrlLineNumber() < lineNumber) {
                int line = ruleInfo.getConsequenceJavaLineNumber() + (lineNumber - ruleInfo.getConsequenceDrlLineNumber());
                if (ruleInfo.getDialectName() != null && ruleInfo.getDialectName().equals("mvel")) {
                    return line;
                }
                return line + 1;
            }
            DRLInfo.FunctionInfo functionInfo = drlInfo.getFunctionInfo(lineNumber);
            if (functionInfo != null) {
                return functionInfo.getJavaLineNumber() + (lineNumber - functionInfo.getDrlLineNumber());
            }
        }
        throw new CoreException((IStatus)new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), 0, "Cannot determine ruleLineNumber for " + resource + " " + lineNumber, null));
    }

    public String getRuleName() {
        IMarker marker = this.getMarker();
        if (marker.exists()) {
            try {
                return (String)marker.getAttribute("org.eclipse.jdt.debug.core.typeName");
            }
            catch (CoreException e) {
                DroolsEclipsePlugin.log(e);
            }
        }
        return null;
    }

    private static final Map unpackRuleMapping(String input) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] rules = input.split("\\;");
        int i = 0;
        while (i < rules.length) {
            if (rules[i].length() > 0) {
                String[] inf = rules[i].split("\\:");
                map.put(inf[0], Integer.valueOf(inf[1]));
            }
            ++i;
        }
        return map;
    }
}

