/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.List;
import java.util.Map;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.ConstraintCompletionProcessor;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowGlobalsDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowImportsDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.MilestoneNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MilestoneConstraintDialog
extends EditBeanDialog<String> {
    private WorkflowProcess process;
    private TabFolder tabFolder;
    private SourceViewer constraintViewer;
    private ConstraintCompletionProcessor completionProcessor;

    public MilestoneConstraintDialog(Shell parentShell, WorkflowProcess process, MilestoneNode milestone) {
        super(parentShell, "Constraint editor");
        this.process = process;
        this.setValue(milestone.getConstraint());
    }

    @Override
    protected String updateValue(String value) {
        if (this.tabFolder.getSelectionIndex() == 0) {
            return this.getConstraintText();
        }
        return null;
    }

    @Override
    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite parent) {
        this.constraintViewer = new SourceViewer(parent, null, 2048);
        this.constraintViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                return null;
            }

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                MilestoneConstraintDialog.this.completionProcessor = new ConstraintCompletionProcessor(MilestoneConstraintDialog.this.process);
                assistant.setContentAssistProcessor((IContentAssistProcessor)MilestoneConstraintDialog.this.completionProcessor, "__dftl_partition_content_type");
                assistant.setProposalPopupOrientation(10);
                return assistant;
            }
        });
        String value = (String)this.getValue();
        if (value == null) {
            value = "";
        }
        Document document = new Document(value);
        this.constraintViewer.setDocument((IDocument)document);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.constraintViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' && e.stateMask == 262144) {
                    MilestoneConstraintDialog.this.constraintViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.constraintViewer.getControl();
    }

    private String getConstraintText() {
        return this.constraintViewer.getDocument().get();
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 2;
        Composite top = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        top.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 3;
        top.setLayout((Layout)layout);
        Button importButton = new Button(top, 8);
        importButton.setText("Imports ...");
        importButton.setFont(JFaceResources.getDialogFont());
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MilestoneConstraintDialog.this.importButtonPressed();
            }
        });
        gd = new GridData();
        importButton.setLayoutData((Object)gd);
        Button globalButton = new Button(top, 8);
        globalButton.setText("Globals ...");
        globalButton.setFont(JFaceResources.getDialogFont());
        globalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MilestoneConstraintDialog.this.globalButtonPressed();
            }
        });
        gd = new GridData();
        globalButton.setLayoutData((Object)gd);
        this.tabFolder = new TabFolder(parent, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gd);
        TabItem textEditorTab = new TabItem(this.tabFolder, 0);
        textEditorTab.setText("Textual Editor");
        textEditorTab.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return this.tabFolder;
    }

    private void importButtonPressed() {
        Runnable r = new Runnable(){

            public void run() {
                RuleFlowImportsDialog dialog = new RuleFlowImportsDialog(MilestoneConstraintDialog.this.getShell(), MilestoneConstraintDialog.this.process);
                dialog.create();
                int code = dialog.open();
                if (code != 1) {
                    List<String> imports = dialog.getImports();
                    MilestoneConstraintDialog.this.process.setImports(imports);
                    List<String> functionImports = dialog.getFunctionImports();
                    MilestoneConstraintDialog.this.process.setFunctionImports(functionImports);
                    MilestoneConstraintDialog.this.completionProcessor.reset();
                }
            }
        };
        r.run();
    }

    private void globalButtonPressed() {
        Runnable r = new Runnable(){

            public void run() {
                RuleFlowGlobalsDialog dialog = new RuleFlowGlobalsDialog(MilestoneConstraintDialog.this.getShell(), MilestoneConstraintDialog.this.process);
                dialog.create();
                int code = dialog.open();
                if (code != 1) {
                    Map<String, String> globals = dialog.getGlobals();
                    MilestoneConstraintDialog.this.process.setGlobals(globals);
                    MilestoneConstraintDialog.this.completionProcessor.reset();
                }
            }
        };
        r.run();
    }
}

