/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.GlobalCompletionProcessor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jbpm.workflow.core.WorkflowProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowGlobalsDialog
extends Dialog {
    private static final Pattern GLOBAL_PATTERN = Pattern.compile("\\n\\s*global\\s+([^\\s;#]+)\\s+([^\\s;#]+);?", 32);
    private WorkflowProcess process;
    private boolean success;
    private TabFolder tabFolder;
    private SourceViewer globalsViewer;
    private Map<String, String> globals;

    public RuleFlowGlobalsDialog(Shell parentShell, WorkflowProcess process) {
        super(parentShell);
        this.process = process;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Globals editor");
    }

    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite parent) {
        this.globalsViewer = new SourceViewer(parent, null, 2048);
        this.globalsViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                return null;
            }

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                GlobalCompletionProcessor completionProcessor = new GlobalCompletionProcessor();
                assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__dftl_partition_content_type");
                assistant.setProposalPopupOrientation(10);
                return assistant;
            }
        });
        Document document = new Document(this.getProcessImports());
        this.globalsViewer.setDocument((IDocument)document);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.globalsViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' && e.stateMask == 262144) {
                    RuleFlowGlobalsDialog.this.globalsViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.globalsViewer.getControl();
    }

    private String getProcessImports() {
        String result = "// define your globals here: e.g. global java.util.List myList\n";
        Map globals = this.process.getGlobals();
        if (globals != null) {
            for (Map.Entry entry : globals.entrySet()) {
                result = String.valueOf(result) + "global " + (String)entry.getValue() + " " + (String)entry.getKey() + "\n";
            }
        }
        return result;
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.tabFolder = new TabFolder(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gd);
        TabItem textEditorTab = new TabItem(this.tabFolder, 0);
        textEditorTab.setText("Globals");
        textEditorTab.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return this.tabFolder;
    }

    protected void okPressed() {
        this.success = true;
        this.updateGlobals();
        super.okPressed();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Map<String, String> getGlobals() {
        return this.globals;
    }

    private void updateGlobals() {
        this.globals = new HashMap<String, String>();
        Matcher matcher = GLOBAL_PATTERN.matcher(this.globalsViewer.getDocument().get());
        while (matcher.find()) {
            this.globals.put(matcher.group(2), matcher.group(1));
        }
    }
}

