/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemManager;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassLoaderUtil;
import org.jbpm.process.workitem.email.EmailWorkItemHandler;
import org.jbpm.task.Content;
import org.jbpm.task.Deadline;
import org.jbpm.task.EmailNotification;
import org.jbpm.task.EmailNotificationHeader;
import org.jbpm.task.Escalation;
import org.jbpm.task.Group;
import org.jbpm.task.Language;
import org.jbpm.task.Notification;
import org.jbpm.task.NotificationType;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.TaskService;
import org.mvel2.templates.TemplateRuntime;

public class DefaultEscalatedDeadlineHandler
implements EscalatedDeadlineHandler {
    private UserInfo userInfo;
    private String from;
    private String replyTo;
    EmailWorkItemHandler handler = new EmailWorkItemHandler();
    WorkItemManager manager;

    public DefaultEscalatedDeadlineHandler(Properties properties) {
        String host = properties.getProperty("mail.smtp.host", "localhost");
        String port = properties.getProperty("mail.smtp.port", "25");
        String user = properties.getProperty("mail.smtp.user");
        String password = properties.getProperty("mail.smtp.password");
        this.from = properties.getProperty("from", null);
        this.replyTo = properties.getProperty("replyTo", null);
        this.handler.setConnection(host, port, user, password);
    }

    public DefaultEscalatedDeadlineHandler() {
        ChainedProperties conf = new ChainedProperties("drools.email.conf", (ClassLoader)ClassLoaderUtil.getClassLoader(null, this.getClass(), (boolean)false));
        String host = conf.getProperty("host", null);
        String port = conf.getProperty("port", "25");
        String user = conf.getProperty("user", null);
        String password = conf.getProperty("password", null);
        this.from = conf.getProperty("from", null);
        this.replyTo = conf.getProperty("replyTo", null);
        this.handler.setConnection(host, port, user, password);
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public WorkItemManager getManager() {
        return this.manager;
    }

    public void setManager(WorkItemManager manager) {
        this.manager = manager;
    }

    @Override
    public void executeEscalatedDeadline(Task task, Deadline deadline, Content content, TaskService service) {
        if (deadline == null || deadline.getEscalations() == null) {
            return;
        }
        for (Escalation escalation : deadline.getEscalations()) {
            if (!escalation.getReassignments().isEmpty()) {
                Reassignment reassignment = escalation.getReassignments().get(0);
                task.getTaskData().setStatus(Status.Ready);
                ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>(reassignment.getPotentialOwners());
                task.getPeopleAssignments().setPotentialOwners(potentialOwners);
                task.getTaskData().setActualOwner(null);
            }
            for (Notification notification : escalation.getNotifications()) {
                if (notification.getNotificationType() != NotificationType.Email) continue;
                this.executeEmailNotification((EmailNotification)notification, task, content);
            }
        }
        deadline.setEscalated(true);
    }

    public void executeEmailNotification(EmailNotification notification, Task task, Content content) {
        HashMap<String, List<User>> users = new HashMap<String, List<User>>();
        for (OrganizationalEntity entity : notification.getBusinessAdministrators()) {
            if (entity instanceof Group) {
                this.buildMapByLanguage(users, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(users, (User)entity);
        }
        for (OrganizationalEntity entity : notification.getRecipients()) {
            if (entity instanceof Group) {
                this.buildMapByLanguage(users, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(users, (User)entity);
        }
        Map doc = null;
        if (content != null) {
            ByteArrayInputStream bs = new ByteArrayInputStream(content.getContent());
            try {
                ObjectInputStream oIn = new ObjectInputStream(bs);
                doc = (Map)oIn.readObject();
                oIn.close();
                bs.close();
            }
            catch (Exception e) {
                doc = (Map)TaskService.eval(new InputStreamReader(new ByteArrayInputStream(content.getContent())));
            }
        } else {
            doc = Collections.emptyMap();
        }
        Map<Language, EmailNotificationHeader> headers = notification.getEmailHeaders();
        for (Map.Entry entry : users.entrySet()) {
            EmailNotificationHeader header = headers.get(new Language((String)entry.getKey()));
            HashMap<String, String> email = new HashMap<String, String>();
            StringBuilder to = new StringBuilder();
            boolean first = true;
            for (User user : (List)entry.getValue()) {
                if (!first) {
                    to.append(';');
                }
                String emailAddress = this.userInfo.getEmailForEntity(user);
                to.append(emailAddress);
                first = false;
            }
            email.put("To", to.toString());
            if (header.getFrom() != null && header.getFrom().trim().length() > 0) {
                email.put("From", header.getFrom());
            } else {
                email.put("From", this.from);
            }
            if (header.getReplyTo() != null && header.getReplyTo().trim().length() > 0) {
                email.put("Reply-To", header.getReplyTo());
            } else {
                email.put("Reply-To", this.replyTo);
            }
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("doc", doc);
            vars.put("processInstanceId", task.getTaskData().getProcessInstanceId());
            vars.put("processSessionId", task.getTaskData().getProcessSessionId());
            vars.put("workItemId", task.getTaskData().getWorkItemId());
            vars.put("expirationTime", task.getTaskData().getExpirationTime());
            vars.put("taskId", task.getId());
            vars.put("owners", task.getPeopleAssignments().getPotentialOwners());
            String subject = (String)TemplateRuntime.eval((String)header.getSubject(), vars);
            String body = (String)TemplateRuntime.eval((String)header.getBody(), vars);
            email.put("Subject", subject);
            email.put("Body", body);
            WorkItemImpl workItem = new WorkItemImpl();
            workItem.setParameters(email);
            this.handler.executeWorkItem((WorkItem)workItem, this.manager);
        }
    }

    private void buildMapByLanguage(Map<String, List<User>> map, Group group) {
        Iterator<OrganizationalEntity> it = this.userInfo.getMembersForGroup(group);
        while (it.hasNext()) {
            OrganizationalEntity entity = it.next();
            if (entity instanceof Group) {
                this.buildMapByLanguage(map, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(map, (User)entity);
        }
    }

    private void buildMapByLanguage(Map<String, List<User>> map, User user) {
        String language = this.userInfo.getLanguageForEntity(user);
        List<User> list = map.get(language);
        if (list == null) {
            list = new ArrayList<User>();
            map.put(language, list);
        }
        list.add(user);
    }
}

